/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

public enum Vector128Shape {
    I8X16(127, 16),
    I16X8(127, 8),
    I32X4(127, 4),
    I64X2(126, 2),
    F32X4(125, 4),
    F64X2(124, 2);

    private final byte unpackedType;
    private final int dimension;

    private Vector128Shape(byte unpackedType, int dimension) {
        this.unpackedType = unpackedType;
        this.dimension = dimension;
    }

    public byte getUnpackedType() {
        return this.unpackedType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public static Vector128Shape ofInstruction(int vectorOpcode) {
        return switch (vectorOpcode) {
            case 13 -> I8X16;
            case 21 -> I8X16;
            case 22 -> I8X16;
            case 23 -> I8X16;
            case 24 -> I16X8;
            case 25 -> I16X8;
            case 26 -> I16X8;
            case 27 -> I32X4;
            case 28 -> I32X4;
            case 29 -> I64X2;
            case 30 -> I64X2;
            case 31 -> F32X4;
            case 32 -> F32X4;
            case 33 -> F64X2;
            case 34 -> F64X2;
            case 14 -> I8X16;
            case 15 -> I8X16;
            case 16 -> I16X8;
            case 17 -> I32X4;
            case 18 -> I64X2;
            case 19 -> F32X4;
            case 20 -> F64X2;
            case 35 -> I8X16;
            case 36 -> I8X16;
            case 37 -> I8X16;
            case 38 -> I8X16;
            case 39 -> I8X16;
            case 40 -> I8X16;
            case 41 -> I8X16;
            case 42 -> I8X16;
            case 43 -> I8X16;
            case 44 -> I8X16;
            case 45 -> I16X8;
            case 46 -> I16X8;
            case 47 -> I16X8;
            case 48 -> I16X8;
            case 49 -> I16X8;
            case 50 -> I16X8;
            case 51 -> I16X8;
            case 52 -> I16X8;
            case 53 -> I16X8;
            case 54 -> I16X8;
            case 55 -> I32X4;
            case 56 -> I32X4;
            case 57 -> I32X4;
            case 58 -> I32X4;
            case 59 -> I32X4;
            case 60 -> I32X4;
            case 61 -> I32X4;
            case 62 -> I32X4;
            case 63 -> I32X4;
            case 64 -> I32X4;
            case 214 -> I64X2;
            case 215 -> I64X2;
            case 216 -> I64X2;
            case 217 -> I64X2;
            case 218 -> I64X2;
            case 219 -> I64X2;
            case 65 -> F32X4;
            case 66 -> F32X4;
            case 67 -> F32X4;
            case 68 -> F32X4;
            case 69 -> F32X4;
            case 70 -> F32X4;
            case 71 -> F64X2;
            case 72 -> F64X2;
            case 73 -> F64X2;
            case 74 -> F64X2;
            case 75 -> F64X2;
            case 76 -> F64X2;
            case 96 -> I8X16;
            case 97 -> I8X16;
            case 98 -> I8X16;
            case 99 -> I8X16;
            case 100 -> I8X16;
            case 101 -> I8X16;
            case 102 -> I8X16;
            case 107 -> I8X16;
            case 108 -> I8X16;
            case 109 -> I8X16;
            case 110 -> I8X16;
            case 111 -> I8X16;
            case 112 -> I8X16;
            case 113 -> I8X16;
            case 114 -> I8X16;
            case 115 -> I8X16;
            case 118 -> I8X16;
            case 119 -> I8X16;
            case 120 -> I8X16;
            case 121 -> I8X16;
            case 123 -> I8X16;
            case 124 -> I16X8;
            case 125 -> I16X8;
            case 128 -> I16X8;
            case 129 -> I16X8;
            case 130 -> I16X8;
            case 131 -> I16X8;
            case 132 -> I16X8;
            case 133 -> I16X8;
            case 134 -> I16X8;
            case 135 -> I16X8;
            case 136 -> I16X8;
            case 137 -> I16X8;
            case 138 -> I16X8;
            case 139 -> I16X8;
            case 140 -> I16X8;
            case 141 -> I16X8;
            case 142 -> I16X8;
            case 143 -> I16X8;
            case 144 -> I16X8;
            case 145 -> I16X8;
            case 146 -> I16X8;
            case 147 -> I16X8;
            case 149 -> I16X8;
            case 150 -> I16X8;
            case 151 -> I16X8;
            case 152 -> I16X8;
            case 153 -> I16X8;
            case 155 -> I16X8;
            case 156 -> I16X8;
            case 157 -> I16X8;
            case 158 -> I16X8;
            case 159 -> I16X8;
            case 126 -> I32X4;
            case 127 -> I32X4;
            case 160 -> I32X4;
            case 161 -> I32X4;
            case 163 -> I32X4;
            case 164 -> I32X4;
            case 167 -> I32X4;
            case 168 -> I32X4;
            case 169 -> I32X4;
            case 170 -> I32X4;
            case 171 -> I32X4;
            case 172 -> I32X4;
            case 173 -> I32X4;
            case 174 -> I32X4;
            case 177 -> I32X4;
            case 181 -> I32X4;
            case 182 -> I32X4;
            case 183 -> I32X4;
            case 184 -> I32X4;
            case 185 -> I32X4;
            case 186 -> I32X4;
            case 188 -> I32X4;
            case 189 -> I32X4;
            case 190 -> I32X4;
            case 191 -> I32X4;
            case 192 -> I64X2;
            case 193 -> I64X2;
            case 195 -> I64X2;
            case 196 -> I64X2;
            case 199 -> I64X2;
            case 200 -> I64X2;
            case 201 -> I64X2;
            case 202 -> I64X2;
            case 203 -> I64X2;
            case 204 -> I64X2;
            case 205 -> I64X2;
            case 206 -> I64X2;
            case 209 -> I64X2;
            case 213 -> I64X2;
            case 220 -> I64X2;
            case 221 -> I64X2;
            case 222 -> I64X2;
            case 223 -> I64X2;
            case 103 -> F32X4;
            case 104 -> F32X4;
            case 105 -> F32X4;
            case 106 -> F32X4;
            case 224 -> F32X4;
            case 225 -> F32X4;
            case 227 -> F32X4;
            case 228 -> F32X4;
            case 229 -> F32X4;
            case 230 -> F32X4;
            case 231 -> F32X4;
            case 232 -> F32X4;
            case 233 -> F32X4;
            case 234 -> F32X4;
            case 235 -> F32X4;
            case 116 -> F64X2;
            case 117 -> F64X2;
            case 122 -> F64X2;
            case 148 -> F64X2;
            case 236 -> F64X2;
            case 237 -> F64X2;
            case 239 -> F64X2;
            case 240 -> F64X2;
            case 241 -> F64X2;
            case 242 -> F64X2;
            case 243 -> F64X2;
            case 244 -> F64X2;
            case 245 -> F64X2;
            case 246 -> F64X2;
            case 247 -> F64X2;
            case 248 -> I32X4;
            case 249 -> I32X4;
            case 250 -> F32X4;
            case 251 -> F32X4;
            case 252 -> I32X4;
            case 253 -> I32X4;
            case 254 -> F64X2;
            case 255 -> F64X2;
            case 94 -> F32X4;
            case 95 -> F64X2;
            default -> null;
        };
    }

    public String toString() {
        return super.toString().toLowerCase();
    }
}

