/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import org.graalvm.wasm.api.Sequence;

@GeneratedBy(value=Sequence.class)
public final class SequenceGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private SequenceGen() {
    }

    static {
        LibraryExport.register(Sequence.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=Sequence.class)
    public static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, Sequence.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof Sequence);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof Sequence);
            return new Cached(receiver);
        }

        @GeneratedBy(value=Sequence.class)
        public static class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            private final Class<? extends Sequence<?>> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((Sequence)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)receiver).hasArrayElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)receiver).getArraySize();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)receiver).isArrayElementReadable(index);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)receiver).isArrayElementModifiable(index);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)receiver).isArrayElementInsertable(index);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)receiver).readArrayElement(index);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object receiver, long index, Object value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((Sequence)receiver).writeArrayElement(index, value);
            }
        }

        @GeneratedBy(value=Sequence.class)
        public static class Cached
        extends InteropLibrary {
            private final Class<? extends Sequence<?>> receiverClass_;

            protected Cached(Object receiver) {
                Sequence castReceiver = (Sequence)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).hasArrayElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getArraySize();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isArrayElementReadable(index);
            }

            public boolean isArrayElementModifiable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isArrayElementModifiable(index);
            }

            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isArrayElementInsertable(index);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((Sequence)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).readArrayElement(index);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object receiver, long index, Object value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((Sequence)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).writeArrayElement(index, value);
            }
        }
    }
}

