/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.api.dsl.GeneratedBy;
import java.util.Iterator;
import java.util.List;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.wasm.WasmOptions;

@GeneratedBy(value=WasmOptions.class)
final class WasmOptionsOptionDescriptors
implements TruffleOptionDescriptors {
    WasmOptionsOptionDescriptors() {
    }

    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "wasm.AsyncParsingBinarySize": {
                return OptionDescriptor.newBuilder(WasmOptions.AsyncParsingBinarySize, (String)"wasm.AsyncParsingBinarySize").deprecated(false).help("The minimal binary size for which to use async parsing. If threads are not supported, async parsing will not be used.").usageSyntax("[0, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "wasm.AsyncParsingStackSize": {
                return OptionDescriptor.newBuilder(WasmOptions.AsyncParsingStackSize, (String)"wasm.AsyncParsingStackSize").deprecated(false).help("The stack size in kilobytes to use during async parsing, or zero to use defaults.").usageSyntax("[0, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "wasm.Builtins": {
                return OptionDescriptor.newBuilder(WasmOptions.Builtins, (String)"wasm.Builtins").deprecated(false).help("A comma-separated list of builtin modules to use.").usageSyntax("[<linkingName>:]<builtinModuleName>,[<linkingName>:]<builtinModuleName>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "wasm.BulkMemoryAndRefTypes": {
                return OptionDescriptor.newBuilder(WasmOptions.BulkMemoryAndRefTypes, (String)"wasm.BulkMemoryAndRefTypes").deprecated(false).help("Enable bulk-memory operations and support for reference types").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.DebugCompDirectory": {
                return OptionDescriptor.newBuilder(WasmOptions.DebugCompDirectory, (String)"wasm.DebugCompDirectory").deprecated(false).help("Test dir used for testing the debugger.").usageSyntax("<dir>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.ExtendedConstExpressions": {
                return OptionDescriptor.newBuilder(WasmOptions.ExtendedConstExpressions, (String)"wasm.ExtendedConstExpressions").deprecated(false).help("Enable support for extended const expressions").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.Memory64": {
                return OptionDescriptor.newBuilder(WasmOptions.Memory64, (String)"wasm.Memory64").deprecated(false).help("Enable support for 64-bit memory addresses (More details at https://github.com/WebAssembly/memory64/blob/main/proposals/memory64/Overview.md)").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.MemoryOverheadMode": {
                return OptionDescriptor.newBuilder(WasmOptions.MemoryOverheadMode, (String)"wasm.MemoryOverheadMode").deprecated(false).help("In this mode memories and tables are not initialized.").usageSyntax("false|true").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.MultiMemory": {
                return OptionDescriptor.newBuilder(WasmOptions.MultiMemory, (String)"wasm.MultiMemory").deprecated(false).help("Enable support for multiple memories within a single module").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.MultiValue": {
                return OptionDescriptor.newBuilder(WasmOptions.MultiValue, (String)"wasm.MultiValue").deprecated(false).help("Enable multi-value support").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.SIMD": {
                return OptionDescriptor.newBuilder(WasmOptions.SIMD, (String)"wasm.SIMD").deprecated(false).help("Enable support for the v128 type and vector instructions").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.SaturatingFloatToInt": {
                return OptionDescriptor.newBuilder(WasmOptions.SaturatingFloatToInt, (String)"wasm.SaturatingFloatToInt").deprecated(false).help("Use saturating-float-to-int conversion").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.SignExtensionOps": {
                return OptionDescriptor.newBuilder(WasmOptions.SignExtensionOps, (String)"wasm.SignExtensionOps").deprecated(false).help("Use sign-extension operators").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.StoreConstantsPolicy": {
                return OptionDescriptor.newBuilder(WasmOptions.StoreConstantsPolicy, (String)"wasm.StoreConstantsPolicy").deprecated(true).deprecationMessage("").help("Whenever to store the constants in a pool or not. Deprecated: no longer has any effect.").usageSyntax("NONE|ALL|LARGE_ONLY").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.Threads": {
                return OptionDescriptor.newBuilder(WasmOptions.Threads, (String)"wasm.Threads").deprecated(false).help("Enable support for threads and atomics").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.UseUnsafeMemory": {
                return OptionDescriptor.newBuilder(WasmOptions.UseUnsafeMemory, (String)"wasm.UseUnsafeMemory").deprecated(false).help("Use sun.misc.Unsafe-based memory.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.WasiConstantRandomGet": {
                return OptionDescriptor.newBuilder(WasmOptions.WasiConstantRandomGet, (String)"wasm.WasiConstantRandomGet").deprecated(false).help("Make WASI random_get always return the same random numbers. For testing purpose only.").usageSyntax("false|true").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "wasm.WasiMapDirs": {
                return OptionDescriptor.newBuilder(WasmOptions.WasiMapDirs, (String)"wasm.WasiMapDirs").deprecated(false).help("A comma-separated list of pre-opened Wasi directories.").usageSyntax("[<virtualDir>::]<hostDir>,[<virtualDir>::]<hostDir>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
        }
        return null;
    }

    public SandboxPolicy getSandboxPolicy(String optionName) {
        assert (this.get(optionName) != null) : "Unknown option " + optionName;
        return SandboxPolicy.TRUSTED;
    }

    public Iterator<OptionDescriptor> iterator() {
        return List.of(OptionDescriptor.newBuilder(WasmOptions.AsyncParsingBinarySize, (String)"wasm.AsyncParsingBinarySize").deprecated(false).help("The minimal binary size for which to use async parsing. If threads are not supported, async parsing will not be used.").usageSyntax("[0, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(WasmOptions.AsyncParsingStackSize, (String)"wasm.AsyncParsingStackSize").deprecated(false).help("The stack size in kilobytes to use during async parsing, or zero to use defaults.").usageSyntax("[0, inf)").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(WasmOptions.Builtins, (String)"wasm.Builtins").deprecated(false).help("A comma-separated list of builtin modules to use.").usageSyntax("[<linkingName>:]<builtinModuleName>,[<linkingName>:]<builtinModuleName>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(WasmOptions.BulkMemoryAndRefTypes, (String)"wasm.BulkMemoryAndRefTypes").deprecated(false).help("Enable bulk-memory operations and support for reference types").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.DebugCompDirectory, (String)"wasm.DebugCompDirectory").deprecated(false).help("Test dir used for testing the debugger.").usageSyntax("<dir>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.ExtendedConstExpressions, (String)"wasm.ExtendedConstExpressions").deprecated(false).help("Enable support for extended const expressions").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.Memory64, (String)"wasm.Memory64").deprecated(false).help("Enable support for 64-bit memory addresses (More details at https://github.com/WebAssembly/memory64/blob/main/proposals/memory64/Overview.md)").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.MemoryOverheadMode, (String)"wasm.MemoryOverheadMode").deprecated(false).help("In this mode memories and tables are not initialized.").usageSyntax("false|true").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.MultiMemory, (String)"wasm.MultiMemory").deprecated(false).help("Enable support for multiple memories within a single module").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.MultiValue, (String)"wasm.MultiValue").deprecated(false).help("Enable multi-value support").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.SIMD, (String)"wasm.SIMD").deprecated(false).help("Enable support for the v128 type and vector instructions").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.SaturatingFloatToInt, (String)"wasm.SaturatingFloatToInt").deprecated(false).help("Use saturating-float-to-int conversion").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.SignExtensionOps, (String)"wasm.SignExtensionOps").deprecated(false).help("Use sign-extension operators").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.StoreConstantsPolicy, (String)"wasm.StoreConstantsPolicy").deprecated(true).deprecationMessage("").help("Whenever to store the constants in a pool or not. Deprecated: no longer has any effect.").usageSyntax("NONE|ALL|LARGE_ONLY").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.Threads, (String)"wasm.Threads").deprecated(false).help("Enable support for threads and atomics").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.UseUnsafeMemory, (String)"wasm.UseUnsafeMemory").deprecated(false).help("Use sun.misc.Unsafe-based memory.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.WasiConstantRandomGet, (String)"wasm.WasiConstantRandomGet").deprecated(false).help("Make WASI random_get always return the same random numbers. For testing purpose only.").usageSyntax("false|true").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(WasmOptions.WasiMapDirs, (String)"wasm.WasiMapDirs").deprecated(false).help("A comma-separated list of pre-opened Wasi directories.").usageSyntax("[<virtualDir>::]<hostDir>,[<virtualDir>::]<hostDir>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build()).iterator();
    }
}

