/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.profiler.CPUTracer;
import com.oracle.truffle.tools.profiler.impl.CPUTracerCLI;
import com.oracle.truffle.tools.profiler.impl.CPUTracerCLIOptionDescriptors;
import com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import com.oracle.truffle.tools.profiler.impl.WildcardFilter;
import java.io.PrintStream;
import java.lang.reflect.Method;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;

@TruffleInstrument.Registration(id="cputracer", name="CPU Tracer", version="0.3.0", services={CPUTracer.class}, website="https://www.graalvm.org/tools/profiling/")
public class CPUTracerInstrument
extends TruffleInstrument {
    public static final String ID = "cputracer";
    static final String VERSION = "0.3.0";
    private boolean enabled;
    private CPUTracer tracer;
    private static final ProfilerToolFactory<CPUTracer> factory = CPUTracerInstrument.getDefaultFactory();

    private static ProfilerToolFactory<CPUTracer> getDefaultFactory() {
        try {
            Method createFactory = CPUTracer.class.getDeclaredMethod("createFactory", new Class[0]);
            createFactory.setAccessible(true);
            return (ProfilerToolFactory)createFactory.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static CPUTracer getTracer(Engine engine) {
        Instrument instrument = (Instrument)engine.getInstruments().get(ID);
        if (instrument == null) {
            throw new IllegalStateException("Tracer is not installed.");
        }
        return (CPUTracer)instrument.lookup(CPUTracer.class);
    }

    protected void onCreate(TruffleInstrument.Env env) {
        this.tracer = factory.create(env);
        this.enabled = (Boolean)env.getOptions().get(CPUTracerCLI.ENABLED);
        if (this.enabled) {
            try {
                this.tracer.setFilter(CPUTracerInstrument.getSourceSectionFilter(env));
            }
            catch (IllegalArgumentException e) {
                new PrintStream(env.err()).println("cputracer error: " + e.getMessage());
                this.enabled = false;
                this.tracer.setCollecting(false);
                env.registerService((Object)this.tracer);
                return;
            }
            this.tracer.setCollecting(true);
        }
        env.registerService((Object)this.tracer);
    }

    private static SourceSectionFilter getSourceSectionFilter(TruffleInstrument.Env env) {
        boolean roots = (Boolean)env.getOptions().get(CPUTracerCLI.TRACE_ROOTS);
        boolean statements = (Boolean)env.getOptions().get(CPUTracerCLI.TRACE_STATEMENTS);
        boolean calls = (Boolean)env.getOptions().get(CPUTracerCLI.TRACE_CALLS);
        boolean internals = (Boolean)env.getOptions().get(CPUTracerCLI.TRACE_INTERNAL);
        WildcardFilter filterRootName = (WildcardFilter)env.getOptions().get(CPUTracerCLI.FILTER_ROOT);
        WildcardFilter filterFile = (WildcardFilter)env.getOptions().get(CPUTracerCLI.FILTER_FILE);
        String filterMimeType = (String)env.getOptions().get(CPUTracerCLI.FILTER_MIME_TYPE);
        String filterLanguage = (String)env.getOptions().get(CPUTracerCLI.FILTER_LANGUAGE);
        return CPUTracerCLI.buildFilter(roots, statements, calls, internals, filterRootName, filterFile, filterMimeType, filterLanguage);
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new CPUTracerCLIOptionDescriptors();
    }

    protected void onDispose(TruffleInstrument.Env env) {
        if (this.enabled) {
            CPUTracerCLI.handleOutput(env, this.tracer);
            this.tracer.close();
        }
    }
}

