/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import org.graalvm.shadowed.org.json.JSONObject;

public final class RuntimeCallFrame {
    private final String functionName;
    private final int scriptId;
    private final String url;
    private final int line;
    private final int column;

    public RuntimeCallFrame(String functionName, int scriptId, String url, int line, int column) {
        this.functionName = functionName;
        this.scriptId = scriptId;
        this.url = url;
        this.line = line;
        this.column = column;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getScriptId() {
        return this.scriptId;
    }

    public String getUrl() {
        return this.url;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("functionName", (Object)this.functionName);
        json.put("scriptId", (Object)Integer.toString(this.scriptId));
        json.put("url", (Object)this.url);
        json.put("lineNumber", this.line - 1);
        json.put("columnNumber", this.column - 1);
        return json;
    }
}

