/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugStackTraceElement;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.ScriptsHandler;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import com.oracle.truffle.tools.chromeinspector.types.StackTrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.shadowed.org.json.JSONObject;

public final class ExceptionDetails {
    private static final AtomicLong LAST_ID = new AtomicLong(0L);
    private final DebugException debugException;
    private final String errorMessage;
    private final long exceptionId;

    public ExceptionDetails(DebugException debugException) {
        this.debugException = debugException;
        this.errorMessage = debugException.getLocalizedMessage();
        this.exceptionId = LAST_ID.incrementAndGet();
    }

    public ExceptionDetails(String errorMessage) {
        this.debugException = null;
        this.errorMessage = errorMessage;
        this.exceptionId = LAST_ID.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject createJSON(InspectorExecutionContext context) {
        SourceSection throwLocation;
        JSONObject json = new JSONObject();
        json.put("exceptionId", this.exceptionId);
        if (this.debugException == null || this.debugException.getCatchLocation() != null) {
            json.put("text", (Object)"Caught");
        } else {
            json.put("text", (Object)"Uncaught");
        }
        SourceSection sourceSection = throwLocation = this.debugException != null ? this.debugException.getThrowLocation() : null;
        if (throwLocation != null) {
            int scriptId;
            json.put("lineNumber", throwLocation.getStartLine() - 1);
            json.put("columnNumber", throwLocation.getStartColumn() - 1);
            ScriptsHandler sch = context.acquireScriptsHandler();
            try {
                scriptId = sch.getScriptId(throwLocation.getSource());
            }
            finally {
                context.releaseScriptsHandler();
            }
            if (scriptId >= 0) {
                json.put("scriptId", (Object)Integer.toString(scriptId));
            } else {
                ScriptsHandler scriptsHandler = context.acquireScriptsHandler();
                try {
                    json.put("url", (Object)scriptsHandler.getSourceURL(throwLocation.getSource()));
                }
                finally {
                    context.releaseScriptsHandler();
                }
            }
        }
        if (this.debugException != null) {
            List<List<DebugStackTraceElement>> stacks;
            List stack = this.debugException.getDebugStackTrace();
            List asyncStacks = this.debugException.getDebugAsynchronousStacks();
            if (asyncStacks.isEmpty()) {
                stacks = Collections.singletonList(stack);
            } else {
                stacks = new ArrayList<List>();
                stacks.add(stack);
                stacks.addAll(asyncStacks);
            }
            StackTrace stackTrace = new StackTrace(context, stacks);
            json.put("stackTrace", (Object)stackTrace.toJSON());
        }
        DebugValue exceptionObject = this.debugException != null ? this.debugException.getExceptionObject() : null;
        String description = ExceptionDetails.createDescriptionWithStackTrace(context, this.errorMessage, this.debugException != null ? this.debugException.getDebugStackTrace() : null);
        if (exceptionObject != null) {
            RemoteObject ro = context.createAndRegister(exceptionObject, false);
            JSONObject exc = ro.toJSON();
            exc.put("description", (Object)description);
            exc.put("subtype", (Object)"error");
            json.put("exception", (Object)exc);
        } else {
            JSONObject ex = new JSONObject();
            ex.put("description", (Object)description);
            ex.put("value", (Object)this.errorMessage);
            ex.put("type", (Object)"string");
            json.put("exception", (Object)ex);
        }
        json.put("executionContextId", context.getId());
        return json;
    }

    private static String createDescriptionWithStackTrace(InspectorExecutionContext context, String message, List<DebugStackTraceElement> stack) {
        if (stack == null) {
            return message;
        }
        StringBuilder b = new StringBuilder(message == null ? "null" : message);
        for (DebugStackTraceElement element : stack) {
            if (!context.isInspectInternal() && element.isInternal()) continue;
            b.append("\n    at ");
            String name = element.getName();
            if (name != null) {
                b.append(name);
                b.append(' ');
            }
            b.append('(');
            SourceSection sourceSection = element.getSourceSection();
            if (sourceSection != null && sourceSection.getSource() != null) {
                String path = sourceSection.getSource().getPath();
                if (path == null) {
                    path = sourceSection.getSource().getName();
                }
                b.append(path);
                b.append(':');
                if (sourceSection.hasLines()) {
                    b.append(sourceSection.getStartLine());
                    if (sourceSection.hasColumns()) {
                        b.append(':');
                        b.append(sourceSection.getStartColumn());
                    }
                } else {
                    b.append('?');
                }
            } else {
                b.append("Unknown");
            }
            b.append(')');
        }
        return b.toString();
    }

    public static void resetIDs() {
        LAST_ID.set(0L);
    }
}

