/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.tools.chromeinspector.objects.AbstractInspectorArray;
import com.oracle.truffle.tools.chromeinspector.objects.JSONTruffleObject;
import org.graalvm.shadowed.org.json.JSONArray;

public final class JSONTruffleArray
extends AbstractInspectorArray {
    private final JSONArray json;

    public JSONTruffleArray(JSONArray json) {
        this.json = json;
    }

    @Override
    int getArraySize() {
        return this.json.length();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    Object readArrayElement(long index) throws InvalidArrayIndexException {
        if (index < 0L || index >= (long)this.json.length()) {
            throw InvalidArrayIndexException.create((long)index);
        }
        Object value = this.json.get((int)index);
        return JSONTruffleObject.getTruffleValueFromJSONValue(value);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    void writeArrayElement(long index, Object value) throws InvalidArrayIndexException {
        if (!this.isArrayElementModifiable(index)) {
            throw InvalidArrayIndexException.create((long)index);
        }
        this.json.put((int)index, value);
    }

    @Override
    boolean isArrayElementModifiable(long index) {
        return index >= 0L && index < (long)this.getArraySize();
    }

    @Override
    TriState isIdenticalOrUndefined(Object other) {
        if (other instanceof JSONTruffleArray) {
            JSONTruffleArray otherArray = (JSONTruffleArray)other;
            return TriState.valueOf((this.json == otherArray.json ? 1 : 0) != 0);
        }
        return TriState.UNDEFINED;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    int identityHashCode() {
        return this.json.hashCode();
    }
}

