/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.commands;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import java.util.Optional;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public final class Params {
    private final JSONObject json;

    public Params(JSONObject json) {
        this.json = json;
    }

    public static Params createContext(long id, String name) {
        JSONObject params = new JSONObject();
        JSONObject context = new JSONObject();
        context.put("id", id);
        context.put("name", (Object)name);
        context.put("origin", (Object)"");
        params.put("context", (Object)context);
        return new Params(params);
    }

    public static Params createContextId(long id) {
        JSONObject params = new JSONObject();
        params.put("executionContextId", id);
        return new Params(params);
    }

    public static Params createConsoleAPICalled(String type, Object text, long contextId) {
        JSONObject params = new JSONObject();
        params.put("type", (Object)type);
        JSONArray args = new JSONArray();
        if (text != null) {
            JSONObject outObject = new JSONObject();
            Object value = text;
            if (InteropLibrary.getUncached().isString(text)) {
                outObject.put("type", (Object)"string");
                try {
                    value = InteropLibrary.getUncached().asString(text);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {}
            } else if (text instanceof Number) {
                outObject.put("type", (Object)"number");
            }
            outObject.put("value", value);
            args.put((Object)outObject);
        }
        params.put("args", (Object)args);
        params.put("executionContextId", contextId);
        params.put("timestamp", (double)System.nanoTime() / 1000000.0);
        return new Params(params);
    }

    public JSONObject getJSONObject() {
        return this.json;
    }

    public String[] getPatterns() {
        if (this.json.has("patterns")) {
            JSONArray patterns = this.json.getJSONArray("patterns");
            return patterns.toList().toArray(new String[patterns.length()]);
        }
        return new String[0];
    }

    public long getSamplingInterval() {
        if (this.json.has("interval")) {
            return this.json.getLong("interval");
        }
        return -1L;
    }

    public int getMaxDepth() {
        if (this.json.has("maxDepth")) {
            return this.json.getInt("maxDepth");
        }
        return 0;
    }

    public String getState() {
        if (this.json.has("state")) {
            return this.json.getString("state");
        }
        return "none";
    }

    public String getScriptId() {
        if (this.json.has("scriptId")) {
            return this.json.getString("scriptId");
        }
        return null;
    }

    public Optional<Boolean> getBoolean(String name) {
        if (this.json.has(name)) {
            return Optional.of(this.json.getBoolean(name));
        }
        return Optional.empty();
    }

    public String getBreakpointId() {
        if (this.json.has("breakpointId")) {
            return this.json.getString("breakpointId");
        }
        return null;
    }
}

