/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObjectCleaner;

public final class NativeIsolate {
    static final int CLOSED = -1;
    private static final long NULL = 0L;
    private static final Map<Long, NativeIsolate> isolates = new ConcurrentHashMap<Long, NativeIsolate>();
    private static final AtomicInteger UUIDS = new AtomicInteger(0);
    private final long uuid;
    private final long isolateId;
    private final JNIConfig config;
    private final ThreadLocal<NativeIsolateThread> attachedIsolateThread;
    private final Collection<NativeIsolateThread> threads;
    final Set<NativeObjectCleaner<?>> cleaners;
    private volatile State state;

    private NativeIsolate(long isolateId, JNIConfig config) {
        if (isolateId == 0L) {
            throw new IllegalArgumentException("Isolate address must be non NULL");
        }
        this.uuid = UUIDS.incrementAndGet();
        this.isolateId = isolateId;
        this.config = config;
        this.cleaners = Collections.newSetFromMap(new ConcurrentHashMap());
        this.threads = new ArrayList<NativeIsolateThread>();
        this.attachedIsolateThread = config.getThreadLocalFactory().apply(() -> null);
        this.state = State.ACTIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNativeThread(long isolateThreadId) {
        NativeIsolateThread nativeIsolateThread = this.attachedIsolateThread.get();
        if (nativeIsolateThread != null) {
            throw new IllegalStateException(String.format("Native thread %s is already attached to isolate %s.", Thread.currentThread(), this));
        }
        NativeIsolate nativeIsolate = this;
        synchronized (nativeIsolate) {
            if (!this.state.isValid()) {
                throw this.throwClosedException();
            }
            nativeIsolateThread = new NativeIsolateThread(Thread.currentThread(), this, true, isolateThreadId);
            this.threads.add(nativeIsolateThread);
            this.attachedIsolateThread.set(nativeIsolateThread);
        }
    }

    public NativeIsolateThread enter() {
        NativeIsolateThread nativeIsolateThread = this.getOrCreateNativeIsolateThread();
        if (nativeIsolateThread != null && nativeIsolateThread.enter()) {
            return nativeIsolateThread;
        }
        throw this.throwClosedException();
    }

    public NativeIsolateThread tryEnter() {
        NativeIsolateThread nativeIsolateThread = this.getOrCreateNativeIsolateThread();
        if (nativeIsolateThread != null && nativeIsolateThread.enter()) {
            return nativeIsolateThread;
        }
        return null;
    }

    public boolean isActive() {
        NativeIsolateThread nativeIsolateThread = this.attachedIsolateThread.get();
        return nativeIsolateThread != null && (nativeIsolateThread.isNativeThread() || nativeIsolateThread.isActive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        NativeIsolateThread currentIsolateThread = this.attachedIsolateThread.get();
        if (currentIsolateThread != null && currentIsolateThread.isNativeThread()) {
            return false;
        }
        boolean deferredClose = false;
        NativeIsolate nativeIsolate = this;
        synchronized (nativeIsolate) {
            if (this.state == State.DISPOSED) {
                return true;
            }
            this.state = State.DISPOSING;
            for (NativeIsolateThread nativeIsolateThread : this.threads) {
                deferredClose |= !nativeIsolateThread.invalidate();
            }
        }
        if (deferredClose) {
            return false;
        }
        return this.doIsolateShutdown();
    }

    public long getIsolateId() {
        return this.isolateId;
    }

    public JNIConfig getConfig() {
        return this.config;
    }

    public String toString() {
        return "NativeIsolate[" + this.uuid + " for 0x" + Long.toHexString(this.isolateId) + "]";
    }

    public static NativeIsolate get(long isolateId) {
        NativeIsolate res = isolates.get(isolateId);
        if (res == null) {
            throw new IllegalStateException("NativeIsolate for isolate 0x" + Long.toHexString(isolateId) + " does not exist.");
        }
        return res;
    }

    public static NativeIsolate forIsolateId(long isolateId, JNIConfig config) {
        NativeIsolate res = new NativeIsolate(isolateId, config);
        NativeIsolate previous = isolates.put(isolateId, res);
        if (previous != null && previous.state != State.DISPOSED) {
            throw new IllegalStateException("NativeIsolate for isolate 0x" + Long.toHexString(isolateId) + " already exists and is not disposed.");
        }
        return res;
    }

    public boolean isDisposed() {
        return this.state == State.DISPOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lastLeave() {
        NativeIsolate nativeIsolate = this;
        synchronized (nativeIsolate) {
            for (NativeIsolateThread nativeIsolateThread : this.threads) {
                if (!nativeIsolateThread.isActive()) continue;
                return;
            }
        }
        this.doIsolateShutdown();
    }

    RuntimeException throwClosedException() {
        throw new IllegalStateException("Isolate 0x" + Long.toHexString(this.getIsolateId()) + " is already closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doIsolateShutdown() {
        NativeIsolate nativeIsolate2 = this;
        synchronized (nativeIsolate2) {
            if (this.state == State.DISPOSED) {
                return true;
            }
            this.state = State.DISPOSED;
        }
        this.cleaners.clear();
        boolean success = false;
        NativeIsolateThread nativeIsolateThread = this.attachedIsolateThread.get();
        if (nativeIsolateThread == null) {
            nativeIsolateThread = new NativeIsolateThread(Thread.currentThread(), this, false, this.config.attachThread(this.isolateId));
            nativeIsolateThread.invalidate();
            this.attachedIsolateThread.set(nativeIsolateThread);
        }
        try {
            nativeIsolateThread.setShutDownRequest(true);
            try {
                success = this.config.shutDownIsolate(this.isolateId, nativeIsolateThread.isolateThread);
            }
            finally {
                nativeIsolateThread.setShutDownRequest(false);
            }
        }
        finally {
            if (success) {
                isolates.computeIfPresent(this.isolateId, (id, nativeIsolate) -> nativeIsolate == this ? null : nativeIsolate);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeIsolateThread getOrCreateNativeIsolateThread() {
        NativeIsolateThread nativeIsolateThread = this.attachedIsolateThread.get();
        if (nativeIsolateThread == null) {
            NativeIsolate nativeIsolate = this;
            synchronized (nativeIsolate) {
                if (!this.state.isValid()) {
                    return null;
                }
                long isolateThreadAddress = this.config.attachThread(this.isolateId);
                nativeIsolateThread = new NativeIsolateThread(Thread.currentThread(), this, false, isolateThreadAddress);
                this.threads.add(nativeIsolateThread);
                this.attachedIsolateThread.set(nativeIsolateThread);
            }
        }
        return nativeIsolateThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachCurrentThread() {
        NativeIsolate nativeIsolate = this;
        synchronized (nativeIsolate) {
            NativeIsolateThread isolateThread = this.attachedIsolateThread.get();
            if (isolateThread != null) {
                this.detachThread(isolateThread);
                this.attachedIsolateThread.set(null);
            }
        }
    }

    private synchronized void detachThread(NativeIsolateThread nativeIsolateThread) {
        if (this.state.isValid() && nativeIsolateThread != null && !nativeIsolateThread.isNativeThread()) {
            this.config.detachThread(nativeIsolateThread.isolateThread);
        }
    }

    private static enum State {
        ACTIVE,
        DISPOSING,
        DISPOSED;


        boolean isValid() {
            return this == ACTIVE;
        }
    }
}

