/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.launcher;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.launcher.LanguageLauncherBase;
import org.graalvm.launcher.Launcher;
import org.graalvm.nativeimage.RuntimeOptions;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotException;

public abstract class AbstractLanguageLauncher
extends LanguageLauncherBase {
    private static final Constructor<AbstractLanguageLauncher> LAUNCHER_CTOR = AbstractLanguageLauncher.getLauncherCtor();
    private boolean jniLaunch;
    private String[] optionVarsArguments;
    private int nativeArgc;
    private long nativeArgv;
    private boolean relaunch;
    protected static final boolean IS_LIBPOLYGLOT = Boolean.getBoolean("graalvm.libpolyglot");

    private static Constructor<AbstractLanguageLauncher> getLauncherCtor() {
        String launcherClassName = System.getProperty("org.graalvm.launcher.class");
        Constructor<?> launcherCtor = null;
        if (launcherClassName != null) {
            try {
                Class<?> launcherClass = Class.forName(launcherClassName);
                if (!AbstractLanguageLauncher.class.isAssignableFrom(launcherClass)) {
                    throw new Exception("Launcher does not implement " + AbstractLanguageLauncher.class.getName());
                }
                launcherCtor = launcherClass.getConstructor(new Class[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return launcherCtor;
    }

    protected final void launch(String[] args) {
        try {
            try {
                this.launch(new ArrayList<String>(Arrays.asList(args)), null, true);
            }
            catch (Launcher.AbortException e) {
                throw e;
            }
            catch (PolyglotException e) {
                this.handlePolyglotException(e);
            }
            catch (RelaunchException e) {
                throw e;
            }
            catch (Throwable t) {
                throw this.abort(t);
            }
        }
        catch (Launcher.AbortException e) {
            this.handleAbortException(e);
        }
    }

    public static void runLauncher(byte[][] optionVarsArgs, byte[][] args, int argc, long argv, boolean relaunch) throws Exception {
        if (AbstractLanguageLauncher.isAOT()) {
            RuntimeOptions.set((String)"EnableSignalHandling", (Object)true);
            RuntimeOptions.set((String)"InstallSegfaultHandler", (Object)true);
        }
        if (LAUNCHER_CTOR == null) {
            throw new Exception("Launcher constructor has not been set.");
        }
        AbstractLanguageLauncher launcher = LAUNCHER_CTOR.newInstance(new Object[0]);
        launcher.jniLaunch = true;
        launcher.nativeArgc = argc;
        launcher.nativeArgv = argv;
        launcher.relaunch = relaunch;
        String[] optionVarsArguments = new String[optionVarsArgs.length];
        for (int i = 0; i < optionVarsArgs.length; ++i) {
            optionVarsArguments[i] = new String(optionVarsArgs[i]);
        }
        launcher.optionVarsArguments = optionVarsArguments;
        String[] arguments = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            arguments[i] = new String(args[i]);
        }
        launcher.launch(arguments);
        System.exit(0);
    }

    protected final void validateVmArguments(List<String> originalArgs, List<String> unrecognizedArgs) {
        if (this.relaunch) {
            return;
        }
        ArrayList<String> heuristicVmArgs = new ArrayList<String>();
        for (String arg : originalArgs) {
            if (!arg.startsWith("--vm.")) continue;
            heuristicVmArgs.add(arg);
        }
        for (String arg : this.optionVarsArguments) {
            if (!arg.startsWith("--vm.")) continue;
            heuristicVmArgs.add(arg);
        }
        ArrayList<String> actualVmArgs = new ArrayList<String>();
        for (String arg : unrecognizedArgs) {
            if (!arg.startsWith("--vm.")) continue;
            actualVmArgs.add(arg);
        }
        if (!heuristicVmArgs.equals(actualVmArgs)) {
            throw new RelaunchException(actualVmArgs);
        }
    }

    protected int getNativeArgc() {
        return this.nativeArgc;
    }

    protected long getNativeArgv() {
        return this.nativeArgv;
    }

    final void launch(List<String> args, Map<String, String> defaultOptions, boolean doNativeSetup) {
        List<String> originalArgs = Collections.unmodifiableList(new ArrayList<String>(args));
        Map<String, String> polyglotOptions = defaultOptions;
        if (polyglotOptions == null) {
            polyglotOptions = new HashMap<String, String>();
        }
        if (AbstractLanguageLauncher.isAOT() && doNativeSetup) {
            System.setProperty("org.graalvm.launcher.languageId", this.getLanguageId());
        }
        List<String> unrecognizedArgs = this.preprocessArguments(args, polyglotOptions);
        if (this.jniLaunch) {
            this.validateVmArguments(originalArgs, unrecognizedArgs);
        }
        if (AbstractLanguageLauncher.isAOT() && doNativeSetup && !IS_LIBPOLYGLOT) {
            assert (this.nativeAccess != null);
            this.maybeExec(originalArgs, unrecognizedArgs, false, this.getDefaultVMType(), this.jniLaunch);
        }
        this.parseUnrecognizedOptions(this.getLanguageId(), polyglotOptions, unrecognizedArgs);
        if (this.runLauncherAction()) {
            return;
        }
        this.validateArguments(polyglotOptions);
        this.argumentsProcessingDone();
        Context.Builder builder = this.isPolyglot() ? Context.newBuilder((String[])new String[0]).options(polyglotOptions) : Context.newBuilder((String[])this.getDefaultLanguages()).options(polyglotOptions);
        builder.allowAllAccess(true);
        this.setupContextBuilder(builder);
        this.launch(builder);
    }

    protected abstract List<String> preprocessArguments(List<String> var1, Map<String, String> var2);

    protected void validateArguments(Map<String, String> polyglotOptions) {
    }

    protected abstract void launch(Context.Builder var1);

    protected abstract String getLanguageId();

    @Override
    protected void printVersion() {
        this.printVersion(AbstractLanguageLauncher.getTempEngine());
    }

    protected void printVersion(Engine engine) {
        String languageId = this.getLanguageId();
        Language language = (Language)engine.getLanguages().get(languageId);
        if (language == null) {
            throw this.abort(String.format("Unknown language: '%s'!", languageId));
        }
        String languageImplementationName = language.getImplementationName();
        if (languageImplementationName == null || languageImplementationName.length() == 0) {
            String languageName = language.getName();
            if (languageName == null || languageName.length() == 0) {
                languageName = languageId;
            }
            languageImplementationName = languageName;
        }
        Object engineImplementationName = engine.getImplementationName();
        engineImplementationName = AbstractLanguageLauncher.isAOT() ? (String)engineImplementationName + " Native" : (String)engineImplementationName + " JVM";
        Object languageVersion = language.getVersion();
        languageVersion = ((String)languageVersion).equals(engine.getVersion()) ? "" : (String)languageVersion + " ";
        System.out.println(String.format("%s %s(%s %s)", languageImplementationName, languageVersion, engineImplementationName, engine.getVersion()));
    }

    protected void runVersionAction(Launcher.VersionAction action, Engine engine) {
        switch (action) {
            case PrintAndContinue: {
                this.printVersion(engine);
                break;
            }
            case PrintAndExit: {
                this.printVersion(engine);
                throw this.exit();
            }
        }
    }

    protected String[] getDefaultLanguages() {
        return new String[]{this.getLanguageId()};
    }

    protected static final class RelaunchException
    extends RuntimeException {
        private static final long serialVersionUID = -4014071914987464223L;
        private String[] vmArgs;

        RelaunchException(List<String> actualVmArgs) {
            this.vmArgs = actualVmArgs.toArray(new String[actualVmArgs.size()]);
        }

        @Override
        public String getMessage() {
            return "Misidentified VM arguments, relaunch required";
        }
    }
}

