/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.shared;

import java.lang.management.ManagementFactory;
import org.graalvm.nativeimage.ImageInfo;

public class Metrics {
    private static boolean METRICS_TIME;
    private static final boolean METRICS_MEMORY_USED_ON_EXIT;

    public static void printTime(String id) {
        if (METRICS_TIME) {
            long millis = System.currentTimeMillis();
            System.err.println(id + " " + millis);
        }
    }

    private static void printMemory() {
        if (!ImageInfo.inImageCode() && METRICS_MEMORY_USED_ON_EXIT) {
            for (int n = 0; n < 10; ++n) {
                System.gc();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            System.err.printf("allocated %d%n", ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed());
        }
    }

    public static void initializeOption() {
        METRICS_TIME = Boolean.getBoolean("truffleruby.metrics.time");
    }

    public static boolean getMetricsTime() {
        return METRICS_TIME;
    }

    public static void begin() {
        Metrics.initializeOption();
        Metrics.printTime("before-main");
    }

    public static void end() {
        Metrics.printTime("after-main");
        Metrics.printMemory();
    }

    static {
        METRICS_MEMORY_USED_ON_EXIT = Boolean.getBoolean("truffleruby.metrics.memory_used_on_exit");
    }
}

