/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.shared;

import org.graalvm.nativeimage.ImageInfo;
import org.truffleruby.shared.BasicPlatform;
import org.truffleruby.shared.BuildInformationImpl;

public final class TruffleRuby {
    public static final String FORMAL_NAME = "TruffleRuby";
    public static final String LANGUAGE_ID = "ruby";
    public static final String EXTENSION = ".rb";
    public static final String ENGINE_ID = "truffleruby";
    public static final String LANGUAGE_VERSION = "3.2.2";
    public static final String LANGUAGE_REVISION = BuildInformationImpl.INSTANCE.getFullRevision();
    public static final String BOOT_SOURCE_NAME = "main_boot_source";
    public static final String RUBY_COPYRIGHT = "truffleruby - Copyright (c) 2013-" + BuildInformationImpl.INSTANCE.getCopyrightYear() + " Oracle and/or its affiliates";

    public static String getVersionString(String implementationName) {
        String buildName = BuildInformationImpl.INSTANCE.getBuildName();
        String nameExtra = buildName == null ? "" : String.format(" (%s)", BuildInformationImpl.INSTANCE.getBuildName());
        return String.format("%s%s %s%s, like ruby %s, %s %s [%s-%s]", ENGINE_ID, nameExtra, TruffleRuby.getEngineVersion(), BuildInformationImpl.INSTANCE.isDirty() ? "*" : "", LANGUAGE_VERSION, implementationName, ImageInfo.inImageCode() ? "Native" : "JVM", BasicPlatform.getArchName(), BasicPlatform.getOSName());
    }

    public static String getEngineVersion() {
        String systemVersion = System.getProperty("org.graalvm.version");
        String revisionString = BuildInformationImpl.INSTANCE.getShortRevision();
        if (systemVersion == null || systemVersion.equals("dev")) {
            return "0.0-" + revisionString;
        }
        if (systemVersion.endsWith("-dev")) {
            return systemVersion + "-" + revisionString;
        }
        return systemVersion;
    }
}

