# frozen_string_literal: true
# truffleruby_primitives: true

# Copyright (c) 2013, Brian Shirai
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this
#    list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# 3. Neither the name of the library nor the names of its contributors may be
#    used to endorse or promote products derived from this software without
#    specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

module Truffle
  module Socket
    module Foreign
      class Sockaddr < ::FFI::Struct
        Truffle::Socket.config(self, 'platform.sockaddr', :sa_family, :sa_data)

        SA_FAMILY_T = Truffle::Config['platform.typedef.sa_family_t'].to_sym
        SA_FAMILY_OFFSET = Truffle::Config['platform.sockaddr.sa_family.offset']

        def self.family_of_string(str)
          case SA_FAMILY_T
          when :ushort
            str[SA_FAMILY_OFFSET..-1].unpack1('S')
          when :uchar
            str[SA_FAMILY_OFFSET..-1].unpack1('C')
          else
            raise "Unexpected type for sa_family_t: #{SA_FAMILY_T}"
          end
        end

        def family
          self[:sa_family]
        end

        def data
          self[:sa_data]
        end

        def to_s
          pointer.read_string(Primitive.class(self).size)
        end
      end
    end
  end
end
