/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.stdlib.readline;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import org.graalvm.shadowed.org.jline.reader.History;
import org.graalvm.shadowed.org.jline.reader.LineReader;
import org.graalvm.shadowed.org.jline.reader.impl.ReaderUtils;

public final class MemoryHistory
implements History {
    private final LinkedList<History.Entry> entries = new LinkedList();
    private int index = 0;
    private LineReader reader;

    public void attach(LineReader lineReader) {
        if (this.reader != lineReader) {
            this.reader = lineReader;
        }
    }

    public void load() throws IOException {
    }

    public void save() throws IOException {
    }

    public void write(Path path, boolean incremental) throws IOException {
    }

    public void append(Path path, boolean incremental) throws IOException {
    }

    public void read(Path path, boolean incremental) throws IOException {
    }

    public void purge() throws IOException {
        this.entries.clear();
        this.index = 0;
    }

    public int size() {
        return this.entries.size();
    }

    public int index() {
        return this.index;
    }

    public int first() {
        return 0;
    }

    public int last() {
        return this.entries.size() - 1;
    }

    public String get(int i) {
        return this.entries.get(i).line();
    }

    public void add(Instant time, String line) {
        Objects.requireNonNull(time);
        Objects.requireNonNull(line);
        if (ReaderUtils.getBoolean((LineReader)this.reader, (String)"disable-history", (boolean)false)) {
            return;
        }
        if (ReaderUtils.isSet((LineReader)this.reader, (LineReader.Option)LineReader.Option.HISTORY_IGNORE_SPACE) && line.startsWith(" ")) {
            return;
        }
        if (ReaderUtils.isSet((LineReader)this.reader, (LineReader.Option)LineReader.Option.HISTORY_REDUCE_BLANKS)) {
            line = line.strip();
        }
        if (ReaderUtils.isSet((LineReader)this.reader, (LineReader.Option)LineReader.Option.HISTORY_IGNORE_DUPS) && !this.entries.isEmpty() && line.equals(this.entries.getLast().line())) {
            return;
        }
        if (this.matchPatterns(ReaderUtils.getString((LineReader)this.reader, (String)"history-ignore", (String)""), line)) {
            return;
        }
        this.entries.add(new SimpleEntry(this.entries.size(), line, time));
        this.moveToEnd();
    }

    protected boolean matchPatterns(String patterns, String line) {
        if (patterns == null || patterns.isEmpty()) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < patterns.length(); ++i) {
            char ch = patterns.charAt(i);
            if (ch == '\\') {
                ch = patterns.charAt(++i);
                builder.append(ch);
                continue;
            }
            if (ch == ':') {
                builder.append('|');
                continue;
            }
            if (ch != '*') continue;
            builder.append('.').append('*');
        }
        return line.matches(builder.toString());
    }

    public String current() {
        if (this.index >= this.size()) {
            return "";
        }
        return this.entries.get(this.index).line();
    }

    public boolean previous() {
        if (this.index > 0) {
            --this.index;
            return true;
        }
        return false;
    }

    public boolean next() {
        if (this.index < this.size()) {
            ++this.index;
            return true;
        }
        return false;
    }

    public boolean moveToFirst() {
        if (this.size() > 0 && this.index != 0) {
            this.index = 0;
            return true;
        }
        return false;
    }

    public boolean moveToLast() {
        int lastEntry = this.size() - 1;
        if (lastEntry >= 0 && lastEntry != this.index) {
            this.index = this.size() - 1;
            return true;
        }
        return false;
    }

    public boolean moveTo(int i) {
        if (i >= 0 && i < this.size()) {
            this.index = i;
            return true;
        }
        return false;
    }

    public void moveToEnd() {
        this.index = this.size();
    }

    public void resetIndex() {
        this.index = Math.min(this.index, this.entries.size());
    }

    public void set(int i, String line) {
        this.entries.set(i, new SimpleEntry(i, line, Instant.now()));
    }

    public History.Entry remove(int i) {
        History.Entry entry = this.entries.remove(i);
        this.resetIndex();
        return entry;
    }

    public History.Entry removeFirst() {
        return this.remove(this.first());
    }

    public History.Entry removeLast() {
        return this.remove(this.last());
    }

    public ListIterator<History.Entry> iterator(int i) {
        return this.entries.listIterator(i);
    }

    private static final class SimpleEntry
    implements History.Entry {
        private final int index;
        private final String line;
        private final Instant time;

        private SimpleEntry(int index, String line, Instant time) {
            this.index = index;
            this.line = line;
            this.time = time;
        }

        public int index() {
            return this.index;
        }

        public String line() {
            return this.line;
        }

        public Instant time() {
            return this.time;
        }
    }
}

