/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.stdlib.readline;

import java.io.Console;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class IsTTYHelper {
    private static final Method IS_TERMINAL_METHOD = IsTTYHelper.getIsTerminalMethod();

    private static Method getIsTerminalMethod() {
        try {
            return Console.class.getMethod("isTerminal", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean isTTY() {
        Console console = System.console();
        if (console == null) {
            return false;
        }
        if (IS_TERMINAL_METHOD != null) {
            try {
                return (Boolean)IS_TERMINAL_METHOD.invoke((Object)console, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new Error(e);
            }
        }
        return true;
    }
}

