/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.stdlib;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.HashMap;
import java.util.Map;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.language.control.RaiseException;

@CoreModule(value="Truffle::Coverage")
public abstract class CoverageNodes {

    @CoreMethod(names={"enabled?"}, onSingleton=true)
    public static abstract class CoverageEnabledNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean coverageEnabled() {
            return this.getLanguage().coverageManager.isEnabled();
        }
    }

    @CoreMethod(names={"result_array"}, onSingleton=true)
    public static abstract class CoverageResultNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray resultArray() {
            Map<Source, long[]> counts = this.getLanguage().coverageManager.getCounts();
            if (counts == null) {
                throw new RaiseException(this.getContext(), this.coreExceptions().runtimeErrorCoverageNotEnabled(this));
            }
            HashMap<String, RubyArray> results = new HashMap<String, RubyArray>();
            for (Map.Entry<Source, long[]> source : counts.entrySet()) {
                long[] countsArray = source.getValue();
                Object[] countsStore = new Object[countsArray.length];
                for (int n = 0; n < countsArray.length; ++n) {
                    countsStore[n] = countsArray[n] == -1L ? nil : Long.valueOf(countsArray[n]);
                }
                String path = this.getLanguage().getSourcePath(source.getKey());
                assert (!results.containsKey(path)) : "path already exists in coverage results";
                results.put(path, this.createArray(new Object[]{this.createString(this.fromJavaStringNode, path, Encodings.UTF_8), this.createArray(countsStore)}));
            }
            return this.createArray(results.values().toArray());
        }
    }

    @CoreMethod(names={"disable"}, onSingleton=true)
    public static abstract class CoverageDisableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object disable() {
            this.getLanguage().coverageManager.disable();
            return nil;
        }
    }

    @CoreMethod(names={"enable"}, onSingleton=true)
    public static abstract class CoverageEnableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object enable() {
            this.getLanguage().coverageManager.enable();
            return nil;
        }
    }
}

