/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.platform;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.truffleruby.RubyContext;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class Signals {
    private static final SignalHandler IGNORE = sig -> {};
    private static final ConcurrentMap<String, SignalHandler> DEFAULT_HANDLERS = new ConcurrentHashMap<String, SignalHandler>();

    public static void registerHandler(RubyContext context, SignalHandler newHandler, String signalName, boolean isRubyDefaultHandler) {
        Signal signal = new Signal(signalName);
        SignalHandler oldHandler = Signal.handle(signal, newHandler);
        DEFAULT_HANDLERS.putIfAbsent(signalName, oldHandler);
        if (isRubyDefaultHandler) {
            context.defaultRubySignalHandlers.putIfAbsent(signalName, newHandler);
        }
    }

    public static void registerIgnoreHandler(String signalName) {
        Signal signal = new Signal(signalName);
        SignalHandler oldHandler = Signal.handle(signal, IGNORE);
        DEFAULT_HANDLERS.putIfAbsent(signalName, oldHandler);
    }

    public static boolean restoreDefaultHandler(String signalName) {
        SignalHandler defaultHandler = (SignalHandler)DEFAULT_HANDLERS.get(signalName);
        if (defaultHandler == null) {
            return false;
        }
        Signal signal = new Signal(signalName);
        Signal.handle(signal, defaultHandler);
        return true;
    }

    public static boolean restoreRubyDefaultHandler(RubyContext context, String signalName) {
        SignalHandler defaultHandler = (SignalHandler)context.defaultRubySignalHandlers.get(signalName);
        if (defaultHandler == null) {
            defaultHandler = (SignalHandler)DEFAULT_HANDLERS.get(signalName);
        }
        if (defaultHandler == null) {
            return false;
        }
        Signal signal = new Signal(signalName);
        Signal.handle(signal, defaultHandler);
        return true;
    }

    public static void restoreSystemHandler(String signalName) {
        Signal signal = new Signal(signalName);
        Signal.handle(signal, SignalHandler.SIG_DFL);
    }

    public static void restoreDefaultHandlers() {
        for (String signalName : new ArrayList(DEFAULT_HANDLERS.keySet())) {
            Signals.restoreDefaultHandler(signalName);
        }
    }
}

