/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.prism.Nodes;
import org.prism.ParseResult;
import org.prism.Parser;
import org.prism.ParsingOptions;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.DummyNode;
import org.truffleruby.core.binding.BindingNodes;
import org.truffleruby.core.binding.SetBindingFrameForEvalNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.language.DataNode;
import org.truffleruby.language.EmitWarningsNode;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyEvalRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.RubyTopLevelRootNode;
import org.truffleruby.language.SetTopLevelBindingNode;
import org.truffleruby.language.arguments.MissingArgumentBehavior;
import org.truffleruby.language.arguments.ReadPreArgumentNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.locals.FrameDescriptorNamesIterator;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.options.Options;
import org.truffleruby.parser.MagicCommentParser;
import org.truffleruby.parser.ParseEnvironment;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubyDeferredWarnings;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.YARPLoader;
import org.truffleruby.parser.YARPTranslator;
import org.truffleruby.shared.Metrics;

public final class YARPTranslatorDriver {
    private final RubyContext context;
    private final RubyLanguage language;
    private ParseEnvironment parseEnvironment;

    public YARPTranslatorDriver(RubyContext context) {
        this.context = context;
        this.language = context.getLanguageSlow();
    }

    public RootCallTarget parse(RubySource rubySource, ParserContext parserContext, String[] argumentNames, MaterializedFrame parentFrame, LexicalScope staticLexicalScope, Node currentNode) {
        return this.parse(rubySource, parserContext, argumentNames, parentFrame, staticLexicalScope, currentNode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootCallTarget parse(RubySource rubySource, ParserContext parserContext, String[] argumentNames, MaterializedFrame parentFrame, LexicalScope staticLexicalScope, Node currentNode, ParseResult parseResult) {
        RubyNode[] beginBlocks;
        RubyNode truffleNode;
        boolean topLevel;
        TranslatorEnvironment parentEnvironment;
        byte[] sourceBytes = rubySource.getBytes();
        this.parseEnvironment = new ParseEnvironment(this.language, rubySource, parserContext, currentNode);
        assert (rubySource.isEval() == parserContext.isEval());
        if (parserContext.isTopLevel() != (parentFrame == null)) {
            throw CompilerDirectives.shouldNotReachHere((String)("A frame should be given iff the context is not toplevel: " + String.valueOf((Object)parserContext) + " " + String.valueOf(parentFrame)));
        }
        if (!rubySource.getEncoding().isAsciiCompatible) {
            throw new RaiseException(this.context, this.context.getCoreExceptions().argumentError(String.valueOf(rubySource.getEncoding()) + " is not ASCII compatible", currentNode));
        }
        Source source = rubySource.getSource();
        ArrayList<List<Object>> localsInScopes = new ArrayList<List<Object>>();
        int blockDepth = 0;
        if (parentFrame != null) {
            MaterializedFrame frame = parentFrame;
            while (frame != null) {
                ArrayList<String> names = new ArrayList<String>();
                for (Object identifier : FrameDescriptorNamesIterator.iterate(frame.getFrameDescriptor())) {
                    if (BindingNodes.isHiddenVariable(identifier)) continue;
                    String name = (String)identifier;
                    names.add(name.intern());
                }
                localsInScopes.add(names);
                frame = RubyArguments.getDeclarationFrame((Frame)frame);
                ++blockDepth;
            }
            parentEnvironment = this.environmentForFrame(this.context, parentFrame, blockDepth - 1);
        } else {
            parentEnvironment = null;
        }
        if (argumentNames != null) {
            localsInScopes.add(Arrays.asList(argumentNames));
        }
        RubyDeferredWarnings rubyWarnings = new RubyDeferredWarnings();
        String sourcePath = rubySource.getSourcePath(this.language).intern();
        Options options = parserContext == ParserContext.TOP_LEVEL_FIRST ? this.context.getOptions() : null;
        if (parseResult == null) {
            YARPTranslatorDriver.printParseTranslateExecuteMetric("before-parsing", this.context, source);
            parseResult = this.context.getMetricsProfiler().callWithMetrics("parsing", source.getName(), () -> YARPTranslatorDriver.parseToYARPAST(rubySource, sourcePath, sourceBytes, localsInScopes, this.language.options.FROZEN_STRING_LITERALS, options, parserContext));
            YARPTranslatorDriver.printParseTranslateExecuteMetric("after-parsing", this.context, source);
        }
        this.parseEnvironment.yarpSource = parseResult.source;
        YARPTranslatorDriver.handleWarningsErrorsPrimitives(this.context, parseResult, rubySource, sourcePath, this.parseEnvironment, rubyWarnings);
        Nodes.Node node = parseResult.value;
        SourceSection sourceSection = sourceBytes.length == 0 ? source.createUnavailableSection() : source.createSection(0, sourceBytes.length);
        String modulePath = staticLexicalScope == null || staticLexicalScope == this.context.getRootLexicalScope() ? null : staticLexicalScope.getLiveModule().getName();
        String methodName = this.getMethodName(parserContext, parentFrame);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.language.singleContext ? staticLexicalScope : null, Arity.NO_ARGUMENTS, methodName, 0, methodName, null, null);
        boolean isModuleBody = topLevel = parserContext.isTopLevel();
        TranslatorEnvironment environment = new TranslatorEnvironment(parentEnvironment, this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, isModuleBody, sharedMethodInfo, sharedMethodInfo.getMethodNameForNotBlock(), blockDepth, null, null, modulePath);
        if (argumentNames != null) {
            for (String name : argumentNames) {
                environment.declareVar(name);
            }
        }
        YARPTranslator translator = new YARPTranslator(environment, rubyWarnings);
        YARPTranslatorDriver.printParseTranslateExecuteMetric("before-translate", this.context, source);
        try {
            truffleNode = this.context.getMetricsProfiler().callWithMetrics("translating", source.getName(), () -> node.accept(translator));
        }
        finally {
            YARPTranslatorDriver.printParseTranslateExecuteMetric("after-translate", this.context, source);
        }
        if (argumentNames != null && argumentNames.length > 0) {
            ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
            for (int n = 0; n < argumentNames.length; ++n) {
                String name = argumentNames[n];
                RubyNode readNode = YARPTranslator.profileArgument(this.language, new ReadPreArgumentNode(n, false, MissingArgumentBehavior.NIL));
                int slot = environment.findFrameSlot(name);
                sequence.add(new WriteLocalVariableNode(slot, readNode));
            }
            sequence.add(truffleNode);
            truffleNode = YARPTranslator.sequence(sequence.toArray(RubyNode.EMPTY_ARRAY));
        }
        if (environment.getFlipFlopStates().size() > 0) {
            truffleNode = YARPTranslator.sequence(YARPTranslator.initFlipFlopStates(environment), truffleNode);
        }
        if ((beginBlocks = translator.getBeginBlocks()).length > 0) {
            RubyNode[] sequence = Arrays.copyOf(beginBlocks, beginBlocks.length + 1);
            sequence[sequence.length - 1] = truffleNode;
            truffleNode = YARPTranslator.sequence(sequence);
        }
        RubyNode writeSelfNode = YARPTranslator.loadSelf(this.language);
        truffleNode = YARPTranslator.sequence(writeSelfNode, truffleNode);
        if (!rubyWarnings.warnings.isEmpty()) {
            truffleNode = YARPTranslator.sequence(new EmitWarningsNode(rubyWarnings), truffleNode);
        }
        if (parserContext == ParserContext.TOP_LEVEL_FIRST) {
            truffleNode = YARPTranslator.sequence(new SetTopLevelBindingNode(), truffleNode);
            if (parseResult.dataLocation != null) {
                int offset = parseResult.dataLocation.startOffset + "__END__".length();
                if (offset < source.getLength()) {
                    ++offset;
                }
                truffleNode = YARPTranslator.sequence(new DataNode(offset), truffleNode);
            }
        }
        FrameDescriptor frameDescriptor = environment.computeFrameDescriptor();
        if (parserContext == ParserContext.EVAL && BindingNodes.assignsNewUserVariables(frameDescriptor)) {
            truffleNode = new SetBindingFrameForEvalNode(frameDescriptor, truffleNode);
        }
        RubyRootNode rootNode = parserContext.isTopLevel() ? new RubyTopLevelRootNode(this.language, sourceSection, frameDescriptor, sharedMethodInfo, truffleNode, Split.HEURISTIC, environment.getReturnID(), Arity.ANY_ARGUMENTS) : new RubyEvalRootNode(this.language, sourceSection, frameDescriptor, sharedMethodInfo, truffleNode, Split.HEURISTIC, environment.getReturnID());
        return rootNode.getCallTarget();
    }

    private String getMethodName(ParserContext parserContext, MaterializedFrame parentFrame) {
        if (parserContext.isTopLevel()) {
            return parserContext.getTopLevelName();
        }
        if (parentFrame != null) {
            return RubyArguments.getMethod((Frame)parentFrame).getName();
        }
        throw new UnsupportedOperationException("Could not determine the method name for parser context " + String.valueOf((Object)parserContext));
    }

    public static ParseResult parseToYARPAST(RubySource rubySource, String sourcePath, byte[] sourceBytes, List<List<String>> localsInScopes, boolean frozenStringLiteral, Options cliOptions, ParserContext parserContext) {
        byte[][][] scopes;
        EnumSet<ParsingOptions.CommandLine> commandline;
        TruffleSafepoint.poll((Node)DummyNode.INSTANCE);
        byte[] filepath = sourcePath.getBytes(Encodings.FILESYSTEM_CHARSET);
        int line = rubySource.getLineOffset() + 1;
        byte[] encoding = StringOperations.encodeAsciiBytes(rubySource.getEncoding().toString());
        ParsingOptions.SyntaxVersion version = ParsingOptions.SyntaxVersion.V3_3;
        boolean encodingLocked = false;
        boolean mainScript = parserContext == ParserContext.TOP_LEVEL_FIRST;
        boolean partialScript = false;
        if (cliOptions != null && cliOptions.GETS_LOOP) {
            ArrayList<ParsingOptions.CommandLine> yarpCliOptions = new ArrayList<ParsingOptions.CommandLine>();
            yarpCliOptions.add(ParsingOptions.CommandLine.N);
            if (cliOptions.PRINT_LOOP) {
                yarpCliOptions.add(ParsingOptions.CommandLine.P);
            }
            if (cliOptions.SPLIT_LOOP) {
                yarpCliOptions.add(ParsingOptions.CommandLine.A);
            }
            if (cliOptions.CHOMP_LOOP) {
                yarpCliOptions.add(ParsingOptions.CommandLine.L);
            }
            commandline = EnumSet.copyOf(yarpCliOptions);
        } else {
            commandline = EnumSet.noneOf(ParsingOptions.CommandLine.class);
        }
        if (!localsInScopes.isEmpty()) {
            int scopesCount = localsInScopes.size();
            scopes = new byte[scopesCount + 1][][];
            for (int i = 0; i < scopesCount; ++i) {
                List<String> namesList = localsInScopes.get(scopesCount - 1 - i);
                byte[][] namesBytes = new byte[namesList.size()][];
                int j = 0;
                for (String name : namesList) {
                    namesBytes[j] = TStringUtils.javaStringToBytes(name, rubySource.getEncoding());
                    ++j;
                }
                scopes[i] = namesBytes;
            }
            scopes[scopes.length - 1] = new byte[0][];
        } else {
            scopes = new byte[][][]{};
        }
        byte[] parsingOptions = ParsingOptions.serialize(filepath, line, encoding, frozenStringLiteral, commandline, version, false, mainScript, false, scopes);
        byte[] serializedBytes = Parser.parseAndSerialize(sourceBytes, parsingOptions);
        return YARPLoader.load(serializedBytes, sourceBytes, rubySource);
    }

    public static void handleWarningsErrorsPrimitives(RubyContext context, ParseResult parseResult, RubySource rubySource, String sourcePath, ParseEnvironment parseEnvironment, RubyDeferredWarnings rubyWarnings) {
        ParseResult.Error[] errors = parseResult.errors;
        block4: for (ParseResult.Warning warning : parseResult.warnings) {
            Nodes.Location location = warning.location;
            SourceSection section = rubySource.getSource().createSection(location.startOffset, location.length);
            int lineNumber = section.getStartLine() + rubySource.getLineOffset();
            switch (warning.level) {
                case WARNING_DEFAULT: {
                    rubyWarnings.warn(sourcePath, lineNumber, warning.message);
                    continue block4;
                }
                case WARNING_VERBOSE: {
                    rubyWarnings.warning(sourcePath, lineNumber, warning.message);
                }
            }
        }
        if (errors.length != 0) {
            if (!rubyWarnings.warnings.isEmpty()) {
                EmitWarningsNode.printWarnings(context, rubyWarnings);
            }
            ParseResult.Error error = errors[0];
            Nodes.Location location = error.location;
            SourceSection section = rubySource.getSource().createSection(location.startOffset, location.length);
            String message = context.fileLine(section) + ": " + error.message;
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxErrorAlreadyWithFileLine(message, null, section));
        }
        boolean allowTruffleRubyPrimitives = false;
        for (ParseResult.MagicComment magicComment : parseResult.magicComments) {
            String name = rubySource.getTStringWithEncoding().substring(magicComment.keyLocation.startOffset, magicComment.keyLocation.length).toJavaString();
            String value = rubySource.getTStringWithEncoding().substring(magicComment.valueLocation.startOffset, magicComment.valueLocation.length).toJavaString();
            if (!MagicCommentParser.isMagicTruffleRubyPrimitivesComment(name)) continue;
            allowTruffleRubyPrimitives = value.equalsIgnoreCase("true");
        }
        parseEnvironment.allowTruffleRubyPrimitives = allowTruffleRubyPrimitives;
    }

    private TranslatorEnvironment environmentForFrame(RubyContext context, MaterializedFrame frame, int blockDepth) {
        if (frame == null) {
            return null;
        }
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(CoreLibrary.JAVA_CORE_SOURCE_SECTION, this.language.singleContext ? context.getRootLexicalScope() : null, Arity.NO_ARGUMENTS, "<unused>", 0, "<unused>", "external", null);
        MaterializedFrame parent = RubyArguments.getDeclarationFrame((Frame)frame);
        assert (blockDepth == 0 == (parent == null));
        boolean isModuleBody = blockDepth == 0 && RubyArguments.getMethod((Frame)frame).getSharedMethodInfo().isModuleBody();
        return new TranslatorEnvironment(this.environmentForFrame(context, parent, blockDepth - 1), this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, isModuleBody, sharedMethodInfo, sharedMethodInfo.getMethodName(), blockDepth, null, frame.getFrameDescriptor(), "<unused>");
    }

    public static void printParseTranslateExecuteMetric(String id, RubyContext context, Source source) {
        if (Metrics.getMetricsTime()) {
            if (context.getOptions().METRICS_TIME_PARSING_FILE) {
                String name = context.getLanguageSlow().getSourcePath(source);
                int lastSlash = name.lastIndexOf(47);
                int lastDot = name.lastIndexOf(46);
                if (lastSlash >= 0 && lastDot >= 0 && lastSlash + 1 < lastDot) {
                    name = name.substring(lastSlash + 1, lastDot);
                }
                Metrics.printTime((String)(id + "-" + name));
            } else if (context.getCoreLibrary().isLoadingRubyCore()) {
                Metrics.printTime((String)(id + "-core"));
            }
        }
    }
}

