/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Objects;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.jcodings.specific.EUCJPEncoding;
import org.graalvm.shadowed.org.jcodings.specific.Windows_31JEncoding;
import org.prism.Nodes;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.builtins.PrimitiveNodeConstructor;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.IsNilNode;
import org.truffleruby.core.array.ArrayConcatNode;
import org.truffleruby.core.array.ArrayLiteralNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.cast.HashCastNodeGen;
import org.truffleruby.core.cast.SplatCastNode;
import org.truffleruby.core.cast.SplatCastNodeGen;
import org.truffleruby.core.cast.StringToSymbolNode;
import org.truffleruby.core.cast.StringToSymbolNodeGen;
import org.truffleruby.core.cast.ToProcNode;
import org.truffleruby.core.cast.ToProcNodeGen;
import org.truffleruby.core.cast.ToSNode;
import org.truffleruby.core.cast.ToSNodeGen;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.hash.ConcatHashLiteralNode;
import org.truffleruby.core.hash.HashLiteralNode;
import org.truffleruby.core.module.ModuleNodes;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.range.RangeNodes;
import org.truffleruby.core.range.RangeNodesFactory;
import org.truffleruby.core.range.RubyIntRange;
import org.truffleruby.core.range.RubyLongRange;
import org.truffleruby.core.regexp.ClassicRegexp;
import org.truffleruby.core.regexp.InterpolatedRegexpNodeGen;
import org.truffleruby.core.regexp.MatchDataNodes;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.rescue.AssignRescueVariableNode;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.InterpolatedStringNode;
import org.truffleruby.core.string.KCode;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.debug.ChaosNode;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNodeWithExecute;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyContextSourceNodeCustomExecuteVoid;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.RubyTopLevelRootNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.ProfileArgumentNodeGen;
import org.truffleruby.language.arguments.ReadSelfNode;
import org.truffleruby.language.constants.ReadConstantNode;
import org.truffleruby.language.constants.ReadConstantWithDynamicScopeNode;
import org.truffleruby.language.constants.ReadConstantWithLexicalScopeNode;
import org.truffleruby.language.constants.WriteConstantNode;
import org.truffleruby.language.control.AndNode;
import org.truffleruby.language.control.AndNodeGen;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.BreakNode;
import org.truffleruby.language.control.DeferredRaiseException;
import org.truffleruby.language.control.DynamicReturnNode;
import org.truffleruby.language.control.FrameOnStackNode;
import org.truffleruby.language.control.IfElseNode;
import org.truffleruby.language.control.IfElseNodeGen;
import org.truffleruby.language.control.IfNode;
import org.truffleruby.language.control.IfNodeGen;
import org.truffleruby.language.control.InvalidReturnNode;
import org.truffleruby.language.control.LocalReturnNode;
import org.truffleruby.language.control.NextNode;
import org.truffleruby.language.control.NoMatchingPatternNodeGen;
import org.truffleruby.language.control.NotNodeGen;
import org.truffleruby.language.control.OnceNode;
import org.truffleruby.language.control.OrLazyValueDefinedNode;
import org.truffleruby.language.control.OrLazyValueDefinedNodeGen;
import org.truffleruby.language.control.OrNode;
import org.truffleruby.language.control.OrNodeGen;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.RedoNode;
import org.truffleruby.language.control.RetryNode;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.control.UnlessNode;
import org.truffleruby.language.control.UnlessNodeGen;
import org.truffleruby.language.control.WhileNode;
import org.truffleruby.language.control.WhileNodeFactory;
import org.truffleruby.language.defined.DefinedNode;
import org.truffleruby.language.defined.DefinedWrapperNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.exceptions.EnsureNodeGen;
import org.truffleruby.language.exceptions.RescueClassesNode;
import org.truffleruby.language.exceptions.RescueNode;
import org.truffleruby.language.exceptions.RescueSplatNode;
import org.truffleruby.language.exceptions.RescueStandardErrorNode;
import org.truffleruby.language.exceptions.TryNode;
import org.truffleruby.language.exceptions.TryNodeGen;
import org.truffleruby.language.globals.AliasGlobalVarNode;
import org.truffleruby.language.globals.ReadGlobalVariableNode;
import org.truffleruby.language.globals.ReadGlobalVariableNodeGen;
import org.truffleruby.language.globals.ReadMatchReferenceNodes;
import org.truffleruby.language.globals.WriteGlobalVariableNode;
import org.truffleruby.language.globals.WriteGlobalVariableNodeGen;
import org.truffleruby.language.literal.BooleanLiteralNode;
import org.truffleruby.language.literal.FloatLiteralNode;
import org.truffleruby.language.literal.FrozenStringLiteralNode;
import org.truffleruby.language.literal.IntegerFixnumLiteralNode;
import org.truffleruby.language.literal.LongFixnumLiteralNode;
import org.truffleruby.language.literal.NilLiteralNode;
import org.truffleruby.language.literal.ObjectClassLiteralNode;
import org.truffleruby.language.literal.ObjectLiteralNode;
import org.truffleruby.language.literal.StringLiteralNode;
import org.truffleruby.language.literal.TruffleInternalModuleLiteralNode;
import org.truffleruby.language.locals.FindDeclarationVariableNodes;
import org.truffleruby.language.locals.FlipFlopNode;
import org.truffleruby.language.locals.FlipFlopNodeGen;
import org.truffleruby.language.locals.InitFlipFlopSlotNode;
import org.truffleruby.language.locals.ReadLocalNode;
import org.truffleruby.language.locals.ReadLocalVariableNode;
import org.truffleruby.language.locals.WriteLocalNode;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.BlockDefinitionNode;
import org.truffleruby.language.methods.CachedLazyCallTargetSupplier;
import org.truffleruby.language.methods.CatchBreakNode;
import org.truffleruby.language.methods.LiteralMethodDefinitionNode;
import org.truffleruby.language.methods.ModuleBodyDefinition;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.DefineClassNode;
import org.truffleruby.language.objects.DefineModuleNode;
import org.truffleruby.language.objects.DefineModuleNodeGen;
import org.truffleruby.language.objects.DynamicLexicalScopeNode;
import org.truffleruby.language.objects.GetDynamicLexicalScopeNode;
import org.truffleruby.language.objects.InsideModuleDefinitionNode;
import org.truffleruby.language.objects.LexicalScopeNode;
import org.truffleruby.language.objects.ReadInstanceVariableNode;
import org.truffleruby.language.objects.RunModuleDefinitionNode;
import org.truffleruby.language.objects.SelfNode;
import org.truffleruby.language.objects.SingletonClassNode;
import org.truffleruby.language.objects.SingletonClassNodeGen;
import org.truffleruby.language.objects.WriteInstanceVariableNode;
import org.truffleruby.language.objects.WriteInstanceVariableNodeGen;
import org.truffleruby.language.objects.classvariables.ReadClassVariableNode;
import org.truffleruby.language.objects.classvariables.WriteClassVariableNode;
import org.truffleruby.language.supercall.ReadSuperArgumentsNode;
import org.truffleruby.language.supercall.ReadZSuperArgumentsNode;
import org.truffleruby.language.supercall.SuperCallNode;
import org.truffleruby.language.supercall.ZSuperOutsideMethodNode;
import org.truffleruby.language.yield.YieldExpressionNode;
import org.truffleruby.parser.ArgumentDescriptor;
import org.truffleruby.parser.ArgumentType;
import org.truffleruby.parser.OpenModule;
import org.truffleruby.parser.RubyDeferredWarnings;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.YARPBaseTranslator;
import org.truffleruby.parser.YARPBlockNodeTranslator;
import org.truffleruby.parser.YARPDefNodeTranslator;
import org.truffleruby.parser.YARPExecutedOnceExpression;
import org.truffleruby.parser.YARPMultiWriteNodeTranslator;
import org.truffleruby.parser.YARPPatternMatchingTranslator;
import org.truffleruby.parser.YARPReloadArgumentsTranslator;

public class YARPTranslator
extends YARPBaseTranslator {
    public static final int NO_FRAME_ON_STACK_MARKER = -1;
    public static final RescueNode[] EMPTY_RESCUE_NODE_ARRAY = new RescueNode[0];
    public Deque<Integer> frameOnStackMarkerSlotStack = new ArrayDeque<Integer>();
    protected RubyDeferredWarnings rubyWarnings;
    private boolean translatingWhile = false;
    private boolean translatingForStatement = false;
    private static final String[] numberedParameterNames = new String[]{null, "_1", "_2", "_3", "_4", "_5", "_6", "_7", "_8", "_9"};
    private final ArrayList<RubyNode> beginBlocks = new ArrayList();

    public YARPTranslator(TranslatorEnvironment environment, RubyDeferredWarnings rubyWarnings) {
        super(environment);
        this.rubyWarnings = rubyWarnings;
    }

    public RubyNode[] getBeginBlocks() {
        return this.beginBlocks.toArray(RubyNode.EMPTY_ARRAY);
    }

    public RubyRootNode translate(Nodes.Node node) {
        RubyNode body = node.accept(this);
        FrameDescriptor frameDescriptor = TranslatorEnvironment.newFrameDescriptorBuilderForMethod().build();
        SourceSection sourceSection = CoreLibrary.JAVA_CORE_SOURCE_SECTION;
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, null, Arity.NO_ARGUMENTS, "<main>", 0, "<main>", null, null);
        return new RubyTopLevelRootNode(this.language, sourceSection, frameDescriptor, sharedMethodInfo, body, Split.HEURISTIC, null, Arity.NO_ARGUMENTS);
    }

    @Override
    public RubyNode visitAliasGlobalVariableNode(Nodes.AliasGlobalVariableNode node) {
        AliasGlobalVarNode rubyNode = new AliasGlobalVarNode(this.toString(node.old_name), this.toString(node.new_name));
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitAliasMethodNode(Nodes.AliasMethodNode node) {
        ModuleNodes.AliasKeywordNode rubyNode = new ModuleNodes.AliasKeywordNode(node.new_name.accept(this), node.old_name.accept(this));
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitAlternationPatternNode(Nodes.AlternationPatternNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPPatternMatchingTranslator");
    }

    @Override
    public RubyNode visitAndNode(Nodes.AndNode node) {
        RubyNode left = node.left.accept(this);
        RubyNode right = node.right.accept(this);
        AndNode rubyNode = AndNodeGen.create(left, right);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitArgumentsNode(Nodes.ArgumentsNode node) {
        Nodes.Node[] values = node.arguments;
        if (values.length == 1) {
            return values[0].accept(this);
        }
        RubyNode[] translatedValues = this.translate(values);
        ArrayLiteralNode rubyNode = ArrayLiteralNode.create(this.language, translatedValues);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitArrayNode(Nodes.ArrayNode node) {
        RubyNode rubyNode = this.translateExpressionsList(node.elements);
        if (!rubyNode.hasSource()) {
            this.assignPositionAndFlags(node, rubyNode);
        }
        return rubyNode;
    }

    @Override
    public RubyNode visitArrayPatternNode(Nodes.ArrayPatternNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPPatternMatchingTranslator");
    }

    @Override
    public RubyNode visitAssocNode(Nodes.AssocNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in visitHashNode/getKeywordArgumentsDescriptor");
    }

    @Override
    public RubyNode visitAssocSplatNode(Nodes.AssocSplatNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in visitHashNode/getKeywordArgumentsDescriptor");
    }

    @Override
    public RubyNode visitBackReferenceReadNode(Nodes.BackReferenceReadNode node) {
        ReadGlobalVariableNode rubyNode = ReadGlobalVariableNodeGen.create(node.name);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitBeginNode(Nodes.BeginNode node) {
        RubyNode rubyNode = node.statements != null ? node.statements.accept(this) : new NilLiteralNode();
        if (node.rescue_clause == null && node.ensure_clause == null) {
            assert (node.else_clause == null);
            return rubyNode;
        }
        if (node.rescue_clause != null) {
            ArrayList<RescueNode> rescueNodes = new ArrayList<RescueNode>();
            Nodes.RescueNode rescueClause = node.rescue_clause;
            while (rescueClause != null) {
                boolean canOmitBacktrace;
                boolean bl = canOmitBacktrace = this.language.options.BACKTRACES_OMIT_UNUSED && rescueClause.reference == null && (rescueClause.statements == null || rescueClause.statements.body.length == 1 && this.isSideEffectFreeRescueExpression(rescueClause.statements.body[0]));
                if (rescueClause.exceptions.length != 0) {
                    ArrayList<Nodes.Node> exceptionNodes = new ArrayList<Nodes.Node>();
                    for (Nodes.Node exceptionNode : rescueClause.exceptions) {
                        if (exceptionNode instanceof Nodes.SplatNode) {
                            RubyNode translatedBody;
                            Nodes.SplatNode splatNode = (Nodes.SplatNode)exceptionNode;
                            if (!exceptionNodes.isEmpty()) {
                                RescueNode rescueNode = this.translateExceptionNodes(exceptionNodes, rescueClause, canOmitBacktrace);
                                rescueNodes.add(rescueNode);
                                exceptionNodes.clear();
                            }
                            RubyNode splatTranslated = this.translateNodeOrNil(splatNode.expression);
                            if (rescueClause.reference != null) {
                                RubyNode exceptionWriteNode = this.translateRescueException(rescueClause.reference);
                                translatedBody = this.translateNodeOrNil(rescueClause.statements);
                                translatedBody = YARPTranslator.sequence(rescueClause, exceptionWriteNode, translatedBody);
                            } else {
                                translatedBody = this.translateNodeOrNil(rescueClause.statements);
                            }
                            RescueSplatNode rescueNode = new RescueSplatNode(this.language, splatTranslated, translatedBody, canOmitBacktrace);
                            this.assignPositionAndFlags(splatNode, rescueNode);
                            rescueNodes.add(rescueNode);
                            continue;
                        }
                        exceptionNodes.add(exceptionNode);
                    }
                    if (!exceptionNodes.isEmpty()) {
                        rescueNode = this.translateExceptionNodes(exceptionNodes, rescueClause, canOmitBacktrace);
                        rescueNodes.add(rescueNode);
                    }
                } else {
                    RubyNode translatedBody;
                    if (rescueClause.reference != null) {
                        RubyNode exceptionWriteNode = this.translateRescueException(rescueClause.reference);
                        translatedBody = this.translateNodeOrNil(rescueClause.statements);
                        translatedBody = YARPTranslator.sequence(rescueClause, exceptionWriteNode, translatedBody);
                    } else {
                        translatedBody = this.translateNodeOrNil(rescueClause.statements);
                    }
                    rescueNode = new RescueStandardErrorNode(translatedBody, canOmitBacktrace);
                    this.assignPositionAndFlags(rescueClause, rescueNode);
                    rescueNodes.add(rescueNode);
                }
                rescueClause = rescueClause.subsequent;
            }
            RubyNode elsePart = node.else_clause == null ? null : node.else_clause.accept(this);
            rubyNode = TryNodeGen.create(rubyNode, rescueNodes.toArray(EMPTY_RESCUE_NODE_ARRAY), elsePart);
            this.assignPositionAndFlags(node, rubyNode);
        }
        if (node.ensure_clause != null && node.ensure_clause.statements != null) {
            RubyNode ensureBlock = node.ensure_clause.accept(this);
            rubyNode = EnsureNodeGen.create(rubyNode, ensureBlock);
            YARPTranslator.assignPositionOnly(node, rubyNode);
        }
        return rubyNode;
    }

    private RescueNode translateExceptionNodes(ArrayList<Nodes.Node> exceptionNodes, Nodes.RescueNode rescueClause, boolean canOmitBacktrace) {
        RubyNode translatedBody;
        Nodes.Node[] exceptionNodesArray = exceptionNodes.toArray(EMPTY_NODE_ARRAY);
        RubyNode[] handlingClasses = this.translate(exceptionNodesArray);
        if (rescueClause.reference != null) {
            RubyNode exceptionWriteNode = this.translateRescueException(rescueClause.reference);
            RubyNode translatedStatements = this.translateNodeOrNil(rescueClause.statements);
            translatedBody = YARPTranslator.sequence(rescueClause, exceptionWriteNode, translatedStatements);
        } else {
            translatedBody = this.translateNodeOrNil(rescueClause.statements);
        }
        RescueClassesNode rescueNode = new RescueClassesNode(handlingClasses, translatedBody, canOmitBacktrace);
        this.assignPositionOnly(exceptionNodesArray, rescueNode);
        return rescueNode;
    }

    @Override
    public RubyNode visitBlockLocalVariableNode(Nodes.BlockLocalVariableNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in translateBlockAndLambda");
    }

    @Override
    public RubyNode visitBlockNode(Nodes.BlockNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"BlockNode should be translated specially by its parent node to pass the method name to which the block is passed");
    }

    private RubyNode visitBlockNode(Nodes.BlockNode node, String literalBlockPassedToMethod) {
        return this.translateBlockAndLambda(node, node.parameters, node.body, node.locals, literalBlockPassedToMethod);
    }

    private RubyNode translateBlockAndLambda(Nodes.Node node, Nodes.Node parametersNode, Nodes.Node body, String[] locals, String literalBlockPassedToMethod) {
        Nodes.ParametersNode parameters;
        boolean isStabbyLambda = node instanceof Nodes.LambdaNode;
        boolean hasOwnScope = !this.translatingForStatement;
        TranslatorEnvironment methodParent = this.environment.getSurroundingMethodEnvironment();
        String methodName = methodParent.getMethodName();
        int blockDepth = this.environment.getBlockDepth() + 1;
        if (parametersNode instanceof Nodes.BlockParametersNode) {
            Nodes.BlockParametersNode blockParameters = (Nodes.BlockParametersNode)parametersNode;
            parameters = blockParameters.parameters != null ? blockParameters.parameters : ZERO_PARAMETERS_NODE;
        } else if (parametersNode instanceof Nodes.NumberedParametersNode) {
            Nodes.NumberedParametersNode numberedParameters = (Nodes.NumberedParametersNode)parametersNode;
            int maximum = numberedParameters.maximum;
            Nodes.Node[] requireds = new Nodes.RequiredParameterNode[maximum];
            for (int i = 1; i <= maximum; ++i) {
                String name = numberedParameterNames[i];
                requireds[i - 1] = new Nodes.RequiredParameterNode(0, 0, 0, name);
            }
            parameters = new Nodes.ParametersNode(0, 0, requireds, EMPTY_OPTIONAL_PARAMETER_NODE_ARRAY, null, EMPTY_NODE_ARRAY, EMPTY_NODE_ARRAY, null, null);
        } else if (parametersNode == null) {
            parameters = ZERO_PARAMETERS_NODE;
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        Arity arity = this.createArity(parameters);
        ArgumentDescriptor[] argumentDescriptors = this.parametersNodeToArgumentDescriptors(parameters);
        String originalName = SharedMethodInfo.getBlockName(blockDepth, methodName);
        String parseName = SharedMethodInfo.getBlockName(blockDepth, methodParent.getSharedMethodInfo().getParseName());
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(this.getSourceSection(node), this.environment.getStaticLexicalScopeOrNull(), arity, originalName, blockDepth, parseName, methodName, argumentDescriptors);
        ReturnID returnID = isStabbyLambda ? this.parseEnvironment.allocateReturnID() : this.environment.getReturnID();
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.environment, this.parseEnvironment, returnID, hasOwnScope, false, sharedMethodInfo, this.environment.getMethodName(), blockDepth, this.parseEnvironment.allocateBreakID(), null, this.environment.modulePath);
        newEnvironment.literalBlockPassedToMethod = literalBlockPassedToMethod;
        YARPBlockNodeTranslator methodCompiler = new YARPBlockNodeTranslator(newEnvironment, arity, parameters.block != null, this.rubyWarnings);
        methodCompiler.frameOnStackMarkerSlotStack = this.frameOnStackMarkerSlotStack;
        RubyNode rubyNode = methodCompiler.compileBlockNode(body, parameters, locals, isStabbyLambda, this.getSourceSection(node));
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitBlockArgumentNode(Nodes.BlockArgumentNode node) {
        RubyNode valueNode = node.expression == null ? this.environment.findLocalVarNode("%forward_block") : node.expression.accept(this);
        ToProcNode rubyNode = ToProcNodeGen.create(valueNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitBlockParameterNode(Nodes.BlockParameterNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPLoadArgumentsTranslator");
    }

    @Override
    public RubyNode visitBlockParametersNode(Nodes.BlockParametersNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in translateBlockAndLambda");
    }

    @Override
    public RubyNode visitBreakNode(Nodes.BreakNode node) {
        if (!this.environment.isBlock() && !this.translatingWhile) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("Invalid break", this.currentNode, this.getSourceSection(node)));
        }
        RubyNode argumentsNode = this.translateControlFlowArguments(node.arguments);
        BreakNode rubyNode = new BreakNode(this.environment.getBreakID(), this.translatingWhile, argumentsNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitCallAndWriteNode(Nodes.CallAndWriteNode node) {
        RubyNode sequence;
        assert (node.receiver != null);
        YARPExecutedOnceExpression receiverExpression = new YARPExecutedOnceExpression("value", node.receiver, this);
        RubyNode writeReceiverNode = receiverExpression.getWriteNode();
        Nodes.Node readReceiver = receiverExpression.getReadYARPNode();
        short writeFlags = (short)(node.flags | 0x10);
        writeFlags = (short)(writeFlags & 0xFFFFFFFB);
        short readFlags = (short)(node.flags & 0xFFFFFFFB);
        RubyNode readNode = YARPTranslator.callNode((Nodes.Node)node, readFlags, readReceiver, node.read_name, Nodes.Node.EMPTY_ARRAY).accept(this);
        RubyNode writeNode = YARPTranslator.callNode((Nodes.Node)node, writeFlags, readReceiver, node.write_name, node.value).accept(this);
        AndNode andNode = AndNodeGen.create(readNode, writeNode);
        if (node.isSafeNavigation()) {
            UnlessNode unlessNode = UnlessNodeGen.create(new IsNilNode(receiverExpression.getReadNode()), andNode);
            sequence = YARPTranslator.sequence(writeReceiverNode, unlessNode);
        } else {
            sequence = YARPTranslator.sequence(writeReceiverNode, andNode);
        }
        DefinedWrapperNode rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, sequence);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitCallNode(Nodes.CallNode node) {
        Nodes.Node tstring;
        String methodName = node.name;
        SelfNode receiver = node.receiver == null ? new SelfNode() : node.receiver.accept(this);
        ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(node.arguments, node.block, methodName);
        RubyNode[] translatedArguments = argumentsAndBlock.arguments;
        if (this.parseEnvironment.inCore() && node.isVariableCall() && methodName.equals("undefined")) {
            ObjectLiteralNode rubyNode = new ObjectLiteralNode(NotProvided.INSTANCE);
            return this.assignPositionAndFlags(node, rubyNode);
        }
        Nodes.Node node2 = node.receiver;
        if (node2 instanceof Nodes.StringNode) {
            Nodes.StringNode stringNode = (Nodes.StringNode)node2;
            if (methodName.equals("freeze") || methodName.equals("-@") || methodName.equals("dedup")) {
                tstring = TStringUtils.fromByteArray(stringNode.unescaped, this.sourceEncoding);
                ImmutableRubyString frozenString = this.language.getFrozenStringLiteral((TruffleString)tstring, this.sourceEncoding);
                FrozenStringLiteralNode rubyNode = new FrozenStringLiteralNode(frozenString, FrozenStrings.METHOD);
                return this.assignPositionAndFlags(node, rubyNode);
            }
        }
        if (this.parseEnvironment.canUsePrimitives() && (tstring = node.receiver) instanceof Nodes.ConstantReadNode) {
            Nodes.ConstantReadNode constantReadNode = (Nodes.ConstantReadNode)tstring;
            if (constantReadNode.name.equals("Primitive")) {
                PrimitiveNodeConstructor constructor = this.language.primitiveManager.getPrimitive(methodName);
                if (translatedArguments.length != constructor.getPrimitiveArity()) {
                    throw new Error("Incorrect number of arguments (expected " + constructor.getPrimitiveArity() + ") at " + RubyLanguage.getCurrentContext().fileLine(this.getSourceSection(node)));
                }
                RubyNode invokePrimitiveNode = constructor.createInvokePrimitiveNode(translatedArguments);
                this.assignPositionAndFlags(node, invokePrimitiveNode);
                return invokePrimitiveNode;
            }
        }
        RubyCallNodeParameters callNodeParameters = new RubyCallNodeParameters(receiver, methodName, argumentsAndBlock.block, argumentsAndBlock.argumentsDescriptor, translatedArguments, argumentsAndBlock.isSplatted, node.isIgnoreVisibility(), node.isVariableCall(), node.isSafeNavigation(), node.isAttributeWrite());
        RubyContextSourceNode callNode = this.language.coreMethodAssumptions.createCallNode(callNodeParameters);
        RubyNode rubyNode = YARPTranslator.wrapCallWithLiteralBlock(argumentsAndBlock, callNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    private static RubyNode wrapCallWithLiteralBlock(ArgumentsAndBlockTranslation argumentsAndBlock, RubyNode callNode) {
        RubyNode rubyNode = argumentsAndBlock.block;
        if (rubyNode instanceof BlockDefinitionNode) {
            BlockDefinitionNode blockDef = (BlockDefinitionNode)rubyNode;
            FrameOnStackNode frameOnStackNode = new FrameOnStackNode(callNode, argumentsAndBlock.frameOnStackMarkerSlot);
            return new CatchBreakNode(blockDef.getBreakID(), frameOnStackNode, false);
        }
        return callNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArgumentsAndBlockTranslation translateArgumentsAndBlock(Nodes.ArgumentsNode argumentsNode, Nodes.Node block, String methodName) {
        RubyNode blockNode;
        int frameOnStackMarkerSlot;
        Nodes.Node[] forwarding;
        boolean isForwardArguments;
        Nodes.Node[] arguments = argumentsNode == null ? EMPTY_NODE_ARRAY : argumentsNode.arguments;
        boolean bl = isForwardArguments = arguments.length > 0 && ArrayUtils.getLast(arguments) instanceof Nodes.ForwardingArgumentsNode;
        if (isForwardArguments) {
            Nodes.LocalVariableReadNode readRest = new Nodes.LocalVariableReadNode(0, 0, "%forward_rest", 0);
            Nodes.LocalVariableReadNode readKeyRest = new Nodes.LocalVariableReadNode(0, 0, "%forward_kwrest", 0);
            Nodes.SplatNode splat = new Nodes.SplatNode(0, 0, readRest);
            Nodes.KeywordHashNode keywordHash = new Nodes.KeywordHashNode(0, 0, 0, new Nodes.Node[]{new Nodes.AssocSplatNode(0, 0, readKeyRest)});
            forwarding = new Nodes.Node[arguments.length + 1];
            System.arraycopy(arguments, 0, forwarding, 0, arguments.length - 1);
            forwarding[forwarding.length - 2] = splat;
            forwarding[forwarding.length - 1] = keywordHash;
            arguments = forwarding;
        }
        boolean isSplatted = this.containYARPSplatNode(arguments);
        ArgumentsDescriptor argumentsDescriptor = this.getKeywordArgumentsDescriptor(arguments);
        RubyNode[] translatedArguments = isSplatted ? new RubyNode[]{this.translateExpressionsList(arguments)} : this.translate(arguments);
        if (isSplatted && translatedArguments.length == 1 && (forwarding = translatedArguments[0]) instanceof SplatCastNode) {
            SplatCastNode splatNode = (SplatCastNode)forwarding;
            splatNode.doNotCopy();
        }
        if (block != null) {
            if (block instanceof Nodes.BlockNode) {
                Nodes.BlockNode b = (Nodes.BlockNode)block;
                frameOnStackMarkerSlot = this.environment.declareLocalTemp("frame_on_stack_marker");
                this.frameOnStackMarkerSlotStack.push(frameOnStackMarkerSlot);
                try {
                    blockNode = this.visitBlockNode(b, methodName);
                    return new ArgumentsAndBlockTranslation(blockNode, translatedArguments, isSplatted, argumentsDescriptor, frameOnStackMarkerSlot);
                }
                finally {
                    this.frameOnStackMarkerSlotStack.pop();
                }
            } else {
                if (!(block instanceof Nodes.BlockArgumentNode)) throw CompilerDirectives.shouldNotReachHere();
                Nodes.BlockArgumentNode blockArgument = (Nodes.BlockArgumentNode)block;
                blockNode = blockArgument.accept(this);
                frameOnStackMarkerSlot = -1;
            }
            return new ArgumentsAndBlockTranslation(blockNode, translatedArguments, isSplatted, argumentsDescriptor, frameOnStackMarkerSlot);
        } else if (isForwardArguments) {
            Nodes.LocalVariableReadNode readBlock = new Nodes.LocalVariableReadNode(0, 0, "%forward_block", 0);
            RubyNode readBlockNode = readBlock.accept(this);
            blockNode = ToProcNodeGen.create(readBlockNode);
            frameOnStackMarkerSlot = -1;
            return new ArgumentsAndBlockTranslation(blockNode, translatedArguments, isSplatted, argumentsDescriptor, frameOnStackMarkerSlot);
        } else {
            blockNode = null;
            frameOnStackMarkerSlot = -1;
        }
        return new ArgumentsAndBlockTranslation(blockNode, translatedArguments, isSplatted, argumentsDescriptor, frameOnStackMarkerSlot);
    }

    private ArgumentsDescriptor getKeywordArgumentsDescriptor(Nodes.Node[] arguments) {
        if (arguments.length == 0) {
            return NoKeywordArgumentsDescriptor.INSTANCE;
        }
        Nodes.Node last = ArrayUtils.getLast(arguments);
        if (last instanceof Nodes.ForwardingArgumentsNode) {
            return KeywordArgumentsDescriptor.EMPTY;
        }
        if (!(last instanceof Nodes.KeywordHashNode)) {
            return NoKeywordArgumentsDescriptor.INSTANCE;
        }
        Nodes.KeywordHashNode keywords = (Nodes.KeywordHashNode)last;
        ArrayList<String> names = new ArrayList<String>();
        boolean keyrest = false;
        boolean nonKeywordKeys = false;
        for (Nodes.Node n : keywords.elements) {
            if (n instanceof Nodes.AssocNode) {
                Nodes.AssocNode assoc = (Nodes.AssocNode)n;
                Nodes.Node node = assoc.key;
                if (node instanceof Nodes.SymbolNode) {
                    Nodes.SymbolNode symbol = (Nodes.SymbolNode)node;
                    names.add(this.toString(symbol.unescaped));
                    continue;
                }
            }
            if (n instanceof Nodes.AssocNode) {
                Nodes.AssocNode assoc = (Nodes.AssocNode)n;
                if (!(assoc.key instanceof Nodes.SymbolNode)) {
                    nonKeywordKeys = true;
                    continue;
                }
            }
            if (n instanceof Nodes.AssocSplatNode) {
                keyrest = true;
                continue;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (keyrest || nonKeywordKeys || !names.isEmpty()) {
            return this.language.keywordArgumentsDescriptorManager.getArgumentsDescriptor(names.toArray(StringUtils.EMPTY_STRING_ARRAY));
        }
        return NoKeywordArgumentsDescriptor.INSTANCE;
    }

    @Override
    public RubyNode visitCallOperatorWriteNode(Nodes.CallOperatorWriteNode node) {
        RubyNode sequence;
        assert (node.receiver != null);
        YARPExecutedOnceExpression receiverExpression = new YARPExecutedOnceExpression("value", node.receiver, this);
        RubyNode writeReceiverNode = receiverExpression.getWriteNode();
        Nodes.Node readReceiver = receiverExpression.getReadYARPNode();
        short writeFlags = (short)(node.flags | 0x10);
        writeFlags = (short)(writeFlags & 0xFFFFFFFB);
        short readFlags = (short)(node.flags & 0xFFFFFFFB);
        Nodes.CallNode read = YARPTranslator.callNode((Nodes.Node)node, readFlags, readReceiver, node.read_name, Nodes.Node.EMPTY_ARRAY);
        Nodes.CallNode executeOperator = YARPTranslator.callNode((Nodes.Node)node, read, node.binary_operator, node.value);
        Nodes.CallNode write = YARPTranslator.callNode((Nodes.Node)node, writeFlags, readReceiver, node.write_name, executeOperator);
        RubyNode writeNode = ((Nodes.Node)write).accept(this);
        if (node.isSafeNavigation()) {
            UnlessNode unlessNode = UnlessNodeGen.create(new IsNilNode(receiverExpression.getReadNode()), writeNode);
            sequence = YARPTranslator.sequence(writeReceiverNode, unlessNode);
        } else {
            sequence = YARPTranslator.sequence(writeReceiverNode, writeNode);
        }
        DefinedWrapperNode rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, sequence);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitCallOrWriteNode(Nodes.CallOrWriteNode node) {
        RubyNode sequence;
        assert (node.receiver != null);
        YARPExecutedOnceExpression receiverExpression = new YARPExecutedOnceExpression("value", node.receiver, this);
        RubyNode writeReceiverNode = receiverExpression.getWriteNode();
        Nodes.Node readReceiver = receiverExpression.getReadYARPNode();
        short writeFlags = (short)(node.flags | 0x10);
        writeFlags = (short)(writeFlags & 0xFFFFFFFB);
        short readFlags = (short)(node.flags & 0xFFFFFFFB);
        RubyNode readNode = YARPTranslator.callNode((Nodes.Node)node, readFlags, readReceiver, node.read_name, Nodes.Node.EMPTY_ARRAY).accept(this);
        RubyNode writeNode = YARPTranslator.callNode((Nodes.Node)node, writeFlags, readReceiver, node.write_name, node.value).accept(this);
        OrLazyValueDefinedNode orNode = OrLazyValueDefinedNodeGen.create(readNode, writeNode);
        if (node.isSafeNavigation()) {
            UnlessNode unlessNode = UnlessNodeGen.create(new IsNilNode(receiverExpression.getReadNode()), orNode);
            sequence = YARPTranslator.sequence(writeReceiverNode, unlessNode);
        } else {
            sequence = YARPTranslator.sequence(writeReceiverNode, orNode);
        }
        DefinedWrapperNode rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, sequence);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitCallTargetNode(Nodes.CallTargetNode node) {
        assert (node.name.endsWith("="));
        Nodes.Node[] arguments = new Nodes.Node[]{new Nodes.NilNode(0, 0)};
        Nodes.ArgumentsNode argumentsNode = new Nodes.ArgumentsNode(0, 0, 0, arguments);
        short flags = (short)(node.flags | 0x10);
        Nodes.CallNode callNode = new Nodes.CallNode(node.startOffset, node.length, flags, node.receiver, node.name, argumentsNode, null);
        return callNode.accept(this);
    }

    @Override
    public RubyNode visitCapturePatternNode(Nodes.CapturePatternNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPPatternMatchingTranslator");
    }

    @Override
    public RubyNode visitCaseMatchNode(Nodes.CaseMatchNode node) {
        YARPPatternMatchingTranslator translator = new YARPPatternMatchingTranslator(this.environment, this);
        YARPExecutedOnceExpression predicateExpression = new YARPExecutedOnceExpression("case in value", node.predicate, this);
        RubyNode writePredicateNode = predicateExpression.getWriteNode();
        RubyNode readPredicateNode = predicateExpression.getReadNode();
        RubyNode elseNode = node.else_clause == null ? NoMatchingPatternNodeGen.create(readPredicateNode) : node.else_clause.accept(this);
        for (int n = node.conditions.length - 1; n >= 0; --n) {
            Nodes.InNode inNode = node.conditions[n];
            Nodes.Node patternNode = inNode.pattern;
            RubyNode conditionNode = translator.translatePatternNode(patternNode, readPredicateNode);
            RubyNode thenNode = this.translateNodeOrNil(inNode.statements);
            IfElseNode ifNode = IfElseNodeGen.create(conditionNode, thenNode, elseNode);
            elseNode = ifNode;
        }
        RubyNode ifNode = elseNode;
        RubyNode ret = YARPTranslator.sequence(writePredicateNode, ifNode);
        return this.assignPositionAndFlags(node, ret);
    }

    @Override
    public RubyNode visitCaseNode(Nodes.CaseNode node) {
        RubyNode rubyNode;
        if (node.predicate != null) {
            YARPExecutedOnceExpression predicateExpression = new YARPExecutedOnceExpression("case", node.predicate, this);
            RubyNode writePredicateNode = predicateExpression.getWriteNode();
            RubyNode readPredicateNode = predicateExpression.getReadNode();
            RubyNode elseNode = this.translateNodeOrNil(node.else_clause);
            Nodes.WhenNode[] whenNodes = node.conditions;
            for (int n = whenNodes.length - 1; n >= 0; --n) {
                Nodes.WhenNode whenNode = whenNodes[n];
                Nodes.Node[] whenConditions = whenNode.conditions;
                boolean containSplatOperator = this.containYARPSplatNode(whenConditions);
                if (containSplatOperator) {
                    TruffleInternalModuleLiteralNode receiver = new TruffleInternalModuleLiteralNode();
                    RubyNode rubyNode2 = this.translateExpressionsList(whenConditions);
                    RubyNode[] arguments = new RubyNode[]{rubyNode2, (RubyNode)NodeUtil.cloneNode((Node)readPredicateNode)};
                    RubyContextSourceNode predicateNode = this.createCallNode(receiver, "when_splat", arguments);
                    RubyNode thenNode = this.translateNodeOrNil(whenNode.statements);
                    IfElseNode ifNode = IfElseNodeGen.create(predicateNode, thenNode, elseNode);
                    elseNode = ifNode;
                    continue;
                }
                RubyContextSourceNode predicateNode = null;
                for (Nodes.Node whenCondition : whenConditions) {
                    RubyNode receiver = whenCondition.accept(this);
                    RubyNode[] arguments = new RubyNode[]{(RubyNode)NodeUtil.cloneNode((Node)readPredicateNode)};
                    RubyContextSourceNode nextPredicateNode = this.createCallNode(receiver, "===", arguments);
                    predicateNode = predicateNode == null ? nextPredicateNode : OrNodeGen.create(predicateNode, nextPredicateNode);
                }
                RubyNode rubyNode3 = this.translateNodeOrNil(whenNode.statements);
                IfElseNode ifNode = IfElseNodeGen.create(predicateNode, rubyNode3, elseNode);
                elseNode = ifNode;
            }
            RubyNode ifNode = elseNode;
            rubyNode = YARPTranslator.sequence(writePredicateNode, ifNode);
        } else {
            RubyNode elseNode = this.translateNodeOrNil(node.else_clause);
            Nodes.WhenNode[] whenNodes = node.conditions;
            for (int n = node.conditions.length - 1; n >= 0; --n) {
                RubyNode whenConditionNode;
                Nodes.WhenNode whenNode = whenNodes[n];
                Nodes.Node[] whenConditions = whenNode.conditions;
                boolean containSplatOperator = this.containYARPSplatNode(whenConditions);
                if (!containSplatOperator) {
                    RubyNode predicateNode = null;
                    for (Nodes.Node node2 : whenConditions) {
                        RubyNode nextPredicateNode = node2.accept(this);
                        predicateNode = predicateNode == null ? nextPredicateNode : OrNodeGen.create(predicateNode, nextPredicateNode);
                    }
                    RubyNode thenNode = this.translateNodeOrNil(whenNode.statements);
                    IfElseNode ifNode = IfElseNodeGen.create(predicateNode, thenNode, elseNode);
                    elseNode = ifNode;
                    continue;
                }
                RubyNode receiver = whenConditionNode = this.translateExpressionsList(whenConditions);
                RubyContextSourceNode predicateNode = this.createCallNode(receiver, "any?", RubyNode.EMPTY_ARRAY);
                RubyNode thenNode = this.translateNodeOrNil(whenNode.statements);
                IfElseNode ifElseNode = IfElseNodeGen.create(predicateNode, thenNode, elseNode);
                elseNode = ifElseNode;
            }
            rubyNode = elseNode;
        }
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitClassNode(Nodes.ClassNode node) {
        RubyNode lexicalParent = this.getParentLexicalScopeForConstant(node.constant_path);
        RubyNode superClass = node.superclass != null ? node.superclass.accept(this) : null;
        DefineClassNode defineOrGetClass = new DefineClassNode(node.name, lexicalParent, superClass);
        YARPTranslator.assignPositionOnly(node, defineOrGetClass);
        RubyNode rubyNode = this.openModule(node, defineOrGetClass, node.name, node.locals, node.body, OpenModule.CLASS, this.shouldUseDynamicConstantLookupForModuleBody(node));
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitClassVariableAndWriteNode(Nodes.ClassVariableAndWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        RubyNode writeNode = new Nodes.ClassVariableWriteNode(startOffset, length, node.name, node.value).accept(this);
        RubyNode readNode = new Nodes.ClassVariableReadNode(startOffset, length, node.name).accept(this);
        AndNode andNode = AndNodeGen.create(readNode, writeNode);
        DefinedWrapperNode rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, andNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitClassVariableOperatorWriteNode(Nodes.ClassVariableOperatorWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        Nodes.ClassVariableReadNode readNode = new Nodes.ClassVariableReadNode(startOffset, length, node.name);
        Nodes.ClassVariableWriteNode desugared = new Nodes.ClassVariableWriteNode(startOffset, length, node.name, YARPTranslator.callNode((Nodes.Node)node, readNode, node.binary_operator, node.value));
        return desugared.accept(this);
    }

    @Override
    public RubyNode visitClassVariableOrWriteNode(Nodes.ClassVariableOrWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        RubyNode writeNode = new Nodes.ClassVariableWriteNode(startOffset, length, node.name, node.value).accept(this);
        RubyNode readNode = new Nodes.ClassVariableReadNode(startOffset, length, node.name).accept(this);
        AndNode andNode = AndNodeGen.create(new DefinedNode(readNode), readNode);
        OrLazyValueDefinedNode rubyNode = OrLazyValueDefinedNodeGen.create(andNode, writeNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitClassVariableReadNode(Nodes.ClassVariableReadNode node) {
        ReadClassVariableNode rubyNode = new ReadClassVariableNode(this.getLexicalScopeNode("class variable lookup", node), node.name);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitClassVariableWriteNode(Nodes.ClassVariableWriteNode node) {
        RubyNode rhs = node.value.accept(this);
        WriteClassVariableNode rubyNode = new WriteClassVariableNode(this.getLexicalScopeNode("set dynamic class variable", node), node.name, rhs);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitClassVariableTargetNode(Nodes.ClassVariableTargetNode node) {
        WriteClassVariableNode rubyNode = new WriteClassVariableNode(this.getLexicalScopeNode("set dynamic class variable", node), node.name, null);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitConstantAndWriteNode(Nodes.ConstantAndWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        RubyNode readNode = new Nodes.ConstantReadNode(startOffset, length, node.name).accept(this);
        RubyNode writeNode = new Nodes.ConstantWriteNode(startOffset, length, node.name, node.value).accept(this);
        AndNode andNode = AndNodeGen.create(readNode, writeNode);
        DefinedWrapperNode rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, andNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitConstantOperatorWriteNode(Nodes.ConstantOperatorWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        Nodes.ConstantReadNode readNode = new Nodes.ConstantReadNode(startOffset, length, node.name);
        Nodes.CallNode operatorNode = YARPTranslator.callNode((Nodes.Node)node, readNode, node.binary_operator, node.value);
        Nodes.ConstantWriteNode writeNode = new Nodes.ConstantWriteNode(startOffset, length, node.name, operatorNode);
        return writeNode.accept(this);
    }

    @Override
    public RubyNode visitConstantOrWriteNode(Nodes.ConstantOrWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        RubyNode writeNode = new Nodes.ConstantWriteNode(startOffset, length, node.name, node.value).accept(this);
        RubyNode readNode = new Nodes.ConstantReadNode(startOffset, length, node.name).accept(this);
        AndNode andNode = AndNodeGen.create(new DefinedNode(readNode), readNode);
        OrLazyValueDefinedNode rubyNode = OrLazyValueDefinedNodeGen.create(andNode, writeNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitConstantPathAndWriteNode(Nodes.ConstantPathAndWriteNode node) {
        DefinedWrapperNode rubyNode;
        RubyNode writeParentNode;
        Nodes.ConstantPathNode target;
        if (node.target.parent != null) {
            YARPExecutedOnceExpression parentExpression = new YARPExecutedOnceExpression("value", node.target.parent, this);
            Nodes.Node readParent = parentExpression.getReadYARPNode();
            target = new Nodes.ConstantPathNode(node.target.startOffset, node.target.length, readParent, node.target.name);
            writeParentNode = parentExpression.getWriteNode();
        } else {
            target = node.target;
            writeParentNode = null;
        }
        RubyNode value = node.value.accept(this);
        ReadConstantNode readNode = (ReadConstantNode)target.accept(this);
        WriteConstantNode writeNode = (WriteConstantNode)readNode.makeWriteNode(value);
        AndNode andNode = AndNodeGen.create(readNode, writeNode);
        if (writeParentNode != null) {
            RubyNode sequence = YARPTranslator.sequence(writeParentNode, andNode);
            rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, sequence);
        } else {
            rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, andNode);
        }
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitConstantPathNode(Nodes.ConstantPathNode node) {
        RubyNode moduleNode = node.parent != null ? node.parent.accept(this) : new ObjectClassLiteralNode();
        ReadConstantNode rubyNode = new ReadConstantNode(moduleNode, node.name);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitConstantPathOperatorWriteNode(Nodes.ConstantPathOperatorWriteNode node) {
        RubyNode rubyNode;
        RubyNode writeParentNode;
        Nodes.ConstantPathNode target;
        if (node.target.parent != null) {
            YARPExecutedOnceExpression parentExpression = new YARPExecutedOnceExpression("value", node.target.parent, this);
            Nodes.Node readParent = parentExpression.getReadYARPNode();
            target = new Nodes.ConstantPathNode(node.target.startOffset, node.target.length, readParent, node.target.name);
            writeParentNode = parentExpression.getWriteNode();
        } else {
            target = node.target;
            writeParentNode = null;
        }
        int startOffset = node.startOffset;
        int length = node.length;
        Nodes.CallNode operatorNode = YARPTranslator.callNode((Nodes.Node)node, target, node.binary_operator, node.value);
        Nodes.ConstantPathWriteNode writeNode = new Nodes.ConstantPathWriteNode(startOffset, length, target, operatorNode);
        if (writeParentNode != null) {
            rubyNode = YARPTranslator.sequence(writeParentNode, writeNode.accept(this));
            this.assignPositionAndFlagsIfMissing(node, rubyNode);
        } else {
            rubyNode = writeNode.accept(this);
        }
        return rubyNode;
    }

    @Override
    public RubyNode visitConstantPathOrWriteNode(Nodes.ConstantPathOrWriteNode node) {
        DefinedWrapperNode rubyNode;
        RubyNode writeParentNode;
        Nodes.ConstantPathNode target;
        if (node.target.parent != null) {
            YARPExecutedOnceExpression parentExpression = new YARPExecutedOnceExpression("value", node.target.parent, this);
            Nodes.Node readParent = parentExpression.getReadYARPNode();
            target = new Nodes.ConstantPathNode(node.target.startOffset, node.target.length, readParent, node.target.name);
            writeParentNode = parentExpression.getWriteNode();
        } else {
            target = node.target;
            writeParentNode = null;
        }
        RubyNode value = node.value.accept(this);
        ReadConstantNode readNode = (ReadConstantNode)target.accept(this);
        WriteConstantNode writeNode = (WriteConstantNode)readNode.makeWriteNode(value);
        AndNode andNode = AndNodeGen.create(new DefinedNode(readNode), readNode);
        OrLazyValueDefinedNode orNode = OrLazyValueDefinedNodeGen.create(andNode, writeNode);
        if (writeParentNode != null) {
            RubyNode sequence = YARPTranslator.sequence(writeParentNode, orNode);
            rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, sequence);
        } else {
            rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, orNode);
        }
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitConstantPathWriteNode(Nodes.ConstantPathWriteNode node) {
        Nodes.ConstantPathNode constantPathNode = node.target;
        RubyNode moduleNode = constantPathNode.parent != null ? constantPathNode.parent.accept(this) : new ObjectClassLiteralNode();
        RubyNode value = node.value.accept(this);
        WriteConstantNode rubyNode = new WriteConstantNode(constantPathNode.name, moduleNode, value);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitConstantPathTargetNode(Nodes.ConstantPathTargetNode node) {
        RubyNode moduleNode = node.parent != null ? node.parent.accept(this) : new ObjectClassLiteralNode();
        WriteConstantNode rubyNode = new WriteConstantNode(node.name, moduleNode, null);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitConstantReadNode(Nodes.ConstantReadNode node) {
        RubyContextSourceNode rubyNode;
        if (this.environment.isDynamicConstantLookup()) {
            if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                RubyLanguage.LOGGER.info(() -> "dynamic constant lookup at " + RubyLanguage.getCurrentContext().fileLine(this.getSourceSection(node)));
            }
            rubyNode = new ReadConstantWithDynamicScopeNode(node.name);
        } else {
            LexicalScope lexicalScope = this.environment.getStaticLexicalScope();
            rubyNode = new ReadConstantWithLexicalScopeNode(lexicalScope, node.name);
        }
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitConstantWriteNode(Nodes.ConstantWriteNode node) {
        RubyNode value = node.value.accept(this);
        RubyNode moduleNode = this.getLexicalScopeModuleNode("set dynamic constant", node);
        WriteConstantNode rubyNode = new WriteConstantNode(node.name, moduleNode, value);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitConstantTargetNode(Nodes.ConstantTargetNode node) {
        RubyNode moduleNode = this.getLexicalScopeModuleNode("set dynamic constant", node);
        WriteConstantNode rubyNode = new WriteConstantNode(node.name, moduleNode, null);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitDefNode(Nodes.DefNode node) {
        SingletonClassNode.SingletonClassASTNode singletonClassNode;
        if (node.receiver != null) {
            RubyNode receiver = node.receiver.accept(this);
            singletonClassNode = SingletonClassNodeGen.SingletonClassASTNodeGen.create(receiver);
        } else {
            singletonClassNode = null;
        }
        Nodes.ParametersNode parameters = node.parameters;
        if (parameters == null) {
            parameters = ZERO_PARAMETERS_NODE;
        }
        Arity arity = this.createArity(parameters);
        ArgumentDescriptor[] argumentDescriptors = this.parametersNodeToArgumentDescriptors(parameters);
        boolean isReceiverSelf = node.receiver instanceof Nodes.SelfNode;
        String parseName = this.modulePathAndMethodName(node.name, node.receiver != null, isReceiverSelf);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(this.getSourceSection(node), this.environment.getStaticLexicalScopeOrNull(), arity, node.name, 0, parseName, null, argumentDescriptors);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.environment, this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, false, sharedMethodInfo, node.name, 0, null, null, this.environment.modulePath);
        newEnvironment.parametersNode = parameters;
        YARPDefNodeTranslator defNodeTranslator = new YARPDefNodeTranslator(this.language, newEnvironment, this.rubyWarnings);
        CachedLazyCallTargetSupplier callTargetSupplier = defNodeTranslator.buildMethodNodeCompiler(node, parameters, arity);
        boolean isDefSingleton = singletonClassNode != null;
        LiteralMethodDefinitionNode rubyNode = new LiteralMethodDefinitionNode(singletonClassNode, node.name, sharedMethodInfo, isDefSingleton, callTargetSupplier);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitDefinedNode(Nodes.DefinedNode node) {
        if (node.value instanceof Nodes.YieldNode && this.isInvalidYield()) {
            NilLiteralNode nilNode = new NilLiteralNode();
            return this.assignPositionAndFlags(node, nilNode);
        }
        RubyNode value = node.value.accept(this);
        DefinedNode rubyNode = new DefinedNode(value);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitElseNode(Nodes.ElseNode node) {
        if (node.statements == null) {
            NilLiteralNode rubyNode = new NilLiteralNode();
            return this.assignPositionAndFlags(node, rubyNode);
        }
        return node.statements.accept(this);
    }

    @Override
    public RubyNode visitEmbeddedStatementsNode(Nodes.EmbeddedStatementsNode node) {
        if (node.statements == null) {
            ObjectLiteralNode rubyNode = new ObjectLiteralNode(this.language.getFrozenStringLiteral(this.sourceEncoding.tencoding.getEmpty(), this.sourceEncoding));
            return this.assignPositionAndFlags(node, rubyNode);
        }
        return node.statements.accept(this);
    }

    @Override
    public RubyNode visitEmbeddedVariableNode(Nodes.EmbeddedVariableNode node) {
        return node.variable.accept(this);
    }

    @Override
    public RubyNode visitEnsureNode(Nodes.EnsureNode node) {
        assert (node.statements != null);
        return node.statements.accept(this);
    }

    @Override
    public RubyNode visitFalseNode(Nodes.FalseNode node) {
        BooleanLiteralNode rubyNode = new BooleanLiteralNode(false);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitFindPatternNode(Nodes.FindPatternNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPPatternMatchingTranslator");
    }

    @Override
    public RubyNode visitFlipFlopNode(Nodes.FlipFlopNode node) {
        RubyNode begin = node.left.accept(this);
        RubyNode end = node.right.accept(this);
        FindDeclarationVariableNodes.FrameSlotAndDepth slotAndDepth = this.createFlipFlopState();
        FlipFlopNode rubyNode = FlipFlopNodeGen.create(begin, end, node.isExcludeEnd(), slotAndDepth.depth, slotAndDepth.slot);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitFloatNode(Nodes.FloatNode node) {
        FloatLiteralNode rubyNode = new FloatLiteralNode(node.value);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitForNode(Nodes.ForNode node) {
        RubyNode rubyNode;
        Nodes.StatementsNode body;
        Nodes.Node writeIndex;
        String parameterName = this.environment.allocateLocalTemp("for");
        Nodes.Node[] requireds = new Nodes.Node[]{new Nodes.RequiredParameterNode(0, 0, 0, parameterName)};
        Nodes.ParametersNode parameters = new Nodes.ParametersNode(0, 0, requireds, EMPTY_OPTIONAL_PARAMETER_NODE_ARRAY, null, Nodes.Node.EMPTY_ARRAY, Nodes.Node.EMPTY_ARRAY, null, null);
        Nodes.BlockParametersNode blockParameters = new Nodes.BlockParametersNode(0, 0, parameters, EMPTY_BLOCK_LOCAL_VARIABLE_NODE_ARRAY);
        Nodes.LocalVariableReadNode readParameter = new Nodes.LocalVariableReadNode(0, 0, parameterName, 0);
        Nodes.Node node2 = node.index;
        if (node2 instanceof Nodes.LocalVariableTargetNode) {
            Nodes.LocalVariableTargetNode target = (Nodes.LocalVariableTargetNode)node2;
            writeIndex = new Nodes.LocalVariableWriteNode(0, 0, target.name, target.depth, readParameter);
        } else {
            node2 = node.index;
            if (node2 instanceof Nodes.InstanceVariableTargetNode) {
                Nodes.InstanceVariableTargetNode target = (Nodes.InstanceVariableTargetNode)node2;
                writeIndex = new Nodes.InstanceVariableWriteNode(0, 0, target.name, readParameter);
            } else {
                node2 = node.index;
                if (node2 instanceof Nodes.ClassVariableTargetNode) {
                    Nodes.ClassVariableTargetNode target = (Nodes.ClassVariableTargetNode)node2;
                    writeIndex = new Nodes.ClassVariableWriteNode(0, 0, target.name, readParameter);
                } else {
                    node2 = node.index;
                    if (node2 instanceof Nodes.GlobalVariableTargetNode) {
                        Nodes.GlobalVariableTargetNode target = (Nodes.GlobalVariableTargetNode)node2;
                        writeIndex = new Nodes.GlobalVariableWriteNode(0, 0, target.name, readParameter);
                    } else {
                        node2 = node.index;
                        if (node2 instanceof Nodes.ConstantTargetNode) {
                            Nodes.ConstantTargetNode target = (Nodes.ConstantTargetNode)node2;
                            writeIndex = new Nodes.ConstantWriteNode(0, 0, target.name, readParameter);
                        } else {
                            node2 = node.index;
                            if (node2 instanceof Nodes.ConstantPathTargetNode) {
                                Nodes.ConstantPathTargetNode target = (Nodes.ConstantPathTargetNode)node2;
                                constantPath = new Nodes.ConstantPathNode(0, 0, target.parent, target.name);
                                writeIndex = new Nodes.ConstantPathWriteNode(0, 0, (Nodes.ConstantPathNode)constantPath, readParameter);
                            } else {
                                constantPath = node.index;
                                if (constantPath instanceof Nodes.CallTargetNode) {
                                    Nodes.CallTargetNode target = (Nodes.CallTargetNode)constantPath;
                                    arguments = new Nodes.ArgumentsNode(0, 0, 0, new Nodes.Node[]{readParameter});
                                    short flags = (short)(target.flags | 0x10);
                                    writeIndex = new Nodes.CallNode(0, 0, flags, target.receiver, target.name, (Nodes.ArgumentsNode)arguments, null);
                                } else {
                                    arguments = node.index;
                                    if (arguments instanceof Nodes.IndexTargetNode) {
                                        Nodes.Node[] statements;
                                        Nodes.IndexTargetNode target = (Nodes.IndexTargetNode)arguments;
                                        if (target.arguments != null) {
                                            statements = new Nodes.Node[target.arguments.arguments.length + 1];
                                            System.arraycopy(target.arguments.arguments, 0, statements, 0, target.arguments.arguments.length);
                                        } else {
                                            statements = new Nodes.Node[1];
                                        }
                                        statements[statements.length - 1] = readParameter;
                                        arguments = new Nodes.ArgumentsNode(0, 0, 0, statements);
                                        writeIndex = new Nodes.CallNode(0, 0, target.flags, target.receiver, "[]=", (Nodes.ArgumentsNode)arguments, target.block);
                                    } else {
                                        node2 = node.index;
                                        if (node2 instanceof Nodes.MultiTargetNode) {
                                            Nodes.MultiTargetNode target = (Nodes.MultiTargetNode)node2;
                                            writeIndex = new Nodes.MultiWriteNode(0, 0, target.lefts, target.rest, target.rights, readParameter);
                                        } else {
                                            throw CompilerDirectives.shouldNotReachHere((String)"Unexpected node class for for-loop index");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        int bodyStartOffset = node.collection.endOffset();
        int bodyLength = node.endOffset() - bodyStartOffset;
        if (node.statements != null) {
            statements = new Nodes.Node[1 + node.statements.body.length];
            statements[0] = writeIndex;
            System.arraycopy(node.statements.body, 0, statements, 1, node.statements.body.length);
            body = new Nodes.StatementsNode(bodyStartOffset, bodyLength, statements);
        } else {
            statements = new Nodes.Node[]{writeIndex};
            body = new Nodes.StatementsNode(bodyStartOffset, bodyLength, statements);
        }
        String[] locals = new String[]{parameterName};
        Nodes.BlockNode block = new Nodes.BlockNode(bodyStartOffset, bodyLength, locals, blockParameters, body);
        Nodes.CallNode eachCall = new Nodes.CallNode(node.startOffset, node.length, 0, node.collection, "each", null, block);
        boolean translatingForStatement = this.translatingForStatement;
        this.translatingForStatement = true;
        try {
            rubyNode = eachCall.accept(this);
        }
        finally {
            this.translatingForStatement = translatingForStatement;
        }
        this.copyNewlineFlag(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitForwardingArgumentsNode(Nodes.ForwardingArgumentsNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in visitCallNode");
    }

    @Override
    public RubyNode visitForwardingParameterNode(Nodes.ForwardingParameterNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPLoadArgumentsTranslator");
    }

    @Override
    public RubyNode visitForwardingSuperNode(Nodes.ForwardingSuperNode node) {
        ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(null, node.block, this.environment.getMethodName());
        boolean insideDefineMethod = false;
        TranslatorEnvironment environment = this.environment;
        while (environment.isBlock()) {
            if (Objects.equals(environment.literalBlockPassedToMethod, "define_method")) {
                insideDefineMethod = true;
            }
            environment = environment.getParent();
        }
        if (environment.isModuleBody()) {
            return this.assignPositionAndFlags(node, new ZSuperOutsideMethodNode(insideDefineMethod));
        }
        Nodes.ParametersNode parametersNode = environment.parametersNode;
        if (parametersNode == null) {
            parametersNode = ZERO_PARAMETERS_NODE;
        }
        YARPReloadArgumentsTranslator reloadTranslator = new YARPReloadArgumentsTranslator(this.environment, this, parametersNode);
        RubyNode[] reloadSequence = reloadTranslator.reload(parametersNode);
        KeywordArgumentsDescriptor descriptor = parametersNode.keywords.length > 0 || parametersNode.keyword_rest != null ? KeywordArgumentsDescriptor.EMPTY : NoKeywordArgumentsDescriptor.INSTANCE;
        int restParamIndex = reloadTranslator.getRestParameterIndex();
        ReadZSuperArgumentsNode arguments = new ReadZSuperArgumentsNode(restParamIndex, reloadSequence);
        RubyNode block = this.explicitOrInheritedBlock(argumentsAndBlock.block);
        boolean isSplatted = reloadTranslator.getRestParameterIndex() != -1;
        RubyNode callNode = new SuperCallNode(isSplatted, arguments, block, descriptor);
        callNode = YARPTranslator.wrapCallWithLiteralBlock(argumentsAndBlock, callNode);
        return this.assignPositionAndFlags(node, callNode);
    }

    @Override
    public RubyNode visitGlobalVariableAndWriteNode(Nodes.GlobalVariableAndWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        RubyNode writeNode = new Nodes.GlobalVariableWriteNode(startOffset, length, node.name, node.value).accept(this);
        RubyNode readNode = new Nodes.GlobalVariableReadNode(startOffset, length, node.name).accept(this);
        AndNode andNode = AndNodeGen.create(readNode, writeNode);
        DefinedWrapperNode rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, andNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitGlobalVariableOperatorWriteNode(Nodes.GlobalVariableOperatorWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        Nodes.GlobalVariableReadNode readNode = new Nodes.GlobalVariableReadNode(startOffset, length, node.name);
        Nodes.GlobalVariableWriteNode desugared = new Nodes.GlobalVariableWriteNode(startOffset, length, node.name, YARPTranslator.callNode((Nodes.Node)node, readNode, node.binary_operator, node.value));
        return desugared.accept(this);
    }

    @Override
    public RubyNode visitGlobalVariableOrWriteNode(Nodes.GlobalVariableOrWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        RubyNode writeNode = new Nodes.GlobalVariableWriteNode(startOffset, length, node.name, node.value).accept(this);
        RubyNode readNode = new Nodes.GlobalVariableReadNode(startOffset, length, node.name).accept(this);
        AndNode definedCheck = AndNodeGen.create(new DefinedNode(readNode), readNode);
        OrLazyValueDefinedNode rubyNode = OrLazyValueDefinedNodeGen.create(definedCheck, writeNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitGlobalVariableReadNode(Nodes.GlobalVariableReadNode node) {
        ReadGlobalVariableNode rubyNode = ReadGlobalVariableNodeGen.create(node.name);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitGlobalVariableWriteNode(Nodes.GlobalVariableWriteNode node) {
        RubyNode value = node.value.accept(this);
        WriteGlobalVariableNode rubyNode = WriteGlobalVariableNodeGen.create(node.name, value);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitGlobalVariableTargetNode(Nodes.GlobalVariableTargetNode node) {
        WriteGlobalVariableNode rubyNode = WriteGlobalVariableNodeGen.create(node.name, null);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitHashNode(Nodes.HashNode node) {
        RubyNode rubyNode;
        if (node.elements.length == 0) {
            HashLiteralNode rubyNode2 = HashLiteralNode.create(RubyNode.EMPTY_ARRAY, this.language);
            return this.assignPositionAndFlags(node, rubyNode2);
        }
        ArrayList<RubyContextSourceNodeCustomExecuteVoid> hashConcats = new ArrayList<RubyContextSourceNodeCustomExecuteVoid>();
        ArrayList<RubyNode> keyValues = new ArrayList<RubyNode>();
        for (Nodes.Node pair : node.elements) {
            if (pair instanceof Nodes.AssocSplatNode) {
                Nodes.AssocSplatNode assocSplatNode = (Nodes.AssocSplatNode)pair;
                if (!keyValues.isEmpty()) {
                    HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(keyValues.toArray(RubyNode.EMPTY_ARRAY), this.language);
                    hashConcats.add(hashLiteralSoFar);
                }
                RubyNode valueNode = assocSplatNode.value != null ? assocSplatNode.value.accept(this) : this.environment.findLocalVarNode("%kwrest");
                hashConcats.add(HashCastNodeGen.HashCastASTNodeGen.create(valueNode));
                keyValues.clear();
                continue;
            }
            if (pair instanceof Nodes.AssocNode) {
                Object frozenString;
                Nodes.AssocNode assocNode = (Nodes.AssocNode)pair;
                RubyNode keyNode = assocNode.key.accept(this);
                if (keyNode instanceof StringLiteralNode) {
                    StringLiteralNode stringNode = (StringLiteralNode)keyNode;
                    frozenString = this.language.getFrozenStringLiteral(stringNode.getTString(), stringNode.getEncoding());
                    keyNode = new FrozenStringLiteralNode((ImmutableRubyString)frozenString, FrozenStrings.EXPRESSION);
                }
                keyValues.add(keyNode);
                frozenString = assocNode.value;
                if (frozenString instanceof Nodes.ImplicitNode) {
                    Nodes.ImplicitNode implicit = (Nodes.ImplicitNode)frozenString;
                    Nodes.Node node2 = implicit.value;
                    if (node2 instanceof Nodes.CallNode) {
                        Nodes.CallNode call = (Nodes.CallNode)node2;
                        int flags = call.flags | 8;
                        Nodes.CallNode copy = new Nodes.CallNode(call.startOffset, call.length, (short)flags, call.receiver, call.name, call.arguments, call.block);
                        RubyNode valueNode = copy.accept(this);
                        keyValues.add(valueNode);
                        continue;
                    }
                    RubyNode valueNode = implicit.value.accept(this);
                    keyValues.add(valueNode);
                    continue;
                }
                keyValues.add(assocNode.value.accept(this));
                continue;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (!keyValues.isEmpty()) {
            HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(keyValues.toArray(RubyNode.EMPTY_ARRAY), this.language);
            hashConcats.add(hashLiteralSoFar);
        }
        if (hashConcats.size() == 1) {
            rubyNode = (RubyNode)((Object)hashConcats.get(0));
            return this.assignPositionAndFlags(node, rubyNode);
        }
        rubyNode = new ConcatHashLiteralNode(hashConcats.toArray(RubyNode.EMPTY_ARRAY));
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitHashPatternNode(Nodes.HashPatternNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPPatternMatchingTranslator");
    }

    @Override
    public RubyNode visitIfNode(Nodes.IfNode node) {
        RubyNode elseNode;
        RubyNode conditionNode = node.predicate.accept(this);
        RubyNode thenNode = node.statements == null ? null : node.statements.accept(this);
        RubyNode rubyNode = elseNode = node.subsequent == null ? null : node.subsequent.accept(this);
        if (thenNode != null && elseNode != null) {
            IfElseNode rubyNode2 = IfElseNodeGen.create(conditionNode, thenNode, elseNode);
            return this.assignPositionAndFlags(node, rubyNode2);
        }
        if (thenNode != null) {
            IfNode rubyNode3 = IfNodeGen.create(conditionNode, thenNode);
            return this.assignPositionAndFlags(node, rubyNode3);
        }
        if (elseNode != null) {
            UnlessNode rubyNode4 = UnlessNodeGen.create(conditionNode, elseNode);
            return this.assignPositionAndFlags(node, rubyNode4);
        }
        return YARPTranslator.sequence(node, conditionNode, new NilLiteralNode());
    }

    @Override
    public RubyNode visitImaginaryNode(Nodes.ImaginaryNode node) {
        ObjectClassLiteralNode objectClassNode = new ObjectClassLiteralNode();
        ReadConstantNode complexModuleNode = new ReadConstantNode(objectClassNode, "Complex");
        IntegerFixnumLiteralNode realComponentNode = new IntegerFixnumLiteralNode(0);
        RubyNode imaginaryComponentNode = node.numeric.accept(this);
        RubyNode[] arguments = new RubyNode[]{realComponentNode, imaginaryComponentNode};
        RubyContextSourceNode rubyNode = this.createCallNode(complexModuleNode, "convert", arguments);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitImplicitNode(Nodes.ImplicitNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in #visitHashNode");
    }

    @Override
    public RubyNode visitImplicitRestNode(Nodes.ImplicitRestNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPLoadArgumentsTranslator");
    }

    @Override
    public RubyNode visitInNode(Nodes.InNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPPatternMatchingTranslator");
    }

    @Override
    public RubyNode visitIndexAndWriteNode(Nodes.IndexAndWriteNode node) {
        Nodes.Node[] arguments = node.arguments != null ? node.arguments.arguments : Nodes.Node.EMPTY_ARRAY;
        RubyNode rubyNode = this.translateIndexOrAndIndexAndWriteNodes(true, node.receiver, arguments, node.block, node.value, node.flags);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitIndexOperatorWriteNode(Nodes.IndexOperatorWriteNode node) {
        Nodes.BlockArgumentNode blockArgument;
        RubyNode writeBlockNode;
        assert (node.receiver != null);
        YARPExecutedOnceExpression receiverExpression = new YARPExecutedOnceExpression("opelementassign", node.receiver, this);
        RubyNode writeReceiverNode = receiverExpression.getWriteNode();
        Nodes.Node readReceiver = receiverExpression.getReadYARPNode();
        Nodes.Node[] arguments = node.arguments != null ? node.arguments.arguments : Nodes.Node.EMPTY_ARRAY;
        int argumentsCount = arguments.length;
        if (node.block != null) {
            YARPExecutedOnceExpression expression = new YARPExecutedOnceExpression("value", node.block, this);
            writeBlockNode = expression.getWriteNode();
            Nodes.Node readBlock = expression.getReadYARPNode();
            blockArgument = new Nodes.BlockArgumentNode(0, 0, readBlock);
        } else {
            writeBlockNode = null;
            blockArgument = null;
        }
        RubyNode[] writeArgumentsNodes = new RubyNode[argumentsCount];
        Nodes.Node[] readArguments = new Nodes.Node[argumentsCount];
        for (int i = 0; i < argumentsCount; ++i) {
            YARPExecutedOnceExpression expression = new YARPExecutedOnceExpression("value", arguments[i], this);
            writeArgumentsNodes[i] = expression.getWriteNode();
            readArguments[i] = expression.getReadYARPNode();
        }
        Nodes.CallNode read = new Nodes.CallNode(0, 0, node.flags, readReceiver, "[]", new Nodes.ArgumentsNode(0, 0, 0, readArguments), blockArgument);
        Nodes.CallNode executeOperator = YARPTranslator.callNode((Nodes.Node)node, read, node.binary_operator, node.value);
        Nodes.Node[] readArgumentsAndResult = new Nodes.Node[argumentsCount + 1];
        System.arraycopy(readArguments, 0, readArgumentsAndResult, 0, argumentsCount);
        readArgumentsAndResult[argumentsCount] = executeOperator;
        short writeFlags = (short)(node.flags | 0x10);
        Nodes.CallNode write = new Nodes.CallNode(0, 0, writeFlags, readReceiver, "[]=", new Nodes.ArgumentsNode(0, 0, 0, readArgumentsAndResult), blockArgument);
        RubyNode writeNode = ((Nodes.Node)write).accept(this);
        RubyNode writeArgumentsNode = YARPTranslator.sequence(writeArgumentsNodes);
        RubyNode sequence = node.block != null ? YARPTranslator.sequence(writeArgumentsNode, writeBlockNode, writeReceiverNode, writeNode) : YARPTranslator.sequence(writeArgumentsNode, writeReceiverNode, writeNode);
        DefinedWrapperNode rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, sequence);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitIndexOrWriteNode(Nodes.IndexOrWriteNode node) {
        Nodes.Node[] arguments = node.arguments != null ? node.arguments.arguments : Nodes.Node.EMPTY_ARRAY;
        RubyNode rubyNode = this.translateIndexOrAndIndexAndWriteNodes(false, node.receiver, arguments, node.block, node.value, node.flags);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitIndexTargetNode(Nodes.IndexTargetNode node) {
        Nodes.Node[] arguments;
        if (node.arguments == null) {
            arguments = new Nodes.Node[1];
        } else {
            arguments = new Nodes.Node[node.arguments.arguments.length + 1];
            for (int i = 0; i < node.arguments.arguments.length; ++i) {
                arguments[i] = node.arguments.arguments[i];
            }
        }
        arguments[arguments.length - 1] = new Nodes.NilNode(0, 0);
        Nodes.ArgumentsNode argumentsNode = node.arguments == null ? new Nodes.ArgumentsNode(0, 0, 0, arguments) : new Nodes.ArgumentsNode(node.arguments.startOffset, node.arguments.length, node.arguments.flags, arguments);
        short writeFlags = (short)(node.flags | 0x10);
        Nodes.CallNode callNode = new Nodes.CallNode(node.startOffset, node.length, writeFlags, node.receiver, "[]=", argumentsNode, node.block);
        return callNode.accept(this);
    }

    private RubyNode translateIndexOrAndIndexAndWriteNodes(boolean isAndOperator, Nodes.Node receiver, Nodes.Node[] arguments, Nodes.Node block, Nodes.Node value, short flags) {
        Nodes.BlockArgumentNode blockArgument;
        RubyNode writeBlockNode;
        assert (receiver != null);
        YARPExecutedOnceExpression receiverExpression = new YARPExecutedOnceExpression("opelementassign", receiver, this);
        RubyNode writeReceiverNode = receiverExpression.getWriteNode();
        Nodes.Node readReceiver = receiverExpression.getReadYARPNode();
        RubyNode[] writeArgumentsNodes = new RubyNode[arguments.length];
        Nodes.Node[] readArguments = new Nodes.Node[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            YARPExecutedOnceExpression expression = new YARPExecutedOnceExpression("value", arguments[i], this);
            writeArgumentsNodes[i] = expression.getWriteNode();
            readArguments[i] = expression.getReadYARPNode();
        }
        if (block != null) {
            YARPExecutedOnceExpression expression = new YARPExecutedOnceExpression("value", block, this);
            writeBlockNode = expression.getWriteNode();
            Nodes.Node readBlock = expression.getReadYARPNode();
            blockArgument = new Nodes.BlockArgumentNode(0, 0, readBlock);
        } else {
            writeBlockNode = null;
            blockArgument = null;
        }
        Nodes.CallNode read = new Nodes.CallNode(0, 0, flags, readReceiver, "[]", new Nodes.ArgumentsNode(0, 0, 0, readArguments), blockArgument);
        RubyNode readNode = ((Nodes.Node)read).accept(this);
        Nodes.Node[] readArgumentsAndValue = new Nodes.Node[arguments.length + 1];
        System.arraycopy(readArguments, 0, readArgumentsAndValue, 0, arguments.length);
        readArgumentsAndValue[arguments.length] = value;
        short writeFlags = (short)(flags | 0x10);
        Nodes.CallNode write = new Nodes.CallNode(0, 0, writeFlags, readReceiver, "[]=", new Nodes.ArgumentsNode(0, 0, 0, readArgumentsAndValue), blockArgument);
        RubyNode writeNode = ((Nodes.Node)write).accept(this);
        RubyContextSourceNode operatorNode = isAndOperator ? AndNodeGen.create(readNode, writeNode) : OrLazyValueDefinedNodeGen.create(readNode, writeNode);
        RubyNode writeArgumentsNode = YARPTranslator.sequence(writeArgumentsNodes);
        RubyNode sequence = block != null ? YARPTranslator.sequence(writeArgumentsNode, writeBlockNode, writeReceiverNode, operatorNode) : YARPTranslator.sequence(writeArgumentsNode, writeReceiverNode, operatorNode);
        DefinedWrapperNode rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, sequence);
        return rubyNode;
    }

    @Override
    public RubyNode visitInstanceVariableAndWriteNode(Nodes.InstanceVariableAndWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        RubyNode writeNode = new Nodes.InstanceVariableWriteNode(startOffset, length, node.name, node.value).accept(this);
        RubyNode readNode = new Nodes.InstanceVariableReadNode(startOffset, length, node.name).accept(this);
        AndNode andNode = AndNodeGen.create(readNode, writeNode);
        DefinedWrapperNode rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, andNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitInstanceVariableOperatorWriteNode(Nodes.InstanceVariableOperatorWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        Nodes.InstanceVariableReadNode readNode = new Nodes.InstanceVariableReadNode(startOffset, length, node.name);
        Nodes.InstanceVariableWriteNode desugared = new Nodes.InstanceVariableWriteNode(startOffset, length, node.name, YARPTranslator.callNode((Nodes.Node)node, readNode, node.binary_operator, node.value));
        return desugared.accept(this);
    }

    @Override
    public RubyNode visitInstanceVariableOrWriteNode(Nodes.InstanceVariableOrWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        RubyNode writeNode = new Nodes.InstanceVariableWriteNode(startOffset, length, node.name, node.value).accept(this);
        RubyNode readNode = new Nodes.InstanceVariableReadNode(startOffset, length, node.name).accept(this);
        OrLazyValueDefinedNode rubyNode = OrLazyValueDefinedNodeGen.create(readNode, writeNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitInstanceVariableReadNode(Nodes.InstanceVariableReadNode node) {
        ReadInstanceVariableNode rubyNode = new ReadInstanceVariableNode(node.name);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitInstanceVariableWriteNode(Nodes.InstanceVariableWriteNode node) {
        RubyNode value = node.value.accept(this);
        WriteInstanceVariableNode rubyNode = WriteInstanceVariableNodeGen.create(node.name, value);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitInstanceVariableTargetNode(Nodes.InstanceVariableTargetNode node) {
        WriteInstanceVariableNode rubyNode = WriteInstanceVariableNodeGen.create(node.name, null);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitIntegerNode(Nodes.IntegerNode node) {
        RubyNode rubyNode = this.translateNumericValue(node.value);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    private RubyNode translateNumericValue(Object value) {
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return new IntegerFixnumLiteralNode(i);
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return new LongFixnumLiteralNode(l);
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return new ObjectLiteralNode(new RubyBignum(bigInteger));
        }
        throw CompilerDirectives.shouldNotReachHere((String)value.getClass().getName());
    }

    @Override
    public RubyNode visitInterpolatedMatchLastLineNode(Nodes.InterpolatedMatchLastLineNode node) {
        Nodes.InterpolatedRegularExpressionNode regexp = new Nodes.InterpolatedRegularExpressionNode(node.startOffset, node.length, node.flags, node.parts);
        RubyNode regexpNode = regexp.accept(this);
        ReadGlobalVariableNode lastLineNode = ReadGlobalVariableNodeGen.create("$_");
        RubyContextSourceNode rubyNode = this.createCallNode(false, regexpNode, "=~", lastLineNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitInterpolatedRegularExpressionNode(Nodes.InterpolatedRegularExpressionNode node) {
        RegexpEncodingAndOptions encodingAndOptions = this.getRegexpEncodingAndOptions(new Nodes.RegularExpressionFlags(node.flags));
        RegexpOptions options = encodingAndOptions.options;
        ToSNode[] children = this.translateInterpolatedPartsIgnoreForceEncodingFlags(node.parts);
        RubyEncoding encoding = !options.isKcodeDefault() ? encodingAndOptions.encoding : Encodings.BINARY;
        for (ToSNode child : children) {
            TStringWithEncoding fragment;
            if (!(child.getValueNode() instanceof FrozenStringLiteralNode) && !(child.getValueNode() instanceof StringLiteralNode)) continue;
            RubyBaseNodeWithExecute rubyBaseNodeWithExecute = child.getValueNode();
            if (rubyBaseNodeWithExecute instanceof FrozenStringLiteralNode) {
                FrozenStringLiteralNode frozenStringLiteralNode = (FrozenStringLiteralNode)rubyBaseNodeWithExecute;
                ImmutableRubyString frozenString = frozenStringLiteralNode.getFrozenString();
                fragment = new TStringWithEncoding(frozenString.tstring, frozenString.encoding);
            } else {
                rubyBaseNodeWithExecute = child.getValueNode();
                if (rubyBaseNodeWithExecute instanceof StringLiteralNode) {
                    StringLiteralNode stringLiteralNode = (StringLiteralNode)rubyBaseNodeWithExecute;
                    fragment = new TStringWithEncoding(stringLiteralNode.getTString(), stringLiteralNode.getEncoding());
                } else {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            try {
                TStringWithEncoding strEnc = ClassicRegexp.setRegexpEncoding(fragment, options, this.sourceEncoding, this.currentNode);
                ClassicRegexp.preprocessCheck(strEnc);
            }
            catch (DeferredRaiseException dre) {
                throw this.regexpErrorToSyntaxError(dre, node);
            }
        }
        RubyContextSourceNode rubyNode = InterpolatedRegexpNodeGen.create(encoding, options, children);
        if (node.isOnce()) {
            rubyNode = new OnceNode(rubyNode);
        }
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitInterpolatedStringNode(Nodes.InterpolatedStringNode node) {
        if (this.isSourceEncodingOnly(node)) {
            return this.visitStringNode(YARPTranslator.concatStringNodes(node));
        }
        ToSNode[] children = this.translateInterpolatedParts(node.parts);
        InterpolatedStringNode rubyNode = new InterpolatedStringNode(children, this.sourceEncoding);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitInterpolatedSymbolNode(Nodes.InterpolatedSymbolNode node) {
        ToSNode[] children = this.translateInterpolatedParts(node.parts);
        InterpolatedStringNode stringNode = new InterpolatedStringNode(children, this.sourceEncoding);
        StringToSymbolNode rubyNode = StringToSymbolNodeGen.create(stringNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitInterpolatedXStringNode(Nodes.InterpolatedXStringNode node) {
        Nodes.InterpolatedStringNode stringNode = new Nodes.InterpolatedStringNode(node.startOffset, node.length, 0, node.parts);
        RubyNode string = stringNode.accept(this);
        RubyContextSourceNode rubyNode = this.createCallNode(new SelfNode(), "`", string);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    private boolean isSourceEncodingOnly(Nodes.InterpolatedStringNode node) {
        for (Nodes.Node part : node.parts) {
            if (!(part instanceof Nodes.StringNode)) {
                return false;
            }
            Nodes.StringNode stringNode = (Nodes.StringNode)part;
            if (stringNode.isForcedBinaryEncoding() && this.sourceEncoding != Encodings.BINARY) {
                return false;
            }
            if (!stringNode.isForcedUtf8Encoding() || this.sourceEncoding == Encodings.UTF_8) continue;
            return false;
        }
        return true;
    }

    private static Nodes.StringNode concatStringNodes(Nodes.InterpolatedStringNode node) {
        Nodes.Node[] parts = node.parts;
        assert (parts.length > 0);
        int totalSize = 0;
        for (Nodes.Node part : parts) {
            totalSize += ((Nodes.StringNode)part).unescaped.length;
        }
        byte[] concatenated = new byte[totalSize];
        int i = 0;
        for (Nodes.Node part : parts) {
            byte[] bytes = ((Nodes.StringNode)part).unescaped;
            System.arraycopy(bytes, 0, concatenated, i, bytes.length);
            i += bytes.length;
        }
        int start = parts[0].startOffset;
        Nodes.Node last = ArrayUtils.getLast(parts);
        int length = last.endOffset() - start;
        short flags = node.isFrozen() ? (short)16 : 0;
        boolean isNewLineFlag = node.hasNewLineFlag();
        for (Nodes.Node part : parts) {
            if (!part.hasNewLineFlag()) continue;
            isNewLineFlag = true;
        }
        Nodes.StringNode stringNode = new Nodes.StringNode(start, length, flags, concatenated);
        stringNode.setNewLineFlag(isNewLineFlag);
        return stringNode;
    }

    private ToSNode[] translateInterpolatedParts(Nodes.Node[] parts) {
        ToSNode[] children = new ToSNode[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            RubyNode expression = parts[i].accept(this);
            children[i] = ToSNodeGen.create(expression);
        }
        return children;
    }

    private ToSNode[] translateInterpolatedPartsIgnoreForceEncodingFlags(Nodes.Node[] parts) {
        ToSNode[] children = new ToSNode[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            RubyNode expression;
            Nodes.Node node = parts[i];
            if (node instanceof Nodes.StringNode) {
                Nodes.StringNode stringNode = (Nodes.StringNode)node;
                short flags = stringNode.isFrozen() ? (short)16 : 0;
                Nodes.StringNode stringNodeNoForceEncoding = new Nodes.StringNode(stringNode.startOffset, stringNode.length, flags, stringNode.unescaped);
                this.copyNewLineFlag(stringNode, stringNodeNoForceEncoding);
                expression = stringNodeNoForceEncoding.accept(this);
            } else {
                expression = parts[i].accept(this);
            }
            children[i] = ToSNodeGen.create(expression);
        }
        return children;
    }

    @Override
    public RubyNode visitItLocalVariableReadNode(Nodes.ItLocalVariableReadNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"ItLocalVariableReadNode is only from Ruby 3.4");
    }

    @Override
    public RubyNode visitItParametersNode(Nodes.ItParametersNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"ItParametersNode is only from Ruby 3.4");
    }

    @Override
    public RubyNode visitKeywordHashNode(Nodes.KeywordHashNode node) {
        Nodes.HashNode hash = new Nodes.HashNode(node.startOffset, node.length, node.elements);
        return hash.accept(this);
    }

    @Override
    public RubyNode visitKeywordRestParameterNode(Nodes.KeywordRestParameterNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPLoadArgumentsTranslator");
    }

    @Override
    public RubyNode visitLambdaNode(Nodes.LambdaNode node) {
        return this.translateBlockAndLambda(node, node.parameters, node.body, node.locals, null);
    }

    @Override
    public RubyNode visitLocalVariableReadNode(Nodes.LocalVariableReadNode node) {
        String name = node.name;
        ReadLocalNode rubyNode = this.environment.findLocalVarNode(name);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitLocalVariableAndWriteNode(Nodes.LocalVariableAndWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        RubyNode writeNode = new Nodes.LocalVariableWriteNode(startOffset, length, node.name, node.depth, node.value).accept(this);
        RubyNode readNode = new Nodes.LocalVariableReadNode(startOffset, length, node.name, node.depth).accept(this);
        AndNode andNode = AndNodeGen.create(readNode, writeNode);
        DefinedWrapperNode rubyNode = new DefinedWrapperNode(this.language.coreStrings.ASSIGNMENT, andNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitLocalVariableOperatorWriteNode(Nodes.LocalVariableOperatorWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        Nodes.LocalVariableReadNode readNode = new Nodes.LocalVariableReadNode(startOffset, length, node.name, node.depth);
        Nodes.LocalVariableWriteNode desugared = new Nodes.LocalVariableWriteNode(startOffset, length, node.name, node.depth, YARPTranslator.callNode((Nodes.Node)node, readNode, node.binary_operator, node.value));
        return desugared.accept(this);
    }

    @Override
    public RubyNode visitLocalVariableOrWriteNode(Nodes.LocalVariableOrWriteNode node) {
        int startOffset = node.startOffset;
        int length = node.length;
        RubyNode writeNode = new Nodes.LocalVariableWriteNode(startOffset, length, node.name, node.depth, node.value).accept(this);
        RubyNode readNode = new Nodes.LocalVariableReadNode(startOffset, length, node.name, node.depth).accept(this);
        OrLazyValueDefinedNode rubyNode = OrLazyValueDefinedNodeGen.create(readNode, writeNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public WriteLocalNode visitLocalVariableWriteNode(Nodes.LocalVariableWriteNode node) {
        String name = node.name;
        ReadLocalNode lhs = this.environment.findLocalVarNode(name);
        RubyNode rhs = node.value.accept(this);
        WriteLocalNode rubyNode = lhs.makeWriteNode(rhs);
        this.assignPositionAndFlags(node, rubyNode);
        return rubyNode;
    }

    @Override
    public WriteLocalNode visitLocalVariableTargetNode(Nodes.LocalVariableTargetNode node) {
        String name = node.name;
        ReadLocalNode lhs = this.environment.findLocalVarNode(name);
        WriteLocalNode rubyNode = lhs.makeWriteNode(null);
        this.assignPositionAndFlags(node, rubyNode);
        return rubyNode;
    }

    @Override
    public RubyNode visitMatchLastLineNode(Nodes.MatchLastLineNode node) {
        Nodes.RegularExpressionNode regexp = new Nodes.RegularExpressionNode(node.startOffset, node.length, node.flags, node.unescaped);
        RubyNode regexpNode = regexp.accept(this);
        ReadGlobalVariableNode lastLineNode = ReadGlobalVariableNodeGen.create("$_");
        RubyContextSourceNode rubyNode = this.createCallNode(false, regexpNode, "=~", lastLineNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitMatchPredicateNode(Nodes.MatchPredicateNode node) {
        YARPPatternMatchingTranslator translator = new YARPPatternMatchingTranslator(this.environment, this);
        int tempSlot = this.environment.declareLocalTemp("value_of_=>");
        ReadLocalVariableNode readTemp = this.environment.readNode(tempSlot, node);
        WriteLocalNode assignTemp = ((ReadLocalNode)readTemp).makeWriteNode(node.value.accept(this));
        RubyNode condition = translator.translatePatternNode(node.pattern, readTemp);
        RubyNode ret = YARPTranslator.sequence(assignTemp, condition);
        return this.assignPositionAndFlags(node, ret);
    }

    @Override
    public RubyNode visitMatchRequiredNode(Nodes.MatchRequiredNode node) {
        YARPPatternMatchingTranslator translator = new YARPPatternMatchingTranslator(this.environment, this);
        int tempSlot = this.environment.declareLocalTemp("value_of_=>");
        ReadLocalVariableNode readTemp = this.environment.readNode(tempSlot, node);
        WriteLocalNode assignTemp = ((ReadLocalNode)readTemp).makeWriteNode(node.value.accept(this));
        RubyNode condition = translator.translatePatternNode(node.pattern, readTemp);
        UnlessNode check = UnlessNodeGen.create(condition, NoMatchingPatternNodeGen.create((RubyNode)NodeUtil.cloneNode((Node)readTemp)));
        RubyNode ret = YARPTranslator.sequence(assignTemp, check);
        return this.assignPositionAndFlags(node, ret);
    }

    @Override
    public RubyNode visitMatchWriteNode(Nodes.MatchWriteNode node) {
        assert (node.call.receiver instanceof Nodes.RegularExpressionNode);
        assert (node.call.name.equals("=~"));
        assert (node.call.arguments != null);
        assert (node.call.arguments.arguments.length == 1);
        assert (node.targets.length > 0);
        RubyNode matchNode = node.call.accept(this);
        int numberOfNames = node.targets.length;
        String[] names = new String[numberOfNames];
        for (int i = 0; i < numberOfNames; ++i) {
            names[i] = node.targets[i].name;
        }
        RubyNode[] setters = new RubyNode[numberOfNames];
        RubyNode[] nilSetters = new RubyNode[numberOfNames];
        int tempSlot = this.environment.declareLocalTemp("match_data");
        for (int i = 0; i < numberOfNames; ++i) {
            String name = names[i];
            TranslatorEnvironment environmentToDeclareIn = this.environment;
            while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                environmentToDeclareIn = environmentToDeclareIn.getParent();
            }
            environmentToDeclareIn.declareVar(name);
            nilSetters[i] = this.match2NilSetter(name);
            setters[i] = this.match2NonNilSetter(name, tempSlot);
        }
        ReadGlobalVariableNode readNode = ReadGlobalVariableNodeGen.create("$~");
        ReadLocalVariableNode tempVarReadNode = this.environment.readNode(tempSlot);
        WriteLocalNode readMatchDataNode = ((ReadLocalNode)tempVarReadNode).makeWriteNode(readNode);
        ReadMatchReferenceNodes.SetNamedVariablesMatchNode rubyNode = new ReadMatchReferenceNodes.SetNamedVariablesMatchNode(matchNode, readMatchDataNode, setters, nilSetters);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    private RubyNode match2NilSetter(String name) {
        return this.environment.findLocalVarNode(name).makeWriteNode(new NilLiteralNode());
    }

    private RubyNode match2NonNilSetter(String name, int tempSlot) {
        ReadLocalNode varNode = this.environment.findLocalVarNode(name);
        ReadLocalVariableNode tempVarNode = this.environment.readNode(tempSlot);
        MatchDataNodes.GetFixedNameMatchNode getIndexNode = new MatchDataNodes.GetFixedNameMatchNode(tempVarNode, this.language.getSymbol(name));
        return varNode.makeWriteNode(getIndexNode);
    }

    @Override
    public RubyNode visitMissingNode(Nodes.MissingNode node) {
        throw this.fail(node);
    }

    @Override
    public RubyNode visitModuleNode(Nodes.ModuleNode node) {
        RubyNode lexicalParent = this.getParentLexicalScopeForConstant(node.constant_path);
        DefineModuleNode defineModuleNode = DefineModuleNodeGen.create(node.name, lexicalParent);
        YARPTranslator.assignPositionOnly(node, defineModuleNode);
        RubyNode rubyNode = this.openModule(node, defineModuleNode, node.name, node.locals, node.body, OpenModule.MODULE, this.shouldUseDynamicConstantLookupForModuleBody(node));
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitMultiWriteNode(Nodes.MultiWriteNode node) {
        YARPMultiWriteNodeTranslator translator = new YARPMultiWriteNodeTranslator(node, this.language, this);
        RubyNode rubyNode = translator.translate();
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitMultiTargetNode(Nodes.MultiTargetNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in visitForNode and other places");
    }

    @Override
    public RubyNode visitNextNode(Nodes.NextNode node) {
        if (!this.environment.isBlock() && !this.translatingWhile) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("Invalid next", this.currentNode, this.getSourceSection(node)));
        }
        RubyNode argumentsNode = this.translateControlFlowArguments(node.arguments);
        NextNode rubyNode = new NextNode(argumentsNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitNilNode(Nodes.NilNode node) {
        NilLiteralNode rubyNode = new NilLiteralNode();
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitNoKeywordsParameterNode(Nodes.NoKeywordsParameterNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPLoadArgumentsTranslator");
    }

    @Override
    public RubyNode visitNumberedParametersNode(Nodes.NumberedParametersNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in translateBlockAndLambda");
    }

    @Override
    public RubyNode visitNumberedReferenceReadNode(Nodes.NumberedReferenceReadNode node) {
        if (node.number == 0) {
            NilLiteralNode rubyNode = new NilLiteralNode();
            return this.assignPositionAndFlags(node, rubyNode);
        }
        ReadGlobalVariableNode lastMatchNode = ReadGlobalVariableNodeGen.create("$~");
        ReadMatchReferenceNodes.ReadNthMatchNode rubyNode = new ReadMatchReferenceNodes.ReadNthMatchNode(lastMatchNode, node.number);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitOptionalKeywordParameterNode(Nodes.OptionalKeywordParameterNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPLoadArgumentsTranslator");
    }

    @Override
    public RubyNode visitOptionalParameterNode(Nodes.OptionalParameterNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPLoadArgumentsTranslator");
    }

    @Override
    public RubyNode visitOrNode(Nodes.OrNode node) {
        RubyNode left = node.left.accept(this);
        RubyNode right = node.right.accept(this);
        OrNode rubyNode = OrNodeGen.create(left, right);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitParametersNode(Nodes.ParametersNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPLoadArgumentsTranslator");
    }

    @Override
    public RubyNode visitParenthesesNode(Nodes.ParenthesesNode node) {
        if (node.body == null) {
            NilLiteralNode rubyNode = new NilLiteralNode();
            return this.assignPositionAndFlags(node, rubyNode);
        }
        return node.body.accept(this);
    }

    @Override
    public RubyNode visitPinnedExpressionNode(Nodes.PinnedExpressionNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPPatternMatchingTranslator");
    }

    @Override
    public RubyNode visitPinnedVariableNode(Nodes.PinnedVariableNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPPatternMatchingTranslator");
    }

    @Override
    public RubyNode visitPostExecutionNode(Nodes.PostExecutionNode node) {
        Nodes.ConstantPathNode receiver = new Nodes.ConstantPathNode(0, 0, new Nodes.ConstantReadNode(0, 0, "Truffle"), "KernelOperations");
        Nodes.ArgumentsNode arguments = new Nodes.ArgumentsNode(0, 0, 0, new Nodes.Node[]{new Nodes.FalseNode(0, 0)});
        Nodes.BlockNode block = new Nodes.BlockNode(0, 0, StringUtils.EMPTY_STRING_ARRAY, null, node.statements);
        RubyNode callNode = new Nodes.CallNode(0, 0, 0, receiver, "at_exit", arguments, block).accept(this);
        OnceNode rubyNode = new OnceNode(callNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitPreExecutionNode(Nodes.PreExecutionNode node) {
        RubyNode sequence = node.statements.accept(this);
        this.beginBlocks.add(sequence);
        return null;
    }

    @Override
    public RubyNode visitProgramNode(Nodes.ProgramNode node) {
        for (String name : node.locals) {
            this.environment.declareVar(name);
        }
        return node.statements.accept(this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public RubyNode visitRangeNode(Nodes.RangeNode node) {
        void var4_11;
        RubyNode left = this.translateNodeOrNil(node.left);
        RubyNode right = this.translateNodeOrNil(node.right);
        if (left instanceof IntegerFixnumLiteralNode) {
            IntegerFixnumLiteralNode l = (IntegerFixnumLiteralNode)left;
            if (right instanceof IntegerFixnumLiteralNode) {
                IntegerFixnumLiteralNode r = (IntegerFixnumLiteralNode)right;
                RubyIntRange range = new RubyIntRange(node.isExcludeEnd(), l.getValue(), r.getValue());
                ObjectLiteralNode objectLiteralNode = new ObjectLiteralNode(range);
                return this.assignPositionAndFlags(node, (RubyNode)var4_11);
            }
        }
        if (left instanceof LongFixnumLiteralNode) {
            LongFixnumLiteralNode l = (LongFixnumLiteralNode)left;
            if (right instanceof LongFixnumLiteralNode) {
                LongFixnumLiteralNode r = (LongFixnumLiteralNode)right;
                RubyLongRange range = new RubyLongRange(node.isExcludeEnd(), l.getValue(), r.getValue());
                ObjectLiteralNode objectLiteralNode = new ObjectLiteralNode(range);
                return this.assignPositionAndFlags(node, (RubyNode)var4_11);
            }
        }
        RangeNodes.RangeLiteralNode rangeLiteralNode = RangeNodesFactory.RangeLiteralNodeGen.create(left, right, node.isExcludeEnd());
        return this.assignPositionAndFlags(node, (RubyNode)var4_11);
    }

    @Override
    public RubyNode visitRationalNode(Nodes.RationalNode node) {
        ObjectClassLiteralNode objectClassNode = new ObjectClassLiteralNode();
        ReadConstantNode rationalModuleNode = new ReadConstantNode(objectClassNode, "Rational");
        RubyNode numeratorNode = this.translateNumericValue(node.numerator);
        RubyNode denominatorNode = this.translateNumericValue(node.denominator);
        RubyNode[] arguments = new RubyNode[]{numeratorNode, denominatorNode};
        RubyContextSourceNode rubyNode = this.createCallNode(rationalModuleNode, "convert", arguments);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitRedoNode(Nodes.RedoNode node) {
        if (!this.environment.isBlock() && !this.translatingWhile) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("Invalid redo", this.currentNode, this.getSourceSection(node)));
        }
        RedoNode rubyNode = new RedoNode();
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitRegularExpressionNode(Nodes.RegularExpressionNode node) {
        RubyRegexp regexp;
        RegexpEncodingAndOptions encodingAndOptions = this.getRegexpEncodingAndOptions(new Nodes.RegularExpressionFlags(node.flags));
        RubyEncoding encoding = encodingAndOptions.encoding;
        RegexpOptions options = encodingAndOptions.options;
        TruffleString source = TruffleString.fromByteArrayUncached((byte[])node.unescaped, (TruffleString.Encoding)encoding.tencoding, (boolean)false);
        TStringWithEncoding sourceWithEnc = new TStringWithEncoding(source, encoding);
        try {
            sourceWithEnc = ClassicRegexp.setRegexpEncoding(sourceWithEnc, options, this.sourceEncoding, this.currentNode);
            regexp = RubyRegexp.create(this.language, sourceWithEnc.tstring, sourceWithEnc.encoding, options, this.currentNode);
        }
        catch (DeferredRaiseException dre) {
            throw this.regexpErrorToSyntaxError(dre, node);
        }
        ObjectLiteralNode literalNode = new ObjectLiteralNode(regexp);
        return this.assignPositionAndFlags(node, literalNode);
    }

    private RegexpEncodingAndOptions getRegexpEncodingAndOptions(Nodes.RegularExpressionFlags flags) {
        RubyEncoding regexpEncoding;
        KCode kcode;
        boolean fixed;
        boolean explicitEncoding = true;
        if (flags.isAscii8bit()) {
            fixed = false;
            kcode = KCode.NONE;
            regexpEncoding = Encodings.BINARY;
        } else if (flags.isUtf8()) {
            fixed = true;
            kcode = KCode.UTF8;
            regexpEncoding = Encodings.UTF_8;
        } else if (flags.isEucJp()) {
            fixed = true;
            kcode = KCode.EUC;
            regexpEncoding = Encodings.getBuiltInEncoding((Encoding)EUCJPEncoding.INSTANCE);
        } else if (flags.isWindows31j()) {
            fixed = true;
            kcode = KCode.SJIS;
            regexpEncoding = Encodings.getBuiltInEncoding((Encoding)Windows_31JEncoding.INSTANCE);
        } else {
            fixed = false;
            kcode = KCode.NONE;
            regexpEncoding = this.sourceEncoding;
            explicitEncoding = false;
        }
        RegexpOptions options = new RegexpOptions(kcode, fixed, flags.isOnce(), flags.isExtended(), flags.isMultiLine(), flags.isIgnoreCase(), flags.isAscii8bit(), !explicitEncoding, true);
        return new RegexpEncodingAndOptions(regexpEncoding, options);
    }

    private RaiseException regexpErrorToSyntaxError(DeferredRaiseException dre, Nodes.Node node) {
        RubyContext context = RubyLanguage.getCurrentContext();
        RaiseException raiseException = dre.getException(context);
        if (raiseException.getException().getLogicalClass() == context.getCoreLibrary().regexpErrorClass) {
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError(raiseException.getMessage(), this.currentNode, this.getSourceSection(node)));
        }
        throw raiseException;
    }

    @Override
    public RubyNode visitRequiredKeywordParameterNode(Nodes.RequiredKeywordParameterNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPLoadArgumentsTranslator");
    }

    @Override
    public RubyNode visitRequiredParameterNode(Nodes.RequiredParameterNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPLoadArgumentsTranslator");
    }

    @Override
    public RubyNode visitRescueModifierNode(Nodes.RescueModifierNode node) {
        RubyNode tryNode = node.expression.accept(this);
        RubyNode rescueExpressionNode = node.rescue_expression.accept(this);
        boolean canOmitBacktrace = this.language.options.BACKTRACES_OMIT_UNUSED && this.isSideEffectFreeRescueExpression(node.rescue_expression);
        RescueStandardErrorNode rescueNode = new RescueStandardErrorNode(rescueExpressionNode, canOmitBacktrace);
        TryNode rubyNode = TryNodeGen.create(tryNode, new RescueNode[]{rescueNode}, null);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitRescueNode(Nodes.RescueNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in visitBeginNode");
    }

    @Override
    public RubyNode visitRestParameterNode(Nodes.RestParameterNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in YARPLoadArgumentsTranslator");
    }

    @Override
    public RubyNode visitRetryNode(Nodes.RetryNode node) {
        RetryNode rubyNode = new RetryNode();
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitReturnNode(Nodes.ReturnNode node) {
        ReturnID returnID;
        RubyNode argumentsNode = this.translateControlFlowArguments(node.arguments);
        RubyContextSourceNode rubyNode = this.environment.isBlock() ? ((returnID = this.environment.getReturnID()) == ReturnID.MODULE_BODY ? new InvalidReturnNode(argumentsNode) : new DynamicReturnNode(returnID, argumentsNode)) : new LocalReturnNode(argumentsNode);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitSelfNode(Nodes.SelfNode node) {
        SelfNode rubyNode = new SelfNode();
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitSingletonClassNode(Nodes.SingletonClassNode node) {
        RubyNode receiverNode = node.expression.accept(this);
        SingletonClassNode.SingletonClassASTNode singletonClassNode = SingletonClassNodeGen.SingletonClassASTNodeGen.create(receiverNode);
        YARPTranslator.assignPositionOnly(node, singletonClassNode);
        boolean dynamicConstantLookup = this.environment.isDynamicConstantLookup();
        String modulePath = "<singleton class>";
        if (!dynamicConstantLookup) {
            if (this.environment.isModuleBody() && node.expression instanceof Nodes.SelfNode) {
                modulePath = this.environment.isTopLevelObjectScope() ? "main::<singleton class>" : TranslatorEnvironment.composeModulePath(this.environment.modulePath, "<singleton class>");
            } else if (!this.environment.isTopLevelScope()) {
                dynamicConstantLookup = true;
                if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                    RubyLanguage.LOGGER.info(() -> "start dynamic constant lookup at " + RubyLanguage.getCurrentContext().fileLine(this.getSourceSection(node)));
                }
            }
        }
        RubyNode rubyNode = this.openModule(node, singletonClassNode, modulePath, node.locals, node.body, OpenModule.SINGLETON_CLASS, dynamicConstantLookup);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitSourceEncodingNode(Nodes.SourceEncodingNode node) {
        ObjectLiteralNode rubyNode = new ObjectLiteralNode(this.sourceEncoding);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitSourceFileNode(Nodes.SourceFileNode node) {
        RubyEncoding encoding = Encodings.FILESYSTEM;
        TruffleString path = TruffleString.fromByteArrayUncached((byte[])node.filepath, (TruffleString.Encoding)encoding.tencoding);
        StringLiteralNode rubyNode = new StringLiteralNode(path, encoding);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitSourceLineNode(Nodes.SourceLineNode node) {
        int line = this.parseEnvironment.yarpSource.line(node.startOffset);
        IntegerFixnumLiteralNode rubyNode = new IntegerFixnumLiteralNode(line);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitSplatNode(Nodes.SplatNode node) {
        RubyContextSourceNode rubyNode;
        if (node.expression != null) {
            RubyNode valueNode = node.expression.accept(this);
            rubyNode = SplatCastNodeGen.create(this.language, SplatCastNode.NilBehavior.CONVERT, false, valueNode);
        } else {
            rubyNode = this.environment.findLocalVarNode("%unnamed_rest");
        }
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitStatementsNode(Nodes.StatementsNode node) {
        RubyNode[] rubyNodes = this.translate(node.body);
        return YARPTranslator.sequence(node, rubyNodes);
    }

    @Override
    public RubyNode visitShareableConstantNode(Nodes.ShareableConstantNode node) {
        return node.write.accept(this);
    }

    @Override
    public RubyNode visitStringNode(Nodes.StringNode node) {
        RubyContextSourceNode rubyNode;
        RubyEncoding encoding = node.isForcedUtf8Encoding() ? Encodings.UTF_8 : (node.isForcedBinaryEncoding() ? Encodings.BINARY : this.sourceEncoding);
        byte[] bytes = node.unescaped;
        if (!node.isFrozen()) {
            TruffleString cachedTString = this.language.tstringCache.getTString(bytes, encoding);
            rubyNode = new StringLiteralNode(cachedTString, encoding);
        } else {
            ImmutableRubyString frozenString = this.language.frozenStringLiterals.getFrozenStringLiteral(bytes, encoding);
            rubyNode = new FrozenStringLiteralNode(frozenString, FrozenStrings.EXPRESSION);
        }
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitSuperNode(Nodes.SuperNode node) {
        ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(node.arguments, node.block, this.environment.getMethodName());
        ReadSuperArgumentsNode arguments = new ReadSuperArgumentsNode(argumentsAndBlock.arguments, argumentsAndBlock.isSplatted);
        RubyNode block = this.explicitOrInheritedBlock(argumentsAndBlock.block);
        RubyNode callNode = new SuperCallNode(argumentsAndBlock.isSplatted, arguments, block, argumentsAndBlock.argumentsDescriptor);
        callNode = YARPTranslator.wrapCallWithLiteralBlock(argumentsAndBlock, callNode);
        return this.assignPositionAndFlags(node, callNode);
    }

    private RubyNode explicitOrInheritedBlock(RubyNode blockNode) {
        if (blockNode != null) {
            return blockNode;
        }
        return this.environment.findLocalVarOrNilNode("%method_block_arg");
    }

    @Override
    public RubyNode visitSymbolNode(Nodes.SymbolNode node) {
        RubySymbol symbol = this.translateSymbol(node);
        ObjectLiteralNode rubyNode = new ObjectLiteralNode(symbol);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    public RubySymbol translateSymbol(Nodes.SymbolNode node) {
        RubyEncoding encoding = node.isForcedUtf8Encoding() ? Encodings.UTF_8 : (node.isForcedUsAsciiEncoding() ? Encodings.US_ASCII : (node.isForcedBinaryEncoding() ? Encodings.BINARY : this.sourceEncoding));
        TruffleString tstring = TStringUtils.fromByteArray(node.unescaped, encoding);
        return this.language.getSymbol((AbstractTruffleString)tstring, encoding);
    }

    @Override
    public RubyNode visitTrueNode(Nodes.TrueNode node) {
        BooleanLiteralNode rubyNode = new BooleanLiteralNode(true);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitUndefNode(Nodes.UndefNode node) {
        RubyNode[] names = this.translate(node.names);
        ModuleNodes.UndefNode rubyNode = new ModuleNodes.UndefNode(names);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitUnlessNode(Nodes.UnlessNode node) {
        RubyNode elseNode;
        RubyNode conditionNode = node.predicate.accept(this);
        RubyNode thenNode = node.statements == null ? null : node.statements.accept(this);
        RubyNode rubyNode = elseNode = node.else_clause == null ? null : node.else_clause.accept(this);
        if (thenNode != null && elseNode != null) {
            IfElseNode rubyNode2 = IfElseNodeGen.create(conditionNode, elseNode, thenNode);
            return this.assignPositionAndFlags(node, rubyNode2);
        }
        if (thenNode != null) {
            UnlessNode rubyNode3 = UnlessNodeGen.create(conditionNode, thenNode);
            return this.assignPositionAndFlags(node, rubyNode3);
        }
        if (elseNode != null) {
            IfNode rubyNode4 = IfNodeGen.create(conditionNode, elseNode);
            return this.assignPositionAndFlags(node, rubyNode4);
        }
        RubyNode rubyNode5 = YARPTranslator.sequence(node, conditionNode, new NilLiteralNode());
        return rubyNode5;
    }

    @Override
    public RubyNode visitUntilNode(Nodes.UntilNode node) {
        RubyNode rubyNode = this.translateWhileNode(node, node.predicate, node.statements, true, !node.isBeginModifier());
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitWhenNode(Nodes.WhenNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in visitCaseNode");
    }

    @Override
    public RubyNode visitWhileNode(Nodes.WhileNode node) {
        RubyNode rubyNode = this.translateWhileNode(node, node.predicate, node.statements, false, !node.isBeginModifier());
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitXStringNode(Nodes.XStringNode node) {
        int flags = 16;
        if (node.isForcedBinaryEncoding()) {
            flags |= 8;
        }
        if (node.isForcedUtf8Encoding()) {
            flags |= 4;
        }
        Nodes.StringNode stringNode = new Nodes.StringNode(node.startOffset, node.length, (short)flags, node.unescaped);
        RubyNode string = stringNode.accept(this);
        RubyContextSourceNode rubyNode = this.createCallNode(new SelfNode(), "`", string);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    @Override
    public RubyNode visitYieldNode(Nodes.YieldNode node) {
        if (this.isInvalidYield()) {
            RubyContext context = RubyLanguage.getCurrentContext();
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("Invalid yield", this.currentNode, this.getSourceSection(node)));
        }
        ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(node.arguments, null, "<yield>");
        RubyNode readBlock = this.environment.findLocalVarOrNilNode("%method_block_arg");
        YieldExpressionNode rubyNode = new YieldExpressionNode(argumentsAndBlock.isSplatted, argumentsAndBlock.argumentsDescriptor, argumentsAndBlock.arguments, readBlock);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    protected FindDeclarationVariableNodes.FrameSlotAndDepth createFlipFlopState() {
        TranslatorEnvironment target = this.environment.getSurroundingMethodOrEvalEnvironment();
        int frameSlot = target.declareLocalTemp("flipflop");
        target.getFlipFlopStates().add(frameSlot);
        int depth = this.environment.getBlockDepth() - target.getBlockDepth();
        return new FindDeclarationVariableNodes.FrameSlotAndDepth(frameSlot, depth);
    }

    private RubyNode translateExpressionsList(Nodes.Node[] nodes) {
        assert (nodes != null);
        if (nodes.length == 0) {
            return ArrayLiteralNode.create(this.language, RubyNode.EMPTY_ARRAY);
        }
        boolean containSplatOperator = this.containYARPSplatNode(nodes);
        if (!containSplatOperator) {
            RubyNode[] rubyNodes = this.translate(nodes);
            return ArrayLiteralNode.create(this.language, rubyNodes);
        }
        ArrayList<RubyNode> arraysToConcat = new ArrayList<RubyNode>();
        ArrayList<RubyNode> current = new ArrayList<RubyNode>();
        for (Nodes.Node node : nodes) {
            if (node instanceof Nodes.SplatNode) {
                if (!current.isEmpty()) {
                    arraysToConcat.add(ArrayLiteralNode.create(this.language, current.toArray(RubyNode.EMPTY_ARRAY)));
                    current = new ArrayList();
                }
                arraysToConcat.add(node.accept(this));
                continue;
            }
            current.add(node.accept(this));
        }
        if (!current.isEmpty()) {
            arraysToConcat.add(ArrayLiteralNode.create(this.language, current.toArray(RubyNode.EMPTY_ARRAY)));
        }
        RubyNode rubyNode = arraysToConcat.size() == 1 ? (RubyNode)((Object)arraysToConcat.get(0)) : new ArrayConcatNode(arraysToConcat.toArray(RubyNode.EMPTY_ARRAY));
        return rubyNode;
    }

    private String modulePathAndMethodName(String methodName, boolean onSingleton, boolean isReceiverSelf) {
        String modulePath = this.environment.modulePath;
        if (modulePath == null) {
            if (onSingleton) {
                if (this.environment.isTopLevelObjectScope() && isReceiverSelf) {
                    modulePath = "main";
                } else {
                    modulePath = "<singleton class>";
                    onSingleton = false;
                }
            } else {
                modulePath = this.environment.isTopLevelObjectScope() ? "Object" : "";
            }
        }
        if (modulePath.endsWith("::<singleton class>") && !onSingleton) {
            modulePath = modulePath.substring(0, modulePath.length() - "::<singleton class>".length());
            onSingleton = true;
        }
        return SharedMethodInfo.modulePathAndMethodName(modulePath, methodName, onSingleton);
    }

    private RubyNode getLexicalScopeNode(String kind, Nodes.Node yarpNode) {
        if (this.environment.isDynamicConstantLookup()) {
            if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                RubyLanguage.LOGGER.info(() -> kind + " at " + RubyLanguage.getCurrentContext().fileLine(this.getSourceSection(yarpNode)));
            }
            return new GetDynamicLexicalScopeNode();
        }
        return new ObjectLiteralNode(this.environment.getStaticLexicalScope());
    }

    private RubyNode openModule(Nodes.Node moduleNode, RubyNode defineOrGetNode, String moduleName, String[] locals, Nodes.Node bodyNode, OpenModule type, boolean dynamicConstantLookup) {
        String methodName = type.format(moduleName);
        LexicalScope newLexicalScope = dynamicConstantLookup ? null : new LexicalScope(this.environment.getStaticLexicalScope());
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(this.getSourceSection(moduleNode), newLexicalScope, Arity.NO_ARGUMENTS, methodName, 0, methodName, null, null);
        String modulePath = type == OpenModule.SINGLETON_CLASS ? moduleName : TranslatorEnvironment.composeModulePath(this.environment.modulePath, moduleName);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.environment, this.parseEnvironment, ReturnID.MODULE_BODY, true, true, sharedMethodInfo, methodName, 0, null, null, modulePath);
        for (String name : locals) {
            newEnvironment.declareVar(name);
        }
        YARPTranslator moduleTranslator = new YARPTranslator(newEnvironment, this.rubyWarnings);
        ModuleBodyDefinition definition = moduleTranslator.compileClassNode(moduleNode, bodyNode);
        return new RunModuleDefinitionNode(definition, defineOrGetNode);
    }

    private ModuleBodyDefinition compileClassNode(Nodes.Node moduleNode, Nodes.Node bodyNode) {
        RubyNode body = this.translateNodeOrNil(bodyNode);
        body = new InsideModuleDefinitionNode(body);
        YARPTranslator.assignPositionOnly(moduleNode, body);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = YARPTranslator.sequence(YARPTranslator.initFlipFlopStates(this.environment), body);
        }
        RubyNode writeSelfNode = YARPTranslator.loadSelf(this.language);
        body = YARPTranslator.sequence(writeSelfNode, body);
        RubyRootNode rootNode = new RubyRootNode(this.language, this.getSourceSection(moduleNode), this.environment.computeFrameDescriptor(), this.environment.getSharedMethodInfo(), body, Split.NEVER, this.environment.getReturnID());
        return new ModuleBodyDefinition(this.environment.getSharedMethodInfo().getOriginalName(), this.environment.getSharedMethodInfo(), rootNode.getCallTarget(), this.environment.getStaticLexicalScopeOrNull());
    }

    private RubyNode getParentLexicalScopeForConstant(Nodes.Node node) {
        RubyNode rubyNode;
        if (node instanceof Nodes.ConstantReadNode) {
            rubyNode = this.getLexicalScopeModuleNode("dynamic constant lookup", node);
        } else if (node instanceof Nodes.ConstantPathNode) {
            Nodes.ConstantPathNode pathNode = (Nodes.ConstantPathNode)node;
            rubyNode = pathNode.parent != null ? pathNode.parent.accept(this) : new ObjectClassLiteralNode();
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        return rubyNode;
    }

    private RubyNode getLexicalScopeModuleNode(String kind, Nodes.Node node) {
        if (this.environment.isDynamicConstantLookup()) {
            if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
                RubyLanguage.LOGGER.info(() -> kind + " at " + RubyLanguage.getCurrentContext().fileLine(this.getSourceSection(node)));
            }
            return new DynamicLexicalScopeNode();
        }
        return new LexicalScopeNode(this.environment.getStaticLexicalScope());
    }

    protected static RubyNode initFlipFlopStates(TranslatorEnvironment environment) {
        RubyNode[] initNodes = YARPTranslator.createArray(environment.getFlipFlopStates().size());
        for (int n = 0; n < initNodes.length; ++n) {
            initNodes[n] = new InitFlipFlopSlotNode(environment.getFlipFlopStates().get(n));
        }
        return YARPTranslator.sequence(initNodes);
    }

    public static RubyNode loadSelf(RubyLanguage language) {
        return new WriteLocalVariableNode(0, YARPTranslator.profileArgument(language, new ReadSelfNode()));
    }

    public static RubyNode profileArgument(RubyLanguage language, RubyNode argumentNode) {
        RubyNode node = argumentNode;
        if (language.options.PROFILE_ARGUMENTS) {
            node = ProfileArgumentNodeGen.create(node);
        }
        if (language.options.CHAOS_DATA) {
            node = ChaosNode.create(node);
        }
        return node;
    }

    private boolean shouldUseDynamicConstantLookupForModuleBody(Nodes.Node node) {
        if (this.environment.isDynamicConstantLookup()) {
            return true;
        }
        if (this.environment.isModuleBody()) {
            return false;
        }
        if (this.environment.isTopLevelScope()) {
            return false;
        }
        if (this.language.options.LOG_DYNAMIC_CONSTANT_LOOKUP) {
            RubyLanguage.LOGGER.info(() -> "start dynamic constant lookup at " + RubyLanguage.getCurrentContext().fileLine(this.getSourceSection(node)));
        }
        return true;
    }

    private boolean isInvalidYield() {
        return this.environment.getSurroundingMethodEnvironment().isModuleBody();
    }

    private RubyNode translateControlFlowArguments(Nodes.ArgumentsNode node) {
        if (node == null) {
            return new NilLiteralNode();
        }
        Nodes.Node[] values = node.arguments;
        if (values.length == 1) {
            return values[0].accept(this);
        }
        RubyNode rubyNode = this.translateExpressionsList(values);
        return this.assignPositionAndFlags(node, rubyNode);
    }

    private RubyNode translateRescueException(Nodes.Node target) {
        RubyNode rubyNode = target.accept(this);
        AssignableNode assignableNode = (AssignableNode)((Object)rubyNode);
        return new AssignRescueVariableNode(assignableNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateWhileNode(Nodes.Node node, Nodes.Node predicate, Nodes.StatementsNode statements, boolean conditionInversed, boolean evaluateConditionBeforeBody) {
        RubyNode body;
        RubyNode condition = predicate.accept(this);
        if (conditionInversed) {
            condition = NotNodeGen.create(condition);
        }
        BreakID whileBreakID = this.parseEnvironment.allocateBreakID();
        boolean oldTranslatingWhile = this.translatingWhile;
        this.translatingWhile = true;
        BreakID oldBreakID = this.environment.getBreakID();
        this.environment.setBreakIDForWhile(whileBreakID);
        this.frameOnStackMarkerSlotStack.push(-1);
        try {
            body = this.translateNodeOrNil(statements);
        }
        finally {
            this.frameOnStackMarkerSlotStack.pop();
            this.environment.setBreakIDForWhile(oldBreakID);
            this.translatingWhile = oldTranslatingWhile;
        }
        WhileNode loop = evaluateConditionBeforeBody ? new WhileNode(WhileNodeFactory.WhileRepeatingNodeGen.create(condition, body)) : new WhileNode(WhileNodeFactory.DoWhileRepeatingNodeGen.create(condition, body));
        CatchBreakNode rubyNode = new CatchBreakNode(whileBreakID, loop, true);
        return rubyNode;
    }

    protected boolean isSideEffectFreeRescueExpression(Nodes.Node node) {
        return node instanceof Nodes.InstanceVariableReadNode || node instanceof Nodes.LocalVariableReadNode || node instanceof Nodes.ClassVariableReadNode || node instanceof Nodes.SourceFileNode || node instanceof Nodes.StringNode || node instanceof Nodes.SymbolNode || node instanceof Nodes.IntegerNode || node instanceof Nodes.FloatNode || node instanceof Nodes.ImaginaryNode || node instanceof Nodes.RationalNode || node instanceof Nodes.SelfNode || node instanceof Nodes.TrueNode || node instanceof Nodes.FalseNode || node instanceof Nodes.NilNode;
    }

    private boolean containYARPSplatNode(Nodes.Node[] nodes) {
        for (Nodes.Node n : nodes) {
            if (!(n instanceof Nodes.SplatNode)) continue;
            return true;
        }
        return false;
    }

    private ArgumentDescriptor[] parametersNodeToArgumentDescriptors(Nodes.ParametersNode parametersNode) {
        ArgumentDescriptor descriptor;
        ArgumentDescriptor descriptor2;
        String name;
        if (parametersNode == ZERO_PARAMETERS_NODE) {
            return ArgumentDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ArgumentDescriptor> descriptors = new ArrayList<ArgumentDescriptor>();
        for (Nodes.Node node2 : parametersNode.requireds) {
            if (node2 instanceof Nodes.MultiTargetNode) {
                descriptors.add(new ArgumentDescriptor(ArgumentType.anonreq));
                continue;
            }
            name = ((Nodes.RequiredParameterNode)node2).name;
            descriptor2 = new ArgumentDescriptor(ArgumentType.req, name);
            descriptors.add(descriptor2);
        }
        Nodes.Node[] nodeArray = parametersNode.optionals;
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            Nodes.Node node2;
            node2 = nodeArray[i];
            descriptor = new ArgumentDescriptor(ArgumentType.opt, ((Nodes.OptionalParameterNode)node2).name);
            descriptors.add(descriptor);
        }
        Nodes.Node node = parametersNode.rest;
        if (node instanceof Nodes.RestParameterNode) {
            Nodes.Node[] restParameterNode = (Nodes.Node[])node;
            if (restParameterNode.name == null) {
                descriptors.add(new ArgumentDescriptor(ArgumentType.anonrest));
            } else {
                ArgumentDescriptor descriptor3 = new ArgumentDescriptor(ArgumentType.rest, restParameterNode.name);
                descriptors.add(descriptor3);
            }
        }
        for (Nodes.Node node2 : parametersNode.posts) {
            if (node2 instanceof Nodes.MultiTargetNode) {
                descriptors.add(new ArgumentDescriptor(ArgumentType.anonreq));
                continue;
            }
            name = ((Nodes.RequiredParameterNode)node2).name;
            descriptor2 = new ArgumentDescriptor(ArgumentType.req, name);
            descriptors.add(descriptor2);
        }
        for (Nodes.Node node2 : parametersNode.keywords) {
            if (node2 instanceof Nodes.RequiredKeywordParameterNode) {
                Nodes.RequiredKeywordParameterNode required = (Nodes.RequiredKeywordParameterNode)node2;
                descriptor = new ArgumentDescriptor(ArgumentType.keyreq, required.name);
            } else if (node2 instanceof Nodes.OptionalKeywordParameterNode) {
                Nodes.OptionalKeywordParameterNode optional = (Nodes.OptionalKeywordParameterNode)node2;
                descriptor = new ArgumentDescriptor(ArgumentType.key, optional.name);
            } else {
                throw CompilerDirectives.shouldNotReachHere();
            }
            descriptors.add(descriptor);
        }
        if (parametersNode.keyword_rest != null) {
            if (parametersNode.keyword_rest instanceof Nodes.KeywordRestParameterNode) {
                Nodes.KeywordRestParameterNode keywordRestParameterNode = (Nodes.KeywordRestParameterNode)parametersNode.keyword_rest;
                if (keywordRestParameterNode.name == null) {
                    descriptors.add(new ArgumentDescriptor(ArgumentType.anonkeyrest, "%kwrest"));
                } else {
                    descriptors.add(new ArgumentDescriptor(ArgumentType.keyrest, keywordRestParameterNode.name));
                }
            } else if (parametersNode.keyword_rest instanceof Nodes.ForwardingParameterNode) {
                descriptors.add(new ArgumentDescriptor(ArgumentType.rest, "%forward_rest"));
                descriptors.add(new ArgumentDescriptor(ArgumentType.keyrest, "%forward_kwrest"));
                descriptors.add(new ArgumentDescriptor(ArgumentType.block, "%forward_block"));
            } else if (parametersNode.keyword_rest instanceof Nodes.NoKeywordsParameterNode) {
                ArgumentDescriptor descriptor4 = new ArgumentDescriptor(ArgumentType.nokey);
                descriptors.add(descriptor4);
            } else {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        if (parametersNode.block != null) {
            String name2 = parametersNode.block.name == null ? "%forward_block" : parametersNode.block.name;
            descriptors.add(new ArgumentDescriptor(ArgumentType.block, name2));
        }
        return descriptors.toArray(ArgumentDescriptor.EMPTY_ARRAY);
    }

    private Arity createArity(Nodes.ParametersNode parametersNode) {
        int requiredKeywordArgumentsCount;
        String[] keywordArguments;
        if (parametersNode == ZERO_PARAMETERS_NODE) {
            return new Arity(0, 0, false);
        }
        if (parametersNode.keywords.length > 0) {
            ArrayList<String> requiredKeywords = new ArrayList<String>();
            ArrayList<String> optionalKeywords = new ArrayList<String>();
            for (Nodes.Node node : parametersNode.keywords) {
                if (node instanceof Nodes.RequiredKeywordParameterNode) {
                    Nodes.RequiredKeywordParameterNode required = (Nodes.RequiredKeywordParameterNode)node;
                    requiredKeywords.add(required.name);
                    continue;
                }
                if (node instanceof Nodes.OptionalKeywordParameterNode) {
                    Nodes.OptionalKeywordParameterNode optional = (Nodes.OptionalKeywordParameterNode)node;
                    optionalKeywords.add(optional.name);
                    continue;
                }
                throw CompilerDirectives.shouldNotReachHere();
            }
            ArrayList<String> keywords = new ArrayList<String>(requiredKeywords);
            keywords.addAll(optionalKeywords);
            keywordArguments = keywords.toArray(StringUtils.EMPTY_STRING_ARRAY);
            requiredKeywordArgumentsCount = requiredKeywords.size();
        } else {
            keywordArguments = Arity.NO_KEYWORDS;
            requiredKeywordArgumentsCount = 0;
        }
        boolean hasRest = parametersNode.keyword_rest instanceof Nodes.ForwardingParameterNode ? true : parametersNode.rest != null;
        boolean isImplicitRest = parametersNode.rest instanceof Nodes.ImplicitRestNode;
        return new Arity(parametersNode.requireds.length, parametersNode.optionals.length, hasRest, isImplicitRest, parametersNode.posts.length, keywordArguments, requiredKeywordArgumentsCount, parametersNode.keyword_rest != null);
    }

    record ArgumentsAndBlockTranslation(RubyNode block, RubyNode[] arguments, boolean isSplatted, ArgumentsDescriptor argumentsDescriptor, int frameOnStackMarkerSlot) {
    }

    private record RegexpEncodingAndOptions(RubyEncoding encoding, RegexpOptions options) {
    }
}

