/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import org.prism.Nodes;
import org.truffleruby.core.array.ArrayIndexNodes;
import org.truffleruby.core.array.ArraySliceNode;
import org.truffleruby.core.array.ArraySliceNodeGen;
import org.truffleruby.core.array.MultipleAssignmentNode;
import org.truffleruby.core.hash.HashLiteralNode;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.CheckNoKeywordArgumentsNode;
import org.truffleruby.language.arguments.ReadBlockOptionalArgumentFromArrayNode;
import org.truffleruby.language.arguments.ReadBlockPostArgumentFromArrayNode;
import org.truffleruby.language.arguments.ReadKeywordArgumentNode;
import org.truffleruby.language.arguments.SaveMethodBlockNode;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.YARPBaseTranslator;
import org.truffleruby.parser.YARPMultiTargetNodeTranslator;
import org.truffleruby.parser.YARPTranslator;

public final class YARPParametersNodeToDestructureTranslator
extends YARPBaseTranslator {
    private final YARPTranslator yarpTranslator;
    private final Nodes.ParametersNode parameters;
    private int index;
    private State state;
    private final RubyNode readArrayNode;

    public YARPParametersNodeToDestructureTranslator(TranslatorEnvironment environment, Nodes.ParametersNode parameters, RubyNode readArrayNode, YARPTranslator yarpTranslator) {
        super(environment);
        this.parameters = parameters;
        this.readArrayNode = readArrayNode;
        this.yarpTranslator = yarpTranslator;
    }

    public RubyNode translate() {
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        sequence.add(YARPTranslator.loadSelf(this.language));
        if (this.parameters.requireds.length > 0) {
            this.state = State.PRE;
            this.index = 0;
            for (Nodes.Node node : this.parameters.requireds) {
                sequence.add(node.accept(this));
                ++this.index;
            }
        }
        if (this.parameters.optionals.length > 0) {
            this.index = this.parameters.requireds.length;
            for (Nodes.Node node : this.parameters.optionals) {
                sequence.add(((Nodes.OptionalParameterNode)node).accept(this));
                ++this.index;
            }
        }
        if (this.parameters.rest != null && !(this.parameters.rest instanceof Nodes.ImplicitRestNode)) {
            sequence.add(this.parameters.rest.accept(this));
        }
        if (this.parameters.posts.length > 0) {
            this.state = State.POST;
            this.index = -1;
            for (int i = this.parameters.posts.length - 1; i >= 0; --i) {
                sequence.add(this.parameters.posts[i].accept(this));
                --this.index;
            }
        }
        for (Nodes.Node node : this.parameters.keywords) {
            sequence.add(node.accept(this));
        }
        if (this.parameters.keyword_rest != null) {
            sequence.add(this.parameters.keyword_rest.accept(this));
        }
        if (this.parameters.block != null) {
            sequence.add(this.parameters.block.accept(this));
        }
        return YARPParametersNodeToDestructureTranslator.sequence(sequence.toArray(RubyNode.EMPTY_ARRAY));
    }

    @Override
    public RubyNode visitMultiTargetNode(Nodes.MultiTargetNode node) {
        RubyContextSourceNode readNode;
        if (this.state == State.PRE) {
            readNode = ArrayIndexNodes.ReadConstantIndexNode.create(this.readArrayNode, this.index);
        } else if (this.state == State.POST) {
            readNode = new ReadBlockPostArgumentFromArrayNode(this.readArrayNode, -this.index, this.getRequiredCount(), this.getOptionalCount(), this.hasRest());
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        YARPMultiTargetNodeTranslator translator = new YARPMultiTargetNodeTranslator(node, this.language, this.yarpTranslator, readNode);
        MultipleAssignmentNode rubyNode = translator.translate();
        return rubyNode;
    }

    @Override
    public RubyNode visitRequiredKeywordParameterNode(Nodes.RequiredKeywordParameterNode node) {
        RubySymbol name = this.language.getSymbol(node.name);
        return ReadKeywordArgumentNode.create(name, null);
    }

    @Override
    public RubyNode visitRequiredParameterNode(Nodes.RequiredParameterNode node) {
        RubyContextSourceNode readNode;
        if (this.state == State.PRE) {
            readNode = ArrayIndexNodes.ReadConstantIndexNode.create(this.readArrayNode, this.index);
        } else if (this.state == State.POST) {
            readNode = new ReadBlockPostArgumentFromArrayNode(this.readArrayNode, -this.index, this.getRequiredCount(), this.getOptionalCount(), this.hasRest());
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        int slot = this.environment.findFrameSlot(node.name);
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitOptionalKeywordParameterNode(Nodes.OptionalKeywordParameterNode node) {
        int slot = this.environment.findFrameSlot(node.name);
        RubyNode defaultValue = node.value.accept(this);
        return new WriteLocalVariableNode(slot, defaultValue);
    }

    @Override
    public RubyNode visitOptionalParameterNode(Nodes.OptionalParameterNode node) {
        RubyNode defaultValue = node.value.accept(this);
        int slot = this.environment.findFrameSlot(node.name);
        int minimum = this.index + 1 + this.parameters.posts.length;
        ReadBlockOptionalArgumentFromArrayNode readNode = new ReadBlockOptionalArgumentFromArrayNode(this.readArrayNode, this.index, minimum, defaultValue);
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitRestParameterNode(Nodes.RestParameterNode node) {
        int from = this.parameters.requireds.length + this.parameters.optionals.length;
        int to = -this.parameters.posts.length;
        ArraySliceNode readNode = ArraySliceNodeGen.create(from, to, this.readArrayNode);
        String name = node.name != null ? node.name : "%unnamed_rest";
        int slot = this.environment.findFrameSlot(name);
        return new WriteLocalVariableNode(slot, readNode);
    }

    @Override
    public RubyNode visitImplicitRestNode(Nodes.ImplicitRestNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in #translate");
    }

    @Override
    public RubyNode visitKeywordRestParameterNode(Nodes.KeywordRestParameterNode node) {
        int slot;
        if (node.name != null) {
            slot = this.environment.findFrameSlot(node.name);
        } else {
            String name = "%kwrest";
            slot = this.environment.declareVar("%kwrest");
        }
        HashLiteralNode valueNode = HashLiteralNode.create(RubyNode.EMPTY_ARRAY, this.language);
        return new WriteLocalVariableNode(slot, valueNode);
    }

    @Override
    public RubyNode visitNoKeywordsParameterNode(Nodes.NoKeywordsParameterNode node) {
        return new CheckNoKeywordArgumentsNode();
    }

    @Override
    public RubyNode visitBlockParameterNode(Nodes.BlockParameterNode node) {
        String name = node.name == null ? "%forward_block" : node.name;
        int slot = this.environment.findFrameSlot(name);
        return new SaveMethodBlockNode(slot);
    }

    @Override
    protected RubyNode defaultVisit(Nodes.Node node) {
        return node.accept(this.yarpTranslator);
    }

    private int getRequiredCount() {
        return this.parameters.requireds.length + this.parameters.posts.length;
    }

    private int getOptionalCount() {
        return this.parameters.optionals.length;
    }

    private boolean hasRest() {
        return this.parameters.rest != null;
    }

    private static enum State {
        PRE,
        OPT,
        POST;

    }
}

