/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import java.nio.charset.Charset;
import org.prism.Loader;
import org.prism.ParseResult;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.parser.RubySource;

public final class YARPLoader
extends Loader {
    private final RubyEncoding encoding;

    public static ParseResult load(byte[] serialized, byte[] sourceBytes, RubySource rubySource) {
        return new YARPLoader(serialized, sourceBytes, rubySource).load();
    }

    public YARPLoader(byte[] serialized, byte[] sourceBytes, RubySource rubySource) {
        super(serialized, sourceBytes);
        this.encoding = rubySource.getEncoding();
    }

    @Override
    public Charset getEncodingCharset(String encodingName) {
        RubyEncoding rubyEncoding = Encodings.getBuiltInEncoding(encodingName);
        assert (rubyEncoding == this.encoding) : String.valueOf(rubyEncoding) + " (" + encodingName + ") vs " + String.valueOf(this.encoding);
        return null;
    }

    @Override
    public String bytesToName(byte[] bytes) {
        return TStringUtils.bytesToJavaStringOrThrow(bytes, 0, bytes.length, this.encoding);
    }
}

