/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.graalvm.shadowed.org.joni.WarnCallback;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;

public final class RubyWarnings
implements WarnCallback {
    public boolean warningsEnabled() {
        return RubyLanguage.getCurrentContext().getCoreLibrary().warningsEnabled();
    }

    public boolean isVerbose() {
        RubyContext context = RubyLanguage.getCurrentContext();
        return context != null && context.getCoreLibrary().isVerbose();
    }

    public void warn(String message) {
        this.warn(null, message);
    }

    public void warn(String fileName, int lineNumber, String message) {
        if (!this.warningsEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(fileName).append(':').append(lineNumber).append(": ");
        buffer.append("warning: ").append(message).append('\n');
        this.printWarning(buffer.toString());
    }

    public void warn(String fileName, String message) {
        if (!this.warningsEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        if (fileName != null) {
            buffer.append(fileName).append(' ');
        }
        buffer.append("warning: ").append(message).append('\n');
        this.printWarning(buffer.toString());
    }

    public void warning(String message) {
        if (this.isVerbose()) {
            this.warn(null, message);
        }
    }

    public void warning(String fileName, int lineNumber, String message) {
        if (this.isVerbose()) {
            this.warn(fileName, lineNumber, message);
        }
    }

    private void printWarning(String message) {
        RubyContext context = RubyLanguage.getCurrentContext();
        if (context.getCoreLibrary().isLoaded()) {
            RubyModule warning = context.getCoreLibrary().warningModule;
            RubyString messageString = StringOperations.createUTF8String(context, context.getLanguageSlow(), message);
            DispatchNode.getUncached().call((Object)warning, "warn", (Object)messageString);
        } else {
            try {
                context.getEnv().err().write(message.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new RaiseException(context, context.getCoreExceptions().ioError(e, null));
            }
        }
    }
}

