/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Objects;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyFileTypeDetector;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.parser.MagicCommentParser;

public final class RubySource {
    private final Source source;
    private final TruffleString code;
    private byte[] bytes;
    private final RubyEncoding encoding;
    private final boolean isEval;
    private final int lineOffset;

    public RubySource(Source source, String sourcePath) {
        this(source, sourcePath, null, false);
    }

    public RubySource(Source source, String sourcePath, TStringWithEncoding code) {
        this(source, sourcePath, code, false);
    }

    private RubySource(Source source, String sourcePath, TStringWithEncoding code, boolean isEval) {
        this(source, sourcePath, code, isEval, 0);
    }

    public RubySource(Source source, String sourcePath, TStringWithEncoding code, boolean isEval, int lineOffset) {
        assert (RubyLanguage.getPath(source).equals(sourcePath)) : RubyLanguage.getPath(source) + " vs " + sourcePath;
        this.source = Objects.requireNonNull(source);
        if (code == null) {
            String sourceString = source.getCharacters().toString();
            RubyEncoding encoding = RubyFileTypeDetector.findEncoding(new BufferedReader(new StringReader(sourceString)));
            if (encoding == null) {
                encoding = Encodings.UTF_8;
            }
            code = new TStringWithEncoding(TStringUtils.fromJavaString(sourceString, encoding), encoding);
        }
        assert (RubySource.checkMagicEncoding(code));
        this.code = code.tstring;
        this.encoding = code.encoding;
        this.isEval = isEval;
        this.lineOffset = lineOffset;
    }

    private static boolean checkMagicEncoding(TStringWithEncoding code) {
        RubyEncoding magicEncoding = MagicCommentParser.parseMagicEncodingComment(code);
        assert (magicEncoding == null || magicEncoding == code.encoding);
        return true;
    }

    public Source getSource() {
        return this.source;
    }

    public String getSourcePath(RubyLanguage language) {
        return language.getSourcePath(this.source);
    }

    public TruffleString getTruffleString() {
        return this.code;
    }

    public TStringWithEncoding getTStringWithEncoding() {
        return new TStringWithEncoding(this.code, this.encoding);
    }

    public byte[] getBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        this.bytes = TStringUtils.getBytesOrCopy((AbstractTruffleString)this.code, this.encoding);
        return this.bytes;
    }

    public RubyEncoding getEncoding() {
        return this.encoding;
    }

    public boolean isEval() {
        return this.isEval;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    @CompilerDirectives.TruffleBoundary
    public static int getStartLineAdjusted(RubyContext context, SourceSection sourceSection) {
        Integer lineOffset = context.getSourceLineOffsets().get(sourceSection.getSource());
        if (lineOffset != null) {
            return sourceSection.getStartLine() + lineOffset;
        }
        return sourceSection.getStartLine();
    }
}

