/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import java.util.ArrayList;
import org.graalvm.shadowed.org.joni.WarnCallback;

public final class RubyDeferredWarnings
implements WarnCallback {
    public ArrayList<WarningMessage> warnings = new ArrayList();

    public void warn(String message) {
        this.warn(null, message);
    }

    public void warn(String fileName, int lineNumber, String message) {
        this.warnings.add(new WarningMessage(Verbosity.NON_VERBOSE, fileName, lineNumber, message));
    }

    public void warn(String fileName, String message) {
        this.warnings.add(new WarningMessage(Verbosity.NON_VERBOSE, fileName, null, message));
    }

    public void warning(String message) {
        this.warnings.add(new WarningMessage(Verbosity.VERBOSE, null, null, message));
    }

    public void warning(String fileName, int lineNumber, String message) {
        this.warnings.add(new WarningMessage(Verbosity.VERBOSE, fileName, lineNumber, message));
    }

    public String toString() {
        ArrayList<String> strings = new ArrayList<String>();
        for (WarningMessage warning : this.warnings) {
            strings.add(warning.toString());
        }
        String messages = String.join((CharSequence)", ", strings);
        return "RubyDeferredWarnings(" + messages + ")";
    }

    public static final class WarningMessage {
        public final Verbosity verbosity;
        private final String fileName;
        private final Integer lineNumber;
        private final String message;

        public WarningMessage(Verbosity verbosity, String fileName, Integer lineNumber, String message) {
            this.verbosity = verbosity;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
            this.message = message;
        }

        public String getWarningMessage() {
            StringBuilder buffer = new StringBuilder();
            if (this.fileName != null) {
                buffer.append(this.fileName);
                if (this.lineNumber != null) {
                    buffer.append(':').append(this.lineNumber).append(": ");
                } else {
                    buffer.append(' ');
                }
            }
            buffer.append("warning: ").append(this.message).append('\n');
            return buffer.toString();
        }

        public String toString() {
            return "WarningMessage(message = '" + this.message + "', verbosity = " + String.valueOf((Object)this.verbosity) + ", fileName = '" + this.fileName + "', lineNumber = " + this.lineNumber + ")";
        }
    }

    public static enum Verbosity {
        VERBOSE,
        NON_VERBOSE;

    }
}

