/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Objects;
import org.truffleruby.collections.Memo;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.StringSupport;
import org.truffleruby.core.string.TStringWithEncoding;

public abstract class MagicCommentParser {
    public static boolean isMagicEncodingComment(String name) {
        return "coding".equalsIgnoreCase(name) || "encoding".equalsIgnoreCase(name);
    }

    public static boolean isMagicTruffleRubyPrimitivesComment(String name) {
        return "truffleruby_primitives".equalsIgnoreCase(name);
    }

    public static TStringWithEncoding createSourceTStringBasedOnMagicEncodingComment(byte[] bytes, RubyEncoding defaultEncoding) {
        TStringWithEncoding tstring = new TStringWithEncoding(TStringUtils.fromByteArray(bytes, defaultEncoding), defaultEncoding);
        return MagicCommentParser.createSourceTStringBasedOnMagicEncodingComment(tstring, defaultEncoding);
    }

    public static TStringWithEncoding createSourceTStringBasedOnMagicEncodingComment(TStringWithEncoding source, RubyEncoding defaultEncoding) {
        Objects.requireNonNull(defaultEncoding);
        RubyEncoding encoding = MagicCommentParser.parseMagicEncodingComment(source);
        if (encoding == null) {
            encoding = defaultEncoding;
        }
        if (source.getEncoding() != encoding) {
            source = source.forceEncoding(encoding);
        }
        return source;
    }

    public static RubyEncoding parseMagicEncodingComment(TStringWithEncoding source) {
        Memo<Object> encoding = new Memo<Object>(null);
        InternalByteArray bytes = source.getInternalByteArray();
        int length = bytes.getLength();
        int start = 0;
        if (MagicCommentParser.hasShebangLine(bytes)) {
            start = MagicCommentParser.newLineIndex(bytes, 2) + 1;
        }
        while (start < length && StringSupport.isAsciiSpace(bytes.get(start)) && bytes.get(start) != 10) {
            ++start;
        }
        if (start < length && bytes.get(start) == 35) {
            RubyEncoding rubyEncoding;
            TruffleString encodingName;
            int magicLineStart;
            int endOfMagicLine;
            if ((endOfMagicLine = MagicCommentParser.newLineIndex(bytes, magicLineStart = ++start)) < length) {
                ++endOfMagicLine;
            }
            int magicLineLength = endOfMagicLine - magicLineStart;
            TStringWithEncoding magicLine = source.substring(magicLineStart, magicLineLength);
            MagicCommentParser.parser_magic_comment(magicLine, 0, magicLineLength, (name, value) -> {
                RubyEncoding rubyEncoding;
                if (MagicCommentParser.isMagicEncodingComment(name) && (rubyEncoding = Encodings.getBuiltInEncoding(value.toJavaStringUncached())) != null) {
                    encoding.set(rubyEncoding);
                    return true;
                }
                return false;
            });
            if (encoding.get() == null && (encodingName = MagicCommentParser.get_file_encoding(magicLine)) != null && (rubyEncoding = Encodings.getBuiltInEncoding(encodingName.toJavaStringUncached())) != null) {
                encoding.set(rubyEncoding);
            }
        }
        return encoding.get();
    }

    public static boolean parser_magic_comment(TStringWithEncoding magicLine, int magicLineOffset, int magicLineLength, MagicCommentHandler magicCommentHandler) {
        boolean emacsStyle = false;
        int i = magicLineOffset;
        int end = magicLineOffset + magicLineLength;
        if (magicLineLength <= 7) {
            return false;
        }
        int emacsBegin = MagicCommentParser.findEmacsStyleMarker(magicLine, 0, end);
        if (emacsBegin >= 0) {
            int emacsEnd = MagicCommentParser.findEmacsStyleMarker(magicLine, emacsBegin, end);
            if (emacsEnd < 0) {
                return false;
            }
            emacsStyle = true;
            i = emacsBegin;
            end = emacsEnd - 3;
        }
        while (i < end) {
            TruffleString value;
            String name;
            int valueEnd;
            int valueBegin;
            int c;
            int c2;
            while (i < end && (MagicCommentParser.isIgnoredMagicLineCharacter(c2 = magicLine.get(i)) || StringSupport.isAsciiSpace(c2))) {
                ++i;
            }
            int nameBegin = i;
            while (i < end && !MagicCommentParser.isIgnoredMagicLineCharacter(c = magicLine.get(i)) && !StringSupport.isAsciiSpace(c)) {
                ++i;
            }
            int nameEnd = i;
            while (i < end && StringSupport.isAsciiSpace(magicLine.get(i))) {
                ++i;
            }
            if (i == end) break;
            int sep = magicLine.get(i);
            if (sep == 58) {
                ++i;
            } else {
                if (emacsStyle) continue;
                return false;
            }
            while (i < end && StringSupport.isAsciiSpace(magicLine.get(i))) {
                ++i;
            }
            if (i == end) break;
            if (magicLine.get(i) == 34) {
                valueBegin = ++i;
                while (i < end && magicLine.get(i) != 34) {
                    if (magicLine.get(i) == 92) {
                        i += 2;
                        continue;
                    }
                    ++i;
                }
                valueEnd = i;
                if (i < end) {
                    ++i;
                }
            } else {
                int c3;
                valueBegin = i;
                while (i < end && (c3 = magicLine.get(i)) != 34 && c3 != 59 && !StringSupport.isAsciiSpace(c3)) {
                    ++i;
                }
                valueEnd = i;
            }
            if (emacsStyle) {
                while (i < end && (magicLine.get(i) == 59 || StringSupport.isAsciiSpace(magicLine.get(i)))) {
                    ++i;
                }
            } else {
                while (i < end && StringSupport.isAsciiSpace(magicLine.get(i))) {
                    ++i;
                }
                if (i < end) {
                    return false;
                }
            }
            if (magicCommentHandler.onMagicComment(name = magicLine.substring(nameBegin, nameEnd - nameBegin).toJavaString().replace('-', '_'), value = magicLine.substringAsTString(valueBegin, valueEnd - valueBegin))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasShebangLine(InternalByteArray bytes) {
        return bytes.getLength() > 2 && bytes.get(0) == 35 && bytes.get(1) == 33;
    }

    private static int newLineIndex(InternalByteArray bytes, int start) {
        int index = ArrayUtils.indexOf((byte[])bytes.getArray(), (int)(bytes.getOffset() + start), (int)bytes.getEnd(), (byte[])new byte[]{10});
        if (index < 0) {
            return bytes.getLength();
        }
        return index - bytes.getOffset();
    }

    private static boolean isIgnoredMagicLineCharacter(int c) {
        switch (c) {
            case 34: 
            case 39: 
            case 58: 
            case 59: {
                return true;
            }
        }
        return false;
    }

    private static int findEmacsStyleMarker(TStringWithEncoding str, int begin, int end) {
        InternalByteArray bytes = str.getInternalByteArray();
        int i = begin;
        block4: while (i < end) {
            switch (bytes.get(i)) {
                case 45: {
                    if (i >= 2 && bytes.get(i - 1) == 42 && bytes.get(i - 2) == 45) {
                        return i + 1;
                    }
                    i += 2;
                    continue block4;
                }
                case 42: {
                    if (i + 1 >= end) {
                        return -1;
                    }
                    if (bytes.get(i + 1) != 45) {
                        i += 4;
                        continue block4;
                    }
                    if (bytes.get(i - 1) != 45) {
                        i += 2;
                        continue block4;
                    }
                    return i + 2;
                }
            }
            i += 3;
        }
        return -1;
    }

    public static TruffleString get_file_encoding(TStringWithEncoding magicLine) {
        int str = 0;
        int send = magicLine.byteLength();
        boolean sep = false;
        block9: while (true) {
            if (send - str <= 6) {
                return null;
            }
            switch (magicLine.get(str + 6)) {
                case 67: 
                case 99: {
                    str += 6;
                    continue block9;
                }
                case 79: 
                case 111: {
                    str += 5;
                    continue block9;
                }
                case 68: 
                case 100: {
                    str += 4;
                    continue block9;
                }
                case 73: 
                case 105: {
                    str += 3;
                    continue block9;
                }
                case 78: 
                case 110: {
                    str += 2;
                    continue block9;
                }
                case 71: 
                case 103: {
                    ++str;
                    continue block9;
                }
                case 58: 
                case 61: {
                    sep = true;
                    str += 6;
                    break;
                }
                default: {
                    if (!Character.isSpaceChar(magicLine.get(str += 6))) continue block9;
                }
            }
            if (magicLine.substring(str - 6, 6).toJavaString().equalsIgnoreCase("coding")) break;
        }
        while (true) {
            if (++str >= send) {
                return null;
            }
            if (Character.isSpaceChar(magicLine.get(str))) continue;
            if (sep) break;
            if (magicLine.get(str) != 61 && magicLine.get(str) != 58) {
                return null;
            }
            sep = true;
            ++str;
        }
        int beg = str;
        while ((magicLine.get(str) == 45 || magicLine.get(str) == 95 || Character.isLetterOrDigit(magicLine.get(str))) && ++str < send) {
        }
        return magicLine.substring((int)beg, (int)(str - beg)).tstring;
    }

    public static interface MagicCommentHandler {
        public boolean onMagicComment(String var1, TruffleString var2);
    }
}

