/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import org.truffleruby.core.string.StringUtils;
import org.truffleruby.parser.ArgumentType;

public final class ArgumentDescriptor {
    public final ArgumentType type;
    public final String name;
    public static final ArgumentDescriptor[] ANY_UNNAMED = new ArgumentDescriptor[]{new ArgumentDescriptor(ArgumentType.unnamedrest)};
    public static final ArgumentDescriptor[] AT_LEAST_ONE_UNNAMED = new ArgumentDescriptor[]{new ArgumentDescriptor(ArgumentType.unnamedreq), new ArgumentDescriptor(ArgumentType.unnamedrest)};
    public static final ArgumentDescriptor[] EMPTY_ARRAY = new ArgumentDescriptor[0];

    public ArgumentDescriptor(ArgumentType type, String name) {
        if (name == null && !type.anonymous) {
            throw new RuntimeException("null argument name given for non-anonymous argument type");
        }
        this.type = type;
        this.name = name;
    }

    public ArgumentDescriptor(ArgumentType type) {
        this(type, null);
    }

    public String toString() {
        return StringUtils.format("ArgumentDescriptor(name = %s, type = %s)", new Object[]{this.name, this.type});
    }
}

