/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.yield;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayToObjectArrayNode;
import org.truffleruby.core.array.ArrayToObjectArrayNodeGen;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.LiteralCallNode;
import org.truffleruby.language.yield.CallBlockNode;

public final class YieldExpressionNode
extends LiteralCallNode {
    @Node.Children
    private final RubyNode[] arguments;
    @Node.Child
    private CallBlockNode yieldNode;
    @Node.Child
    private ArrayToObjectArrayNode unsplatNode;
    @Node.Child
    private RubyNode readBlockNode;

    public YieldExpressionNode(boolean isSplatted, ArgumentsDescriptor descriptor, RubyNode[] arguments, RubyNode readBlockNode) {
        super(isSplatted, descriptor);
        this.arguments = arguments;
        this.readBlockNode = readBlockNode;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        Object maybeBlock = this.readBlockNode.execute(frame);
        if (maybeBlock == nil) {
            throw new RaiseException(this.getContext(), this.coreExceptions().noBlockToYieldTo(this));
        }
        RubyProc block = (RubyProc)maybeBlock;
        ArgumentsDescriptor descriptor = this.descriptor;
        if (this.isSplatted) {
            argumentsObjects = this.unsplat(argumentsObjects);
            descriptor = this.getArgumentsDescriptorAndCheckRuby2KeywordsHash(argumentsObjects, argumentsObjects.length);
        }
        if (descriptor instanceof KeywordArgumentsDescriptor && this.emptyKeywordArguments(argumentsObjects)) {
            argumentsObjects = YieldExpressionNode.removeEmptyKeywordArguments(argumentsObjects);
            descriptor = NoKeywordArgumentsDescriptor.INSTANCE;
        }
        return this.getYieldNode().yieldCached(block, descriptor, argumentsObjects);
    }

    private Object[] unsplat(Object[] argumentsObjects) {
        if (this.unsplatNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.unsplatNode = (ArrayToObjectArrayNode)this.insert(ArrayToObjectArrayNodeGen.create());
        }
        return this.unsplatNode.unsplat(argumentsObjects);
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        Object block = this.readBlockNode.execute(frame);
        if (block == nil) {
            return nil;
        }
        return FrozenStrings.YIELD;
    }

    private CallBlockNode getYieldNode() {
        if (this.yieldNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.yieldNode = (CallBlockNode)this.insert(CallBlockNode.create());
        }
        return this.yieldNode;
    }

    @Override
    public RubyNode cloneUninitialized() {
        YieldExpressionNode copy = new YieldExpressionNode(this.isSplatted, this.descriptor, YieldExpressionNode.cloneUninitialized(this.arguments), this.readBlockNode.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

