/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.classvariables;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import java.lang.invoke.VarHandle;
import org.truffleruby.RubyLanguage;

public final class ClassVariableStorage
extends DynamicObject {
    @DynamicObject.DynamicField
    private long primitive1;
    @DynamicObject.DynamicField
    private long primitive2;
    @DynamicObject.DynamicField
    private long primitive3;
    @DynamicObject.DynamicField
    private Object object1;
    @DynamicObject.DynamicField
    private Object object2;
    @DynamicObject.DynamicField
    private Object object3;
    @DynamicObject.DynamicField
    private Object object4;

    public ClassVariableStorage(RubyLanguage language) {
        super(language.classVariableShape);
    }

    public Object read(String name, DynamicObjectLibrary objectLibrary) {
        Object value = objectLibrary.getOrDefault((DynamicObject)this, (Object)name, null);
        if (objectLibrary.isShared((DynamicObject)this)) {
            VarHandle.acquireFence();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String name, Object value, DynamicObjectLibrary objectLibrary) {
        VarHandle.releaseFence();
        ClassVariableStorage classVariableStorage = this;
        synchronized (classVariableStorage) {
            objectLibrary.put((DynamicObject)this, (Object)name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfPresent(String name, Object value, DynamicObjectLibrary objectLibrary) {
        VarHandle.releaseFence();
        ClassVariableStorage classVariableStorage = this;
        synchronized (classVariableStorage) {
            return objectLibrary.putIfPresent((DynamicObject)this, (Object)name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name, DynamicObjectLibrary objectLibrary) {
        Object prev;
        ClassVariableStorage classVariableStorage = this;
        synchronized (classVariableStorage) {
            prev = this.read(name, objectLibrary);
            if (prev != null) {
                VarHandle.releaseFence();
                objectLibrary.removeKey((DynamicObject)this, (Object)name);
            }
        }
        return prev;
    }
}

