/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.constants.GetConstantNode;
import org.truffleruby.language.constants.LookupConstantBaseNode;
import org.truffleruby.language.constants.LookupConstantInterface;
import org.truffleruby.language.control.RaiseException;

public final class LookupForExistingModuleNode
extends LookupConstantBaseNode
implements LookupConstantInterface {
    @Node.Child
    GetConstantNode getConstantNode = GetConstantNode.create();

    public Object lookupForExistingModule(VirtualFrame frame, String name, RubyModule lexicalParent) {
        LexicalScope lexicalScope = RubyArguments.getMethod((Frame)frame).getLexicalScope();
        return this.getConstantNode.lookupAndResolveConstant(lexicalScope, lexicalParent, name, this, false);
    }

    @Override
    public RubyConstant lookupConstant(Node node, LexicalScope lexicalScope, RubyModule module, String name, boolean checkName) {
        RubyModule lexicalParent = module;
        return this.deepConstantSearch(name, lexicalScope, lexicalParent);
    }

    @CompilerDirectives.TruffleBoundary
    private RubyConstant deepConstantSearch(String name, LexicalScope lexicalScope, RubyModule lexicalParent) {
        RubyConstant constant = this.deepConstantLookup(name, lexicalParent);
        if (constant != null) {
            if (!constant.isVisibleTo(this.getContext(), lexicalScope, lexicalScope.getLiveModule()) && !constant.isVisibleTo(this.getContext(), LexicalScope.NONE, lexicalParent)) {
                throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorPrivateConstant(lexicalParent, name, this));
            }
            if (constant.isDeprecated()) {
                this.warnDeprecatedConstant(lexicalParent, name);
            }
        }
        return constant;
    }

    @CompilerDirectives.TruffleBoundary
    private RubyConstant deepConstantLookup(String name, RubyModule lexicalParent) {
        RubyConstant constant = lexicalParent.fields.getConstant(name);
        if (ModuleOperations.isConstantDefined(constant)) {
            return constant;
        }
        RubyClass objectClass = this.getContext().getCoreLibrary().objectClass;
        if (lexicalParent == objectClass && ModuleOperations.isConstantDefined(constant = ModuleOperations.lookupConstantInObjectUncached(this.getContext(), name))) {
            return constant;
        }
        return null;
    }
}

