/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.range.RubyIntOrLongRange;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NoImplicitCastsToLong;
import org.truffleruby.language.objects.ImmutableClassNode;

@GeneratedBy(value=ImmutableClassNode.class)
public final class ImmutableClassNodeGen {
    private static final Uncached UNCACHED = new Uncached();

    @CompilerDirectives.TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException3(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value) {
        return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value, arg2Value});
    }

    @NeverDefault
    public static ImmutableClassNode getUncached() {
        return UNCACHED;
    }

    @NeverDefault
    public static ImmutableClassNode inline(@InlineSupport.RequiredField(bits=12, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
        return new Inlined(target);
    }

    @GeneratedBy(value=ImmutableClassNode.class)
    @DenyReplace
    private static final class Uncached
    extends ImmutableClassNode
    implements UnadoptableNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected RubyClass execute(Node arg0Value, Object arg1Value, CoreLibrary arg2Value) {
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                return ImmutableClassNode.metaClassInt(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof ImmutableRubyString) {
                ImmutableRubyString arg1Value_ = (ImmutableRubyString)arg1Value;
                return ImmutableClassNode.metaClassImmutableString(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof RubySymbol) {
                RubySymbol arg1Value_ = (RubySymbol)arg1Value;
                return ImmutableClassNode.metaClassSymbol(arg1Value_, arg2Value);
            }
            if (NoImplicitCastsToLong.isNil(arg1Value)) {
                Nil arg1Value_ = NoImplicitCastsToLong.asNil(arg1Value);
                return ImmutableClassNode.metaClassNil(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (Boolean)arg1Value;
                if (arg1Value_) {
                    return ImmutableClassNode.metaClassTrue(arg1Value_, arg2Value);
                }
                if (!arg1Value_) {
                    return ImmutableClassNode.metaClassFalse(arg1Value_, arg2Value);
                }
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (Long)arg1Value;
                return ImmutableClassNode.metaClassLong(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof RubyEncoding) {
                RubyEncoding arg1Value_ = (RubyEncoding)arg1Value;
                return ImmutableClassNode.metaClassEncoding(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof RubyRegexp) {
                RubyRegexp arg1Value_ = (RubyRegexp)arg1Value;
                return ImmutableClassNode.metaClassRegexp(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof RubyIntOrLongRange) {
                RubyIntOrLongRange arg1Value_ = (RubyIntOrLongRange)arg1Value;
                return ImmutableClassNode.metaClassRange(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Double) {
                double arg1Value_ = (Double)arg1Value;
                return ImmutableClassNode.metaClassDouble(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof RubyBignum) {
                RubyBignum arg1Value_ = (RubyBignum)arg1Value;
                return ImmutableClassNode.metaClassBignum(arg1Value_, arg2Value);
            }
            throw ImmutableClassNodeGen.newUnsupportedSpecializationException3(this, arg0Value, arg1Value, arg2Value);
        }
    }

    @GeneratedBy(value=ImmutableClassNode.class)
    @DenyReplace
    private static final class Inlined
    extends ImmutableClassNode
    implements UnadoptableNode {
        private final InlineSupport.StateField state_0_;

        private Inlined(InlineSupport.InlineTarget target) {
            assert (target.getTargetClass().isAssignableFrom(ImmutableClassNode.class));
            this.state_0_ = target.getState(0, 12);
        }

        @Override
        protected RubyClass execute(Node arg0Value, Object arg1Value, CoreLibrary arg2Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    return ImmutableClassNode.metaClassInt(arg1Value_, arg2Value);
                }
                if ((state_0 & 2) != 0 && arg1Value instanceof ImmutableRubyString) {
                    ImmutableRubyString arg1Value_ = (ImmutableRubyString)arg1Value;
                    return ImmutableClassNode.metaClassImmutableString(arg1Value_, arg2Value);
                }
                if ((state_0 & 4) != 0 && arg1Value instanceof RubySymbol) {
                    RubySymbol arg1Value_ = (RubySymbol)arg1Value;
                    return ImmutableClassNode.metaClassSymbol(arg1Value_, arg2Value);
                }
                if ((state_0 & 8) != 0 && NoImplicitCastsToLong.isNil(arg1Value)) {
                    Nil arg1Value_ = NoImplicitCastsToLong.asNil(arg1Value);
                    return ImmutableClassNode.metaClassNil(arg1Value_, arg2Value);
                }
                if ((state_0 & 0x30) != 0 && arg1Value instanceof Boolean) {
                    boolean arg1Value_ = (Boolean)arg1Value;
                    if ((state_0 & 0x10) != 0 && arg1Value_) {
                        return ImmutableClassNode.metaClassTrue(arg1Value_, arg2Value);
                    }
                    if ((state_0 & 0x20) != 0 && !arg1Value_) {
                        return ImmutableClassNode.metaClassFalse(arg1Value_, arg2Value);
                    }
                }
                if ((state_0 & 0x40) != 0 && arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    return ImmutableClassNode.metaClassLong(arg1Value_, arg2Value);
                }
                if ((state_0 & 0x80) != 0 && arg1Value instanceof RubyEncoding) {
                    RubyEncoding arg1Value_ = (RubyEncoding)arg1Value;
                    return ImmutableClassNode.metaClassEncoding(arg1Value_, arg2Value);
                }
                if ((state_0 & 0x100) != 0 && arg1Value instanceof RubyRegexp) {
                    RubyRegexp arg1Value_ = (RubyRegexp)arg1Value;
                    return ImmutableClassNode.metaClassRegexp(arg1Value_, arg2Value);
                }
                if ((state_0 & 0x200) != 0 && arg1Value instanceof RubyIntOrLongRange) {
                    RubyIntOrLongRange arg1Value_ = (RubyIntOrLongRange)arg1Value;
                    return ImmutableClassNode.metaClassRange(arg1Value_, arg2Value);
                }
                if ((state_0 & 0x400) != 0 && arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    return ImmutableClassNode.metaClassDouble(arg1Value_, arg2Value);
                }
                if ((state_0 & 0x800) != 0 && arg1Value instanceof RubyBignum) {
                    RubyBignum arg1Value_ = (RubyBignum)arg1Value;
                    return ImmutableClassNode.metaClassBignum(arg1Value_, arg2Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private RubyClass executeAndSpecialize(Node arg0Value, Object arg1Value, CoreLibrary arg2Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 1);
                return ImmutableClassNode.metaClassInt(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof ImmutableRubyString) {
                ImmutableRubyString arg1Value_ = (ImmutableRubyString)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 2);
                return ImmutableClassNode.metaClassImmutableString(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof RubySymbol) {
                RubySymbol arg1Value_ = (RubySymbol)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 4);
                return ImmutableClassNode.metaClassSymbol(arg1Value_, arg2Value);
            }
            if (NoImplicitCastsToLong.isNil(arg1Value)) {
                Nil arg1Value_ = NoImplicitCastsToLong.asNil(arg1Value);
                this.state_0_.set(arg0Value, state_0 |= 8);
                return ImmutableClassNode.metaClassNil(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (Boolean)arg1Value;
                if (arg1Value_) {
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return ImmutableClassNode.metaClassTrue(arg1Value_, arg2Value);
                }
                if (!arg1Value_) {
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    return ImmutableClassNode.metaClassFalse(arg1Value_, arg2Value);
                }
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (Long)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 0x40);
                return ImmutableClassNode.metaClassLong(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof RubyEncoding) {
                RubyEncoding arg1Value_ = (RubyEncoding)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 0x80);
                return ImmutableClassNode.metaClassEncoding(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof RubyRegexp) {
                RubyRegexp arg1Value_ = (RubyRegexp)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 0x100);
                return ImmutableClassNode.metaClassRegexp(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof RubyIntOrLongRange) {
                RubyIntOrLongRange arg1Value_ = (RubyIntOrLongRange)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 0x200);
                return ImmutableClassNode.metaClassRange(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Double) {
                double arg1Value_ = (Double)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 0x400);
                return ImmutableClassNode.metaClassDouble(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof RubyBignum) {
                RubyBignum arg1Value_ = (RubyBignum)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 0x800);
                return ImmutableClassNode.metaClassBignum(arg1Value_, arg2Value);
            }
            throw ImmutableClassNodeGen.newUnsupportedSpecializationException3(this, arg0Value, arg1Value, arg2Value);
        }
    }
}

