/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import org.truffleruby.core.range.RubyObjectRange;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.ImmutableRubyObject;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.FreezeNodeGen;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class FreezeNode
extends RubyBaseNode {
    public abstract Object execute(Node var1, Object var2);

    public static Object executeUncached(Object object) {
        return FreezeNodeGen.getUncached().execute(null, object);
    }

    @Specialization
    static Object freezeRubyString(RubyString object) {
        object.frozen = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"!isRubyObjectRange(object)", "isNotRubyString(object)"}, limit="getDynamicObjectCacheLimit()")
    static Object freeze(Node node, RubyDynamicObject object, @CachedLibrary(value="object") DynamicObjectLibrary objectLibrary) {
        if (objectLibrary.isShared((DynamicObject)object)) {
            RubyDynamicObject rubyDynamicObject = object;
            synchronized (rubyDynamicObject) {
                objectLibrary.setShapeFlags((DynamicObject)object, objectLibrary.getShapeFlags((DynamicObject)object) | 1);
            }
        } else {
            objectLibrary.setShapeFlags((DynamicObject)object, objectLibrary.getShapeFlags((DynamicObject)object) | 1);
        }
        return object;
    }

    @Specialization
    static Object freezeRubyObjectRange(RubyObjectRange object) {
        object.frozen = true;
        return true;
    }

    @Specialization
    static Object freeze(ImmutableRubyObject object) {
        return object;
    }

    @Specialization
    static Object freeze(boolean object) {
        return object;
    }

    @Specialization
    static Object freeze(int object) {
        return object;
    }

    @Specialization
    static Object freeze(long object) {
        return object;
    }

    @Specialization
    static Object freeze(double object) {
        return object;
    }
}

