/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.Layouts;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.objectspace.ObjectSpaceManager;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.methods.InternalMethod;

public abstract class AllocationTracing {
    public static void trace(RubyDynamicObject instance, Node currentNode) {
        RubyLanguage language = RubyLanguage.get(currentNode);
        RubyContext context = RubyContext.get(currentNode);
        AllocationTracing.truffleTracing(language, instance);
        if (context.getObjectSpaceManager().isTracing(language)) {
            AllocationTracing.traceBoundary(context, instance, currentNode);
        }
    }

    public static void traceInlined(RubyDynamicObject instance, String className, String allocatingMethod, AlwaysInlinedMethodNode node) {
        RubyLanguage language = RubyLanguage.get(node);
        RubyContext context = RubyContext.get(node);
        AllocationTracing.truffleTracing(language, instance);
        if (context.getObjectSpaceManager().isTracing(language)) {
            AllocationTracing.traceInlineBoundary(context, instance, className, allocatingMethod, node);
        }
    }

    private static void truffleTracing(RubyLanguage language, RubyDynamicObject instance) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)language));
        AllocationReporter allocationReporter = language.getAllocationReporter();
        if (allocationReporter.isActive()) {
            allocationReporter.onEnter(null, 0L, Long.MIN_VALUE);
            allocationReporter.onReturnValue((Object)instance, 0L, Long.MIN_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private static void traceBoundary(RubyContext context, RubyDynamicObject object, Node currentNode) {
        ObjectSpaceManager objectSpaceManager = context.getObjectSpaceManager();
        if (!objectSpaceManager.isTracingPaused()) {
            objectSpaceManager.setTracingPaused(true);
            try {
                AllocationTracing.callTraceAllocation(context, object, currentNode);
            }
            finally {
                objectSpaceManager.setTracingPaused(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private static void traceInlineBoundary(RubyContext context, RubyDynamicObject instance, String className, String allocatingMethod, Node node) {
        ObjectSpaceManager objectSpaceManager = context.getObjectSpaceManager();
        if (!objectSpaceManager.isTracingPaused()) {
            objectSpaceManager.setTracingPaused(true);
            try {
                AllocationTracing.callTraceInlineAllocation(context, instance, className, allocatingMethod, node);
            }
            finally {
                objectSpaceManager.setTracingPaused(false);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void callTraceAllocation(RubyContext context, RubyDynamicObject object, Node currentNode) {
        SourceSection allocatingSourceSection = context.getCallStack().getTopMostUserSourceSection(currentNode.getEncapsulatingSourceSection());
        Frame allocatingFrame = context.getCallStack().getCurrentRubyFrame(FrameInstance.FrameAccess.READ_ONLY);
        InternalMethod method = RubyArguments.getMethod(allocatingFrame);
        LexicalScope lexicalScope = method.getLexicalScope();
        RubyModule module = lexicalScope.getLiveModule();
        String className = lexicalScope == context.getRootLexicalScope() ? "" : (module == null ? "" : module.fields.getName());
        AllocationTracing.storeAllocationTrace(context, object, allocatingSourceSection, className, method.getName());
    }

    @CompilerDirectives.TruffleBoundary
    private static void callTraceInlineAllocation(RubyContext context, RubyDynamicObject instance, String className, String allocatingMethod, Node node) {
        SourceSection allocatingSourceSection = context.getCallStack().getTopMostUserSourceSection(node.getEncapsulatingSourceSection());
        AllocationTracing.storeAllocationTrace(context, instance, allocatingSourceSection, className, allocatingMethod);
    }

    private static void storeAllocationTrace(RubyContext context, RubyDynamicObject object, SourceSection allocatingSourceSection, String className, String allocatingMethod) {
        AllocationTrace trace = new AllocationTrace(className, allocatingMethod, allocatingSourceSection, ObjectSpaceManager.getCollectionCount(), context.getObjectSpaceManager().getTracingGeneration());
        DynamicObjectLibrary.getUncached().put((DynamicObject)object, (Object)Layouts.ALLOCATION_TRACE_IDENTIFIER, (Object)trace);
    }

    public static final class AllocationTrace {
        public final String className;
        public final String allocatingMethod;
        public final SourceSection allocatingSourceSection;
        public final int gcGeneration;
        public final int tracingGeneration;

        private AllocationTrace(String className, String allocatingMethod, SourceSection allocatingSourceSection, int gcGeneration, int tracingGeneration) {
            this.className = className;
            this.allocatingMethod = allocatingMethod;
            this.allocatingSourceSection = allocatingSourceSection;
            this.gcGeneration = gcGeneration;
            this.tracingGeneration = tracingGeneration;
        }
    }
}

