/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import java.util.Collections;
import java.util.Map;
import org.truffleruby.RubyContext;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.objects.SingletonClassNode;

public final class DeclarationContext {
    public static final Map<RubyModule, RubyModule[]> NO_REFINEMENTS = Collections.emptyMap();
    public static final DeclarationContext NONE = new DeclarationContext(Visibility.PUBLIC, null, NO_REFINEMENTS);
    public final Visibility visibility;
    public final DefaultDefinee defaultDefinee;
    private final Map<RubyModule, RubyModule[]> refinements;

    public static DeclarationContext topLevel(RubyContext context) {
        return DeclarationContext.topLevel(context.getCoreLibrary().objectClass);
    }

    public static DeclarationContext topLevel(RubyModule defaultDefinee) {
        return new DeclarationContext(Visibility.PRIVATE, new FixedDefaultDefinee(defaultDefinee), NO_REFINEMENTS);
    }

    public DeclarationContext(Visibility visibility, DefaultDefinee defaultDefinee, Map<RubyModule, RubyModule[]> refinements) {
        assert (refinements == NO_REFINEMENTS || !refinements.isEmpty()) : "Should use NO_REFINEMENTS if empty for faster getRefinementsFor()";
        this.visibility = visibility;
        this.defaultDefinee = defaultDefinee;
        this.refinements = refinements;
    }

    private static DeclarationContext lookupVisibility(Frame frame) {
        DeclarationContext declarationContext = RubyArguments.getDeclarationContext(frame);
        Visibility visibility = declarationContext.visibility;
        if (visibility != null) {
            return declarationContext;
        }
        MaterializedFrame declarationFrame = RubyArguments.getDeclarationFrame(frame);
        MaterializedFrame visibilityFrame = DeclarationContext.lookupVisibilityInternal(declarationFrame);
        return RubyArguments.getDeclarationContext((Frame)visibilityFrame);
    }

    @CompilerDirectives.TruffleBoundary
    private static MaterializedFrame lookupVisibilityInternal(MaterializedFrame frame) {
        while (frame != null) {
            Visibility visibility = RubyArguments.getDeclarationContext((Frame)frame).visibility;
            if (visibility != null) {
                return frame;
            }
            frame = RubyArguments.getDeclarationFrame((Frame)frame);
        }
        throw CompilerDirectives.shouldNotReachHere((String)"No declaration frame with visibility found");
    }

    public static Visibility findVisibility(Frame frame) {
        return DeclarationContext.lookupVisibility((Frame)frame).visibility;
    }

    public static Visibility findVisibilityCheckSelfAndDefaultDefinee(RubyModule module, Frame callerFrame) {
        DeclarationContext declarationContext = DeclarationContext.lookupVisibility(callerFrame);
        if (declarationContext == NONE) {
            return Visibility.PUBLIC;
        }
        if (RubyArguments.getSelf(callerFrame) != module) {
            return Visibility.PUBLIC;
        }
        if (declarationContext.getModuleToDefineMethods() != module) {
            return Visibility.PUBLIC;
        }
        return declarationContext.visibility;
    }

    private static void changeVisibility(Frame frame, Visibility newVisibility) {
        DeclarationContext topDeclarationContext = RubyArguments.getDeclarationContext(frame);
        Visibility visibility = topDeclarationContext.visibility;
        if (visibility != null) {
            if (newVisibility != topDeclarationContext.visibility) {
                RubyArguments.setDeclarationContext(frame, topDeclarationContext.withVisibility(newVisibility));
            }
        } else {
            MaterializedFrame declarationFrame = RubyArguments.getDeclarationFrame(frame);
            MaterializedFrame visibilityFrame = DeclarationContext.lookupVisibilityInternal(declarationFrame);
            DeclarationContext oldDeclarationContext = RubyArguments.getDeclarationContext((Frame)visibilityFrame);
            if (newVisibility != oldDeclarationContext.visibility) {
                RubyArguments.setDeclarationContext((Frame)visibilityFrame, oldDeclarationContext.withVisibility(newVisibility));
            }
        }
    }

    public static void setCurrentVisibility(Frame callerFrame, Visibility visibility) {
        DeclarationContext.changeVisibility(callerFrame, visibility);
    }

    public static void setRefinements(Frame callerFrame, DeclarationContext declarationContext, Map<RubyModule, RubyModule[]> refinements) {
        RubyArguments.setDeclarationContext(callerFrame, declarationContext.withRefinements(refinements));
    }

    public DeclarationContext withVisibility(Visibility visibility) {
        if (visibility == this.visibility) {
            return this;
        }
        return new DeclarationContext(visibility, this.defaultDefinee, this.refinements);
    }

    public DeclarationContext withRefinements(Map<RubyModule, RubyModule[]> refinements) {
        assert (refinements != null);
        return new DeclarationContext(this.visibility, this.defaultDefinee, refinements);
    }

    public Map<RubyModule, RubyModule[]> getRefinements() {
        return this.refinements;
    }

    public RubyModule[] getRefinementsFor(RubyModule module) {
        return this.refinements.get(module);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyModule getModuleToDefineMethods() {
        assert (this.defaultDefinee != null) : "Trying to find the default definee but this method should not have method definitions inside";
        return this.defaultDefinee.getModuleToDefineMethods();
    }

    public boolean hasRefinements() {
        return this.refinements != NO_REFINEMENTS;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "DeclarationContext{visibility=" + String.valueOf(this.visibility) + ", defaultDefinee=" + String.valueOf(this.defaultDefinee) + ", refinements=" + String.valueOf(this.refinements) + "}@" + this.hashCode();
    }

    public static final class FixedDefaultDefinee
    implements DefaultDefinee {
        private final RubyModule module;

        public FixedDefaultDefinee(RubyModule module) {
            this.module = module;
        }

        @Override
        public RubyModule getModuleToDefineMethods() {
            return this.module;
        }
    }

    private static interface DefaultDefinee {
        public RubyModule getModuleToDefineMethods();
    }

    public static final class SingletonClassOfSelfDefaultDefinee
    implements DefaultDefinee {
        private final Object self;

        public SingletonClassOfSelfDefaultDefinee(Object self) {
            this.self = self;
        }

        @Override
        public RubyModule getModuleToDefineMethods() {
            return SingletonClassNode.getUncached().execute(this.self);
        }
    }
}

