/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.methods.InternalMethod;

@GenerateInline
@GenerateCached(value=false)
@ReportPolymorphism
public abstract class CanBindMethodToModuleNode
extends RubyBaseNode {
    public abstract boolean executeCanBindMethodToModule(Node var1, InternalMethod var2, RubyModule var3);

    @Specialization(guards={"method.getDeclaringModule() == declaringModule", "module == cachedModule"}, limit="getCacheLimit()")
    static boolean canBindMethodToCached(InternalMethod method, RubyModule module, @Cached(value="method.getDeclaringModule()") RubyModule declaringModule, @Cached(value="module") RubyModule cachedModule, @Cached(value="canBindMethodTo(method, cachedModule)") boolean canBindMethodTo) {
        return canBindMethodTo;
    }

    @Specialization
    static boolean canBindMethodToUncached(InternalMethod method, RubyModule module) {
        return CanBindMethodToModuleNode.canBindMethodTo(method, module);
    }

    protected static boolean canBindMethodTo(InternalMethod method, RubyModule module) {
        return ModuleOperations.canBindMethodTo(method, module);
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.BIND_CACHE;
    }
}

