/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.locals.WriteFrameSlotNode;
import org.truffleruby.language.locals.WriteFrameSlotNodeGen;
import org.truffleruby.language.locals.WriteLocalNode;

public final class WriteLocalVariableNode
extends WriteLocalNode {
    @Node.Child
    private WriteFrameSlotNode writeFrameSlotNode;

    public WriteLocalVariableNode(int frameSlot, RubyNode valueNode) {
        super(frameSlot, valueNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.valueNode.execute(frame);
        this.assign(frame, value);
        return value;
    }

    @Override
    public void assign(VirtualFrame frame, Object value) {
        if (this.writeFrameSlotNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.writeFrameSlotNode = (WriteFrameSlotNode)this.insert(WriteFrameSlotNodeGen.create(this.frameSlot));
        }
        this.writeFrameSlotNode.executeWrite((Frame)frame, value);
    }

    @Override
    public AssignableNode toAssignableNode() {
        this.valueNode = null;
        return WriteFrameSlotNodeGen.create(this.frameSlot);
    }

    @Override
    public AssignableNode cloneUninitializedAssignable() {
        return (AssignableNode)((Object)this.cloneUninitialized());
    }

    @Override
    protected String getVariableName() {
        return this.getRootNode().getFrameDescriptor().getSlotName(this.frameSlot).toString();
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getVariableName() + " = " + String.valueOf((Object)this.valueNode);
    }

    @Override
    public RubyNode cloneUninitialized() {
        WriteLocalVariableNode copy = new WriteLocalVariableNode(this.frameSlot, WriteLocalVariableNode.cloneUninitialized(this.valueNode));
        return copy.copyFlags(this);
    }
}

