/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.source.Source;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.loader.ByteBasedCharSequence;
import org.truffleruby.parser.MagicCommentParser;
import org.truffleruby.parser.RubySource;

public abstract class ResourceLoader {
    public static RubySource loadResource(String path, boolean internal) throws IOException {
        byte[] sourceBytes;
        assert (path.startsWith("resource:"));
        if (!path.toLowerCase(Locale.ENGLISH).endsWith(".rb")) {
            throw new FileNotFoundException(path);
        }
        String resourcePath = path.substring("resource:".length());
        try (InputStream stream = ResourceLoader.class.getResourceAsStream(resourcePath);){
            if (stream == null) {
                throw new FileNotFoundException(resourcePath);
            }
            sourceBytes = stream.readAllBytes();
        }
        TStringWithEncoding sourceTString = MagicCommentParser.createSourceTStringBasedOnMagicEncodingComment(sourceBytes, Encodings.UTF_8);
        Source source = Source.newBuilder((String)"ruby", (CharSequence)new ByteBasedCharSequence(sourceTString), (String)path).mimeType(RubyLanguage.getMimeType(false)).internal(internal).build();
        return new RubySource(source, path, sourceTString);
    }
}

