/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.cext.ValueWrapperManager;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.fiber.RubyFiber;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.WarningNode;
import org.truffleruby.language.constants.GetConstantNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.loader.CodeLoader;
import org.truffleruby.language.loader.FeatureLoader;
import org.truffleruby.language.loader.FileLoader;
import org.truffleruby.language.loader.ReentrantLockFreeingMap;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.TranslateExceptionNode;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubySource;
import org.truffleruby.shared.Metrics;

public abstract class RequireNode
extends RubyBaseNode {
    @Node.Child
    private IndirectCallNode callNode = IndirectCallNode.create();
    @Node.Child
    private DispatchNode isInLoadedFeatures = DispatchNode.create();
    @Node.Child
    private DispatchNode addToLoadedFeatures = DispatchNode.create();
    @Node.Child
    private DispatchNode relativeFeatureNode = DispatchNode.create();
    @Node.Child
    private WarningNode warningNode;

    public abstract boolean executeRequire(String var1, Object var2);

    @Specialization(guards={"libExpandedPathString.isRubyString(this, expandedPathString)"}, limit="1")
    boolean require(String feature, Object expandedPathString, @Cached RubyStringLibrary libExpandedPathString) {
        return this.requireWithMetrics(feature, expandedPathString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean requireWithMetrics(String feature, Object pathString) {
        String internedExpandedPath = RubyGuards.getJavaString(pathString).intern();
        this.requireMetric("before-require-" + feature);
        try {
            boolean bl = this.getContext().getMetricsProfiler().callWithMetrics("require", feature, () -> this.requireConsideringAutoload(feature, internedExpandedPath, pathString));
            return bl;
        }
        finally {
            this.requireMetric("after-require-" + feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requireConsideringAutoload(String feature, String expandedPath, Object pathString) {
        FeatureLoader featureLoader = this.getContext().getFeatureLoader();
        List<RubyConstant> constantsUnfiltered = featureLoader.getAutoloadConstants(expandedPath);
        ArrayList<RubyConstant> alreadyAutoloading = new ArrayList<RubyConstant>();
        if (!constantsUnfiltered.isEmpty()) {
            ArrayList<RubyConstant> toAutoload = new ArrayList<RubyConstant>();
            for (RubyConstant constant : constantsUnfiltered) {
                if (constant.getAutoloadConstant().isAutoloading()) {
                    alreadyAutoloading.add(constant);
                    continue;
                }
                toAutoload.add(constant);
            }
            if (this.getContext().getOptions().LOG_AUTOLOAD && !toAutoload.isEmpty()) {
                Object[] toAutoloadWithPath = new String[toAutoload.size()];
                for (int i = 0; i < toAutoload.size(); ++i) {
                    RubyConstant constant = (RubyConstant)toAutoload.get(i);
                    toAutoloadWithPath[i] = String.valueOf(constant) + " with " + constant.getAutoloadConstant().getAutoloadPath();
                }
                String info = StringUtils.join(toAutoloadWithPath, " and ");
                RubyLanguage.LOGGER.info(() -> String.format("%s: requiring %s which is registered as an autoload for %s", this.getContext().fileLine(this.getContext().getCallStack().getTopMostUserSourceSection()), feature, info));
            }
            for (RubyConstant constant : toAutoload) {
                GetConstantNode.autoloadConstantStart(this.getContext(), constant, this);
            }
        }
        try {
            boolean bl = this.doRequire(feature, expandedPath, pathString);
            return bl;
        }
        finally {
            List<RubyConstant> releasedConstants = featureLoader.getAutoloadConstants(expandedPath);
            for (RubyConstant constant : releasedConstants) {
                if (!constant.getAutoloadConstant().isAutoloadingThread() || alreadyAutoloading.contains(constant)) continue;
                boolean undefined = GetConstantNode.autoloadUndefineConstantIfStillAutoload(constant);
                GetConstantNode.logAutoloadResult(this.getContext(), constant, undefined);
                GetConstantNode.autoloadConstantStop(constant);
                featureLoader.removeAutoload(constant);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRequire(String originalFeature, String expandedPath, Object pathString) {
        ReentrantLock lock;
        Boolean patchLoaded;
        boolean isPatched;
        ReentrantLockFreeingMap<String> fileLocks = this.getContext().getFeatureLoader().getFileLocks();
        ConcurrentMap<String, Boolean> patchFiles = this.getContext().getCoreLibrary().getPatchFiles();
        ConcurrentMap<String, String> originalRequires = this.getContext().getCoreLibrary().getOriginalRequires();
        String relativeFeature = originalFeature;
        if (new File(originalFeature).isAbsolute()) {
            Object relativeFeatureString = this.relativeFeatureNode.call((Object)this.coreLibrary().truffleFeatureLoaderModule, "relative_feature", pathString);
            if (RubyStringLibrary.getUncached().isRubyString(this, relativeFeatureString)) {
                relativeFeature = RubyGuards.getJavaString(relativeFeatureString);
            }
        }
        boolean bl = isPatched = (patchLoaded = (Boolean)patchFiles.get(relativeFeature)) != null;
        do {
            if (!(lock = fileLocks.get(expandedPath)).isHeldByCurrentThread()) continue;
            if (isPatched && !patchLoaded.booleanValue()) {
                patchLoaded = true;
                patchFiles.put(relativeFeature, true);
                continue;
            }
            this.warnCircularRequire(expandedPath);
            return false;
        } while (!fileLocks.lock(this.getContext(), expandedPath, lock, this));
        try {
            if (isPatched && !patchLoaded.booleanValue()) {
                String expandedPatchPath = this.getLanguage().getRubyHome() + "/lib/patches/" + relativeFeature + ".rb";
                RubyLanguage.LOGGER.config("patch file used: " + expandedPatchPath);
                originalRequires.put(expandedPatchPath, expandedPath);
                try {
                    boolean loaded = this.parseAndCall(expandedPatchPath, expandedPatchPath);
                    assert (loaded);
                }
                finally {
                    originalRequires.remove(expandedPatchPath);
                }
                boolean originalLoaded = (Boolean)patchFiles.get(relativeFeature);
                if (!originalLoaded) {
                    this.addToLoadedFeatures(pathString);
                    patchFiles.put(relativeFeature, true);
                }
                boolean bl2 = true;
                return bl2;
            }
            if (this.isFeatureLoaded(pathString)) {
                boolean bl3 = false;
                return bl3;
            }
            if (!this.parseAndCall(originalFeature, expandedPath)) {
                boolean bl4 = false;
                return bl4;
            }
            this.addToLoadedFeatures(pathString);
            boolean bl5 = true;
            return bl5;
        }
        finally {
            fileLocks.unlock(expandedPath, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseAndCall(String feature, String expandedPath) {
        if (this.isCExtension(expandedPath)) {
            this.requireCExtension(feature, expandedPath, this);
        } else {
            RubySource rubySource;
            try {
                FileLoader fileLoader = new FileLoader(this.getContext(), this.getLanguage());
                rubySource = fileLoader.loadFile(expandedPath);
            }
            catch (IOException e) {
                return false;
            }
            RootCallTarget callTarget = this.getContext().getCodeLoader().parseTopLevelWithCache(rubySource, this);
            CodeLoader.DeferredCall deferredCall = this.getContext().getCodeLoader().prepareExecute(callTarget, ParserContext.TOP_LEVEL, DeclarationContext.topLevel(this.getContext()), null, (Object)this.coreLibrary().mainObject, this.getContext().getRootLexicalScope());
            this.requireMetric("before-execute-" + feature);
            try {
                this.getContext().getMetricsProfiler().callWithMetrics("execute", feature, () -> deferredCall.call(this.callNode));
            }
            finally {
                this.requireMetric("after-execute-" + feature);
            }
        }
        return true;
    }

    private boolean isCExtension(String path) {
        return path.toLowerCase(Locale.ENGLISH).endsWith(RubyLanguage.CEXT_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void requireCExtension(String feature, String expandedPath, Node currentNode) {
        Object library;
        FeatureLoader featureLoader = this.getContext().getFeatureLoader();
        try {
            featureLoader.ensureCExtImplementationLoaded(feature, this);
            if (this.getContext().getOptions().CEXTS_LOG_LOAD) {
                RubyLanguage.LOGGER.info(String.format("loading cext module %s (requested as %s)", expandedPath, feature));
            }
            library = featureLoader.loadCExtLibrary(feature, expandedPath, currentNode, this.getContext().getOptions().CEXTS_SULONG);
        }
        catch (Exception e) {
            this.handleCExtensionException(feature, e);
            throw e;
        }
        this.requireMetric("before-execute-" + feature);
        RubyFiber currentFiber = this.getLanguage().getCurrentFiber();
        ValueWrapperManager.allocateNewBlock(this.getContext(), this.getLanguage());
        RubyArray prevGlobals = currentFiber.cGlobalVariablesDuringInitFunction;
        currentFiber.cGlobalVariablesDuringInitFunction = this.createEmptyArray();
        try {
            RubyContext.send(currentNode, this.coreLibrary().truffleCExtModule, "init_extension", library, expandedPath);
        }
        finally {
            currentFiber.cGlobalVariablesDuringInitFunction = prevGlobals;
            ValueWrapperManager.allocateNewBlock(this.getContext(), this.getLanguage());
            this.requireMetric("after-execute-" + feature);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void handleCExtensionException(String feature, Exception e) {
        TranslateExceptionNode.logJavaException(this.getContext(), this, e);
        Throwable linkErrorException = this.searchForException("NFIUnsatisfiedLinkError", e);
        if (linkErrorException != null) {
            String linkError = linkErrorException.getMessage();
            if (this.getContext().getOptions().CEXTS_LOG_LOAD) {
                RubyLanguage.LOGGER.info("unsatisfied link error " + linkError);
            }
            String message = feature.equals("openssl.so") ? String.format("%s (%s)", "you may need to install the system OpenSSL library libssl - see https://github.com/oracle/truffleruby/blob/master/doc/user/installing-libssl.md", linkError) : linkError;
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().runtimeError(message, this));
        }
        Throwable linkerException = this.searchForException("LLVMLinkerException", e);
        if (linkerException != null) {
            String linkError = linkerException.getMessage();
            String home = this.getLanguage().getRubyHome();
            String postInstallHook = home + "/lib/truffle/post_install_hook.sh";
            String message = feature.contains("openssl") ? String.format("%s (%s)", "the OpenSSL C extension was compiled against a different libssl than the one used on this system - recompile by running " + postInstallHook, linkError) : linkError;
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().runtimeError(message, this));
        }
    }

    private Throwable searchForException(String exceptionClass, Throwable exception) {
        while (exception != null) {
            if (exception.getClass().getSimpleName().equals(exceptionClass)) {
                return exception;
            }
            exception = exception.getCause();
        }
        return null;
    }

    public boolean isFeatureLoaded(Object feature) {
        Object included = this.isInLoadedFeatures.call(this.coreLibrary().truffleFeatureLoaderModule, "feature_provided?", feature, (Object)true);
        return BooleanCastNode.executeUncached(included);
    }

    private void addToLoadedFeatures(Object feature) {
        this.addToLoadedFeatures.call((Object)this.coreLibrary().truffleFeatureLoaderModule, "provide_feature", feature);
    }

    private void warnCircularRequire(String path) {
        if (this.warningNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.warningNode = (WarningNode)this.insert(new WarningNode());
        }
        if (this.warningNode.shouldWarn()) {
            SourceSection sourceSection = this.getContext().getCallStack().getTopMostUserSourceSection();
            this.warningNode.warningMessage(sourceSection, "loading in progress, circular require considered harmful - " + path);
        }
    }

    private void requireMetric(String id) {
        if (Metrics.getMetricsTime() && this.getContext().getOptions().METRICS_TIME_REQUIRE) {
            Metrics.printTime((String)id);
        }
    }
}

