/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.loader.ByteBasedCharSequence;
import org.truffleruby.parser.MagicCommentParser;
import org.truffleruby.parser.RubySource;

public final class FileLoader {
    private final RubyContext context;
    private final RubyLanguage language;

    public FileLoader(RubyContext context, RubyLanguage language) {
        this.context = context;
        this.language = language;
    }

    public static void ensureReadable(RubyContext context, TruffleFile file, Node currentNode) {
        if (!file.exists(new LinkOption[0])) {
            throw new RaiseException(context, context.getCoreExceptions().loadError("No such file or directory -- " + String.valueOf(file), file.getPath(), currentNode));
        }
        if (!file.isReadable()) {
            throw new RaiseException(context, context.getCoreExceptions().loadError("Permission denied -- " + String.valueOf(file), file.getPath(), currentNode));
        }
    }

    public RubySource loadFile(String path) throws IOException {
        if (this.context.getOptions().LOG_LOAD) {
            RubyLanguage.LOGGER.info("loading " + path);
        }
        TruffleFile file = FileLoader.getSafeTruffleFile(this.language, this.context, path);
        FileLoader.ensureReadable(this.context, file, null);
        byte[] sourceBytes = file.readAllBytes();
        TStringWithEncoding sourceTString = MagicCommentParser.createSourceTStringBasedOnMagicEncodingComment(sourceBytes, Encodings.UTF_8);
        Source source = this.buildSource(file, path, sourceTString, this.isInternal(path), false);
        return new RubySource(source, path, sourceTString);
    }

    public static TruffleFile getSafeTruffleFile(RubyLanguage language, RubyContext context, String path) {
        TruffleFile file;
        TruffleLanguage.Env env = context.getEnv();
        if (env.isFileIOAllowed()) {
            return env.getPublicTruffleFile(path);
        }
        try {
            file = env.getInternalTruffleFile(path).getCanonicalFile(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new RaiseException(context, context.getCoreExceptions().loadError("Failed to canonicalize -- " + path, path, null));
        }
        TruffleFile home = language.getRubyHomeTruffleFile();
        if (file.startsWith(home.resolve("lib")) && FileLoader.isStdLibRubyOrCExtFile(file.getPath())) {
            return file;
        }
        try {
            return env.getPublicTruffleFile(path);
        }
        catch (SecurityException e) {
            throw new RaiseException(context, context.getCoreExceptions().loadError("Permission denied (" + e.getMessage() + ") -- " + path, path, null));
        }
    }

    private static boolean isStdLibRubyOrCExtFile(String path) {
        return path.endsWith(".rb") || path.endsWith(RubyLanguage.CEXT_EXTENSION);
    }

    Source buildSource(TruffleFile file, String path, TStringWithEncoding sourceTStringWithEncoding, boolean internal, boolean mainSource) {
        assert (file.getPath().equals(path));
        boolean coverageEnabled = this.language.coverageManager.isEnabled();
        String mimeType = mainSource ? "application/x-ruby;main-script=true" : RubyLanguage.getMimeType(coverageEnabled);
        Source source = Source.newBuilder((String)"ruby", (TruffleFile)file).canonicalizePath(false).mimeType(mimeType).content((CharSequence)new ByteBasedCharSequence(sourceTStringWithEncoding)).internal(internal).cached(!coverageEnabled).build();
        assert (source.getPath().equals(path)) : "Source#getPath() = " + source.getPath() + " is not the same as " + path;
        return source;
    }

    private boolean isInternal(String path) {
        String canonicalPath;
        try {
            canonicalPath = new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return false;
        }
        if (canonicalPath.startsWith(this.language.coreLoadPath)) {
            return this.language.options.CORE_AS_INTERNAL;
        }
        if (canonicalPath.startsWith(this.language.getRubyHome() + "/lib/") && !canonicalPath.startsWith(this.language.getRubyHome() + "/lib/gems/")) {
            return this.language.options.STDLIB_AS_INTERNAL;
        }
        return false;
    }
}

