/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.globals;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.basicobject.ReferenceEqualNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.globals.GlobalVariableStorage;
import org.truffleruby.language.globals.LookupGlobalVariableStorageNode;
import org.truffleruby.language.globals.WriteSimpleGlobalVariableNodeGen;
import org.truffleruby.language.objects.shared.WriteBarrierNode;

public abstract class WriteSimpleGlobalVariableNode
extends RubyBaseNode {
    protected final String name;

    @NeverDefault
    public static WriteSimpleGlobalVariableNode create(String name) {
        return WriteSimpleGlobalVariableNodeGen.create(name);
    }

    public WriteSimpleGlobalVariableNode(String name) {
        this.name = name;
    }

    public abstract Object execute(Object var1);

    @Specialization(guards={"isSingleContext()", "referenceEqualNode.execute(node, value, previousValue)"}, assumptions={"storage.getUnchangedAssumption()", "getLanguage().getGlobalVariableNeverAliasedAssumption(index)"}, limit="1")
    static Object writeTryToKeepConstant(Object value, @Cached ReferenceEqualNode referenceEqualNode, @Cached(value="getLanguage().getGlobalVariableIndex(name)", neverDefault=false) @Cached.Shared int index, @Cached(value="getContext().getGlobalVariableStorage(index)") GlobalVariableStorage storage, @Cached(value="storage.getValue()") Object previousValue, @Bind(value="this") Node node) {
        storage.setValueInternal(value);
        return previousValue;
    }

    @Specialization(guards={"isSingleContext()", "storage.isAssumeConstant()"}, assumptions={"storage.getUnchangedAssumption()", "getLanguage().getGlobalVariableNeverAliasedAssumption(index)"})
    Object writeAssumeConstant(Object value, @Cached @Cached.Shared WriteBarrierNode writeBarrierNode, @Cached(value="getLanguage().getGlobalVariableIndex(name)", neverDefault=false) @Cached.Shared int index, @Cached(value="getContext().getGlobalVariableStorage(index)") GlobalVariableStorage storage) {
        if (this.getContext().getSharedObjects().isSharing()) {
            writeBarrierNode.execute(this, value);
        }
        storage.setValueInternal(value);
        storage.updateAssumeConstant(this.getContext());
        return value;
    }

    @Specialization(replaces={"writeAssumeConstant"})
    Object writeAliasedOrMultiContext(Object value, @Cached @Cached.Shared WriteBarrierNode writeBarrierNode, @Cached(value="create(name)") LookupGlobalVariableStorageNode lookupGlobalVariableStorageNode) {
        if (this.getContext().getSharedObjects().isSharing()) {
            writeBarrierNode.execute(this, value);
        }
        GlobalVariableStorage storage = lookupGlobalVariableStorageNode.execute(null);
        storage.setValueInternal(value);
        if (storage.isAssumeConstant()) {
            storage.updateAssumeConstant(this.getContext());
        }
        return value;
    }
}

