/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.globals;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.kernel.TruffleKernelNodes;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.RubyContextSourceAssignableNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.globals.GlobalVariableStorage;
import org.truffleruby.language.globals.LookupGlobalVariableStorageNode;
import org.truffleruby.language.globals.WriteGlobalVariableNodeGen;
import org.truffleruby.language.globals.WriteSimpleGlobalVariableNode;
import org.truffleruby.language.yield.CallBlockNode;

@NodeChild(value="valueNode", type=RubyNode.class)
public abstract class WriteGlobalVariableNode
extends RubyContextSourceAssignableNode {
    protected final String name;
    @Node.Child
    LookupGlobalVariableStorageNode lookupGlobalVariableStorageNode;

    public WriteGlobalVariableNode(String name) {
        this.name = name;
        this.lookupGlobalVariableStorageNode = LookupGlobalVariableStorageNode.create(name);
    }

    public abstract Object execute(VirtualFrame var1, Object var2);

    @Override
    public void assign(VirtualFrame frame, Object value) {
        this.execute(frame, value);
    }

    @Specialization(guards={"storage.isSimple()"})
    Object write(VirtualFrame frame, Object value, @Bind(value="getStorage(frame)") GlobalVariableStorage storage, @Cached(value="create(name)") WriteSimpleGlobalVariableNode simpleNode) {
        simpleNode.execute(value);
        return value;
    }

    @Specialization(guards={"storage.hasHooks()", "arity != 2"})
    Object writeHooks(VirtualFrame frame, Object value, @Bind(value="getStorage(frame)") GlobalVariableStorage storage, @Bind(value="setterArity(storage)") int arity, @Cached @Cached.Exclusive CallBlockNode yieldNode) {
        yieldNode.yield(this, storage.getSetter(), value);
        return value;
    }

    @Specialization(guards={"storage.hasHooks()", "arity == 2"})
    static Object writeHooksWithStorage(VirtualFrame frame, Object value, @Bind(value="getStorage(frame)") GlobalVariableStorage storage, @Bind(value="setterArity(storage)") int arity, @Cached @Cached.Exclusive CallBlockNode yieldNode, @Cached TruffleKernelNodes.GetSpecialVariableStorage storageNode, @Bind(value="this") Node node) {
        yieldNode.yield(node, storage.getSetter(), value, storageNode.execute((Frame)frame, node));
        return value;
    }

    protected int setterArity(GlobalVariableStorage storage) {
        return storage.getSetter().getArityNumber();
    }

    protected GlobalVariableStorage getStorage(VirtualFrame dynamicArgument) {
        return this.lookupGlobalVariableStorageNode.execute(dynamicArgument);
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return FrozenStrings.ASSIGNMENT;
    }

    @Override
    public AssignableNode toAssignableNode() {
        WriteGlobalVariableNode node = WriteGlobalVariableNodeGen.create(this.name, null);
        node.copySourceSection(this);
        return node;
    }

    @Override
    public AssignableNode cloneUninitializedAssignable() {
        return (AssignableNode)((Object)this.cloneUninitialized());
    }

    abstract RubyNode getValueNode();

    @Override
    public RubyNode cloneUninitialized() {
        WriteGlobalVariableNode copy = WriteGlobalVariableNodeGen.create(this.name, WriteGlobalVariableNode.cloneUninitialized(this.getValueNode()));
        return copy.copyFlags(this);
    }
}

