/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.WarningNode;
import org.truffleruby.language.globals.GlobalVariableStorage;
import org.truffleruby.language.globals.LookupGlobalVariableStorageNode;
import org.truffleruby.language.globals.ReadSimpleGlobalVariableNodeGen;

public abstract class ReadSimpleGlobalVariableNode
extends RubyBaseNode {
    public final String name;
    @Node.Child
    LookupGlobalVariableStorageNode lookupGlobalVariableStorageNode;

    @NeverDefault
    public static ReadSimpleGlobalVariableNode create(String name) {
        return ReadSimpleGlobalVariableNodeGen.create(name);
    }

    public ReadSimpleGlobalVariableNode(String name) {
        this.name = name;
    }

    public abstract Object execute();

    @Specialization(guards={"isSingleContext()"}, assumptions={"storage.getUnchangedAssumption()", "getLanguage().getGlobalVariableNeverAliasedAssumption(index)"})
    Object readConstant(@Cached(value="getLanguage().getGlobalVariableIndex(name)", neverDefault=false) int index, @Cached(value="getContext().getGlobalVariableStorage(index)") GlobalVariableStorage storage, @Cached(value="storage.getValue()") Object value, @Cached(value="new()") @Cached.Shared WarningNode warningNode, @Cached(value="storage.isDefined()", neverDefault=false) boolean isDefined) {
        if (!isDefined && warningNode.shouldWarn()) {
            SourceSection sourceSection = this.getEncapsulatingSourceSection();
            String message = this.globalVariableNotInitializedMessageFor(this.name);
            warningNode.warningMessage(sourceSection, message);
        }
        return value;
    }

    @Specialization
    Object read(@Cached(value="new()") @Cached.Shared WarningNode warningNode, @Cached InlinedConditionProfile isDefinedProfile) {
        GlobalVariableStorage storage;
        Object rawValue;
        if (this.lookupGlobalVariableStorageNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookupGlobalVariableStorageNode = (LookupGlobalVariableStorageNode)this.insert(LookupGlobalVariableStorageNode.create(this.name));
        }
        if (isDefinedProfile.profile((Node)this, (rawValue = (storage = this.lookupGlobalVariableStorageNode.execute(null)).getRawValue()) != GlobalVariableStorage.UNSET_VALUE)) {
            return rawValue;
        }
        if (warningNode.shouldWarn()) {
            SourceSection sourceSection = this.getEncapsulatingSourceSection();
            String message = this.globalVariableNotInitializedMessageFor(this.name);
            warningNode.warningMessage(sourceSection, message);
        }
        return Nil.INSTANCE;
    }

    private String globalVariableNotInitializedMessageFor(String name) {
        return StringUtils.format("global variable `%s' not initialized", name);
    }
}

