/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.globals;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.kernel.TruffleKernelNodes;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.globals.GlobalVariableStorage;
import org.truffleruby.language.globals.IsDefinedGlobalVariableNodeGen;
import org.truffleruby.language.globals.LookupGlobalVariableStorageNode;
import org.truffleruby.language.yield.CallBlockNode;

public abstract class IsDefinedGlobalVariableNode
extends RubyBaseNode {
    @Node.Child
    LookupGlobalVariableStorageNode lookupGlobalVariableStorageNode;

    public static IsDefinedGlobalVariableNode create(String name) {
        return IsDefinedGlobalVariableNodeGen.create(name);
    }

    public IsDefinedGlobalVariableNode(String name) {
        this.lookupGlobalVariableStorageNode = LookupGlobalVariableStorageNode.create(name);
    }

    public abstract Object executeIsDefined(VirtualFrame var1);

    @Specialization(guards={"storage.isSimple()"})
    Object simple(VirtualFrame frame, @Bind(value="getStorage(frame)") GlobalVariableStorage storage) {
        if (storage.isDefined()) {
            return FrozenStrings.GLOBAL_VARIABLE;
        }
        return nil;
    }

    @Specialization(guards={"storage.hasHooks()", "arity == 0"})
    static Object hooks(VirtualFrame frame, @Cached(value="getLanguage().getGlobalVariableIndex(lookupGlobalVariableStorageNode.name)") int index, @Bind(value="getStorage(frame)") GlobalVariableStorage storage, @Cached(value="isDefinedArity(storage)") int arity, @Cached @Cached.Exclusive CallBlockNode yieldNode, @Bind(value="this") Node node) {
        return yieldNode.yield(node, storage.getIsDefined(), new Object[0]);
    }

    @Specialization(guards={"storage.hasHooks()", "arity == 1"})
    static Object hooksWithBinding(VirtualFrame frame, @Bind(value="getStorage(frame)") GlobalVariableStorage storage, @Cached(value="isDefinedArity(storage)") int arity, @Cached @Cached.Exclusive CallBlockNode yieldNode, @Cached TruffleKernelNodes.GetSpecialVariableStorage readStorage, @Bind(value="this") Node node) {
        return yieldNode.yield(node, storage.getIsDefined(), readStorage.execute((Frame)frame, node));
    }

    protected int isDefinedArity(GlobalVariableStorage storage) {
        return storage.getIsDefined().getArityNumber();
    }

    protected GlobalVariableStorage getStorage(VirtualFrame dynamicArgument) {
        return this.lookupGlobalVariableStorageNode.execute(dynamicArgument);
    }
}

