/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.dispatch;

import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;

public final class RubyCallNodeParameters {
    private final RubyNode receiver;
    private final String methodName;
    private final RubyNode block;
    private final ArgumentsDescriptor descriptor;
    private final RubyNode[] arguments;
    private final boolean isSplatted;
    private final boolean ignoreVisibility;
    private final boolean isVCall;
    private final boolean isSafeNavigation;
    private final boolean isAttrAssign;

    public RubyCallNodeParameters(RubyNode receiver, String methodName, RubyNode block, ArgumentsDescriptor descriptor, RubyNode[] arguments, boolean ignoreVisibility) {
        this(receiver, methodName, block, descriptor, arguments, false, ignoreVisibility, false, false, false);
    }

    public RubyCallNodeParameters(RubyNode receiver, String methodName, RubyNode block, ArgumentsDescriptor descriptor, RubyNode[] arguments, boolean isSplatted, boolean ignoreVisibility, boolean isVCall, boolean isSafeNavigation, boolean isAttrAssign) {
        this.receiver = receiver;
        this.methodName = methodName;
        this.block = block;
        this.descriptor = descriptor;
        this.arguments = arguments;
        this.isSplatted = isSplatted;
        this.ignoreVisibility = ignoreVisibility;
        this.isVCall = isVCall;
        this.isSafeNavigation = isSafeNavigation;
        this.isAttrAssign = isAttrAssign;
    }

    public String toString() {
        return "RubyCallNodeParameters{methodName='" + this.methodName + "', descriptor=" + String.valueOf(this.descriptor) + ", isSplatted=" + this.isSplatted + ", ignoreVisibility=" + this.ignoreVisibility + ", isVCall=" + this.isVCall + ", isSafeNavigation=" + this.isSafeNavigation + ", isAttrAssign=" + this.isAttrAssign + "}";
    }

    public RubyCallNodeParameters withReceiverAndArguments(RubyNode receiver, RubyNode[] arguments, RubyNode block) {
        return new RubyCallNodeParameters(receiver, this.methodName, block, this.descriptor, arguments, this.isSplatted, this.ignoreVisibility, this.isVCall, this.isSafeNavigation, this.isAttrAssign);
    }

    public RubyCallNodeParameters withBlock(RubyNode block) {
        return this.withReceiverAndArguments(this.receiver, this.arguments, block);
    }

    public RubyCallNodeParameters withoutNodes() {
        return new RubyCallNodeParameters(null, this.methodName, null, this.descriptor, null, this.isSplatted, this.ignoreVisibility, this.isVCall, this.isSafeNavigation, this.isAttrAssign);
    }

    public RubyNode getReceiver() {
        return this.receiver;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public RubyNode getBlock() {
        return this.block;
    }

    public ArgumentsDescriptor getDescriptor() {
        return this.descriptor;
    }

    public RubyNode[] getArguments() {
        return this.arguments;
    }

    public boolean isSplatted() {
        return this.isSplatted;
    }

    public boolean isIgnoreVisibility() {
        return this.ignoreVisibility;
    }

    public boolean isVCall() {
        return this.isVCall;
    }

    public boolean isSafeNavigation() {
        return this.isSafeNavigation;
    }

    public boolean isAttrAssign() {
        return this.isAttrAssign;
    }
}

