/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.dispatch;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.LiteralCallAssignableNode;

@GeneratedBy(value=LiteralCallAssignableNode.class)
final class LiteralCallAssignableNodeWrapper
extends LiteralCallAssignableNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private LiteralCallAssignableNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    LiteralCallAssignableNodeWrapper(LiteralCallAssignableNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public LiteralCallAssignableNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public AssignableNode toAssignableNode() {
        return this.delegateNode.toAssignableNode();
    }

    @Override
    public void assign(VirtualFrame frame, Object value) {
        this.delegateNode.assign(frame, value);
    }

    @Override
    public AssignableNode cloneUninitializedAssignable() {
        return this.delegateNode.cloneUninitializedAssignable();
    }

    @Override
    public RubyNode cloneUninitialized() {
        return this.delegateNode.cloneUninitialized();
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return this.delegateNode.isDefined(frame, language, context);
    }
}

