/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.dispatch;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.LookupMethodNode;
import org.truffleruby.language.methods.LookupMethodNodeGen;
import org.truffleruby.language.objects.MetaClassNode;
import org.truffleruby.language.objects.MetaClassNodeGen;

public class InternalRespondToNode
extends RubyBaseNode {
    public static final DispatchConfiguration PUBLIC = DispatchConfiguration.PUBLIC;
    public final DispatchConfiguration config;
    @Node.Child
    protected MetaClassNode metaclassNode;
    @Node.Child
    protected LookupMethodNode methodLookup;

    @NeverDefault
    public static InternalRespondToNode create(DispatchConfiguration config) {
        return new InternalRespondToNode(config);
    }

    @NeverDefault
    public static InternalRespondToNode create() {
        return new InternalRespondToNode(DispatchConfiguration.PRIVATE);
    }

    public static InternalRespondToNode getUncached(DispatchConfiguration config) {
        CompilerAsserts.neverPartOfCompilation((String)"uncached");
        return Uncached.UNCACHED_NODES[config.ordinal()];
    }

    public static InternalRespondToNode getUncached() {
        return InternalRespondToNode.getUncached(DispatchConfiguration.PRIVATE);
    }

    protected InternalRespondToNode(DispatchConfiguration config, MetaClassNode metaclassNode, LookupMethodNode methodLookup) {
        this.config = config;
        this.metaclassNode = metaclassNode;
        this.methodLookup = methodLookup;
    }

    protected InternalRespondToNode(DispatchConfiguration config) {
        this(config, MetaClassNode.create(), LookupMethodNode.create());
    }

    public boolean execute(Frame frame, Object receiver, String methodName) {
        return InternalRespondToNode.executeInternal(frame, receiver, methodName, this.config, this.metaclassNode, this.methodLookup);
    }

    protected static boolean executeInternal(Frame frame, Object receiver, String methodName, DispatchConfiguration config, MetaClassNode metaclassNode, LookupMethodNode methodLookup) {
        RubyClass metaclass = metaclassNode.executeCached(receiver);
        InternalMethod method = methodLookup.execute(frame, metaclass, methodName, config);
        return method != null && method.isDefined() && method.isImplemented();
    }

    @DenyReplace
    private static final class Uncached
    extends InternalRespondToNode {
        static final Uncached[] UNCACHED_NODES = new Uncached[DispatchConfiguration.values().length];

        protected Uncached(DispatchConfiguration config) {
            super(config, null, null);
        }

        @Override
        public boolean execute(Frame frame, Object receiver, String methodName) {
            return Uncached.executeInternal(frame, receiver, methodName, this.config, MetaClassNodeGen.getUncached(), LookupMethodNodeGen.getUncached());
        }

        public boolean isAdoptable() {
            return false;
        }

        static {
            for (DispatchConfiguration config : DispatchConfiguration.values()) {
                Uncached.UNCACHED_NODES[config.ordinal()] = new Uncached(config);
            }
        }
    }
}

