/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.kernel.TruffleKernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.SpecialVariablesSendingNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNodeGen;
import org.truffleruby.language.dispatch.LazyDispatchMethodMissingNode;
import org.truffleruby.language.methods.CallInternalMethodNode;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.LookupMethodNode;
import org.truffleruby.language.objects.MetaClassNode;
import org.truffleruby.options.Options;

@ImportStatic(value={Assumption.class})
@GenerateUncached
public abstract class DispatchNode
extends SpecialVariablesSendingNode {
    public static final Missing MISSING = new Missing();

    @NeverDefault
    public static DispatchNode create() {
        return DispatchNodeGen.create();
    }

    @NeverDefault
    public static DispatchNode getUncached() {
        return DispatchNodeGen.getUncached();
    }

    public abstract Object execute(Frame var1, Object var2, String var3, Object[] var4, DispatchConfiguration var5);

    public Object call(DispatchConfiguration config, Object receiver, String method) {
        Object[] rubyArgs = RubyArguments.allocate(0);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        return this.execute(null, receiver, method, rubyArgs, config);
    }

    public Object call(Object receiver, String method) {
        Object[] rubyArgs = RubyArguments.allocate(0);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        return this.execute(null, receiver, method, rubyArgs, DispatchConfiguration.PRIVATE);
    }

    public Object call(DispatchConfiguration config, Object receiver, String method, Object arg1) {
        Object[] rubyArgs = RubyArguments.allocate(1);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        return this.execute(null, receiver, method, rubyArgs, config);
    }

    public Object call(Object receiver, String method, Object arg1) {
        Object[] rubyArgs = RubyArguments.allocate(1);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        return this.execute(null, receiver, method, rubyArgs, DispatchConfiguration.PRIVATE);
    }

    public Object call(DispatchConfiguration config, Object receiver, String method, Object arg1, Object arg2) {
        Object[] rubyArgs = RubyArguments.allocate(2);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        RubyArguments.setArgument(rubyArgs, 1, arg2);
        return this.execute(null, receiver, method, rubyArgs, config);
    }

    public Object call(Object receiver, String method, Object arg1, Object arg2) {
        Object[] rubyArgs = RubyArguments.allocate(2);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        RubyArguments.setArgument(rubyArgs, 1, arg2);
        return this.execute(null, receiver, method, rubyArgs, DispatchConfiguration.PRIVATE);
    }

    public Object call(Object receiver, String method, Object arg1, Object arg2, Object arg3) {
        Object[] rubyArgs = RubyArguments.allocate(3);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        RubyArguments.setArgument(rubyArgs, 1, arg2);
        RubyArguments.setArgument(rubyArgs, 2, arg3);
        return this.execute(null, receiver, method, rubyArgs, DispatchConfiguration.PRIVATE);
    }

    public Object call(DispatchConfiguration config, Object receiver, String method, Object[] arguments) {
        Object[] rubyArgs = RubyArguments.allocate(arguments.length);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArguments(rubyArgs, arguments);
        return this.execute(null, receiver, method, rubyArgs, config);
    }

    public Object call(Object receiver, String method, Object[] arguments) {
        Object[] rubyArgs = RubyArguments.allocate(arguments.length);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArguments(rubyArgs, arguments);
        return this.execute(null, receiver, method, rubyArgs, DispatchConfiguration.PRIVATE);
    }

    public Object callWithKeywords(Object receiver, String method, Object arg1, RubyHash keywords) {
        Object[] rubyArgs = RubyArguments.allocate(2);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, KeywordArgumentsDescriptor.EMPTY);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        RubyArguments.setArgument(rubyArgs, 1, keywords);
        return this.execute(null, receiver, method, rubyArgs, DispatchConfiguration.PRIVATE);
    }

    public Object callWithBlock(Object receiver, String method, Object block) {
        Object[] rubyArgs = RubyArguments.allocate(0);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, block);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        return this.execute(null, receiver, method, rubyArgs, DispatchConfiguration.PRIVATE);
    }

    public Object callWithBlock(Object receiver, String method, Object block, Object arg1) {
        Object[] rubyArgs = RubyArguments.allocate(1);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, block);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        return this.execute(null, receiver, method, rubyArgs, DispatchConfiguration.PRIVATE);
    }

    public Object callWithBlock(DispatchConfiguration config, Object receiver, String method, Object block, Object arg1, Object arg2) {
        Object[] rubyArgs = RubyArguments.allocate(2);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, block);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        RubyArguments.setArgument(rubyArgs, 1, arg2);
        return this.execute(null, receiver, method, rubyArgs, config);
    }

    public Object callWithBlock(DispatchConfiguration config, Object receiver, String method, Object block, Object arg1, Object arg2, Object arg3) {
        Object[] rubyArgs = RubyArguments.allocate(3);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, block);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        RubyArguments.setArgument(rubyArgs, 1, arg2);
        RubyArguments.setArgument(rubyArgs, 2, arg3);
        return this.execute(null, receiver, method, rubyArgs, config);
    }

    public Object callWithDescriptor(Object receiver, String method, Object block, ArgumentsDescriptor descriptor, Object[] arguments) {
        Object[] rubyArgs = RubyArguments.allocate(arguments.length);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, block);
        RubyArguments.setDescriptor(rubyArgs, descriptor);
        RubyArguments.setArguments(rubyArgs, arguments);
        return this.execute(null, receiver, method, rubyArgs, DispatchConfiguration.PRIVATE);
    }

    public Object callWithFrame(Frame frame, Object receiver, String method) {
        return this.callWithFrame(DispatchConfiguration.PRIVATE, frame, receiver, method);
    }

    public Object callWithFrame(DispatchConfiguration config, Frame frame, Object receiver, String method) {
        Object[] rubyArgs = RubyArguments.allocate(0);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        return this.execute(frame, receiver, method, rubyArgs, config);
    }

    public Object callWithFrame(DispatchConfiguration config, Frame frame, Object receiver, String method, Object arg1) {
        Object[] rubyArgs = RubyArguments.allocate(1);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        return this.execute(frame, receiver, method, rubyArgs, config);
    }

    public Object callWithFrame(DispatchConfiguration config, Frame frame, Object receiver, String method, Object arg1, Object arg2) {
        Object[] rubyArgs = RubyArguments.allocate(2);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        RubyArguments.setArgument(rubyArgs, 1, arg2);
        return this.execute(frame, receiver, method, rubyArgs, config);
    }

    public Object callWithFrame(DispatchConfiguration config, Frame frame, Object receiver, String method, Object arg1, Object arg2, Object arg3) {
        Object[] rubyArgs = RubyArguments.allocate(3);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArgument(rubyArgs, 0, arg1);
        RubyArguments.setArgument(rubyArgs, 1, arg2);
        RubyArguments.setArgument(rubyArgs, 2, arg3);
        return this.execute(frame, receiver, method, rubyArgs, config);
    }

    public Object callWithFrame(DispatchConfiguration config, Frame frame, Object receiver, String method, Object[] arguments) {
        Object[] rubyArgs = RubyArguments.allocate(arguments.length);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, nil);
        RubyArguments.setDescriptor(rubyArgs, NoKeywordArgumentsDescriptor.INSTANCE);
        RubyArguments.setArguments(rubyArgs, arguments);
        return this.execute(frame, receiver, method, rubyArgs, config);
    }

    public final Object callWithFrameAndBlock(DispatchConfiguration config, Frame frame, Object receiver, String methodName, Object block, ArgumentsDescriptor descriptor, Object[] arguments) {
        Object[] rubyArgs = RubyArguments.allocate(arguments.length);
        RubyArguments.setSelf(rubyArgs, receiver);
        RubyArguments.setBlock(rubyArgs, block);
        RubyArguments.setDescriptor(rubyArgs, descriptor);
        RubyArguments.setArguments(rubyArgs, arguments);
        return this.execute(frame, receiver, methodName, rubyArgs, config);
    }

    @Specialization
    Object dispatch(Frame frame, Object receiver, String methodName, Object[] rubyArgs, DispatchConfiguration config, @Cached(value="getSpecialVariableAssumption(frame)", uncached="ALWAYS_VALID") Assumption specialVariableAssumption, @Cached MetaClassNode metaClassNode, @Cached LookupMethodNode lookupMethodNode, @Cached InlinedConditionProfile methodMissing, @Cached CallInternalMethodNode callNode, @Cached TruffleKernelNodes.GetSpecialVariableStorage readingNode, @Cached LazyDispatchMethodMissingNode lazyDispatchMethodMissingNode) {
        assert (RubyArguments.getSelf(rubyArgs) == receiver);
        CompilerAsserts.partialEvaluationConstant((Object)((Object)config));
        RubyClass metaclass = metaClassNode.execute(this, receiver);
        InternalMethod method = lookupMethodNode.execute(frame, metaclass, methodName, config);
        if (methodMissing.profile((Node)this, method == null || method.isUndefined())) {
            return lazyDispatchMethodMissingNode.get(this).execute(frame, receiver, methodName, rubyArgs, config);
        }
        RubyArguments.setMethod(rubyArgs, method);
        if (!specialVariableAssumption.isValid()) {
            RubyArguments.setCallerSpecialVariables(rubyArgs, readingNode.execute(frame, this));
        }
        assert (RubyArguments.assertFrameArguments(rubyArgs));
        return callNode.execute(frame, method, receiver, rubyArgs);
    }

    public final void applySplittingInliningStrategy(RootCallTarget callTarget, String methodName, DirectCallNode callNode) {
        Options options = this.getContext().getOptions();
        boolean isMethodMissing = methodName.equals("method_missing");
        if (callNode.isCallTargetCloningAllowed() && (RubyRootNode.of(callTarget).shouldAlwaysClone() || isMethodMissing && options.METHODMISSING_ALWAYS_CLONE)) {
            callNode.cloneCallTarget();
        }
        if (callNode.isInlinable() && isMethodMissing && options.METHODMISSING_ALWAYS_INLINE) {
            callNode.forceInlining();
        }
    }

    private static final class Missing
    implements TruffleObject {
        private Missing() {
        }
    }
}

