/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.control;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.IfElseNodeGen;
import org.truffleruby.language.control.UnlessNodeGen;

public abstract class UnlessNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode condition;
    @Node.Child
    private RubyNode thenBody;

    public UnlessNode(RubyNode condition, RubyNode thenBody) {
        this.condition = condition;
        this.thenBody = thenBody;
    }

    @Specialization
    Object doUnless(VirtualFrame frame, @Cached InlinedCountingConditionProfile conditionProfile, @Cached BooleanCastNode booleanCastNode) {
        if (!conditionProfile.profile((Node)this, booleanCastNode.execute(this, this.condition.execute(frame)))) {
            return this.thenBody.execute(frame);
        }
        return nil;
    }

    @Override
    public boolean canSubsumeFollowing() {
        return !this.thenBody.isContinuable();
    }

    @Override
    public RubyNode subsumeFollowing(RubyNode following) {
        return IfElseNodeGen.create(this.condition, following, this.thenBody).copySourceSection(this);
    }

    @Override
    public RubyNode simplifyAsTailExpression() {
        return UnlessNodeGen.create(this.condition, this.thenBody.simplifyAsTailExpression()).copySourceSection(this);
    }

    @Override
    public RubyNode cloneUninitialized() {
        UnlessNode copy = UnlessNodeGen.create(this.condition.cloneUninitialized(), this.thenBody.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

