/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.Objects;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

public final class OnceNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode child;
    private final Holder holder = new Holder();

    public OnceNode(RubyNode child) {
        this.child = child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.holder.cachedValue;
        if (value == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            OnceNode onceNode = this;
            synchronized (onceNode) {
                value = this.holder.cachedValue;
                if (value == null) {
                    value = this.holder.cachedValue = Objects.requireNonNull(this.child.execute(frame));
                }
            }
        }
        return value;
    }

    @Override
    public RubyNode cloneUninitialized() {
        OnceNode copy = new OnceNode(this.child.cloneUninitialized());
        return copy.copyFlags(this);
    }

    static class Holder {
        @CompilerDirectives.CompilationFinal
        private volatile Object cachedValue;

        Holder() {
        }
    }
}

