/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.control;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.IfElseNodeGen;

public abstract class IfElseNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode condition;
    @Node.Child
    private RubyNode thenBody;
    @Node.Child
    private RubyNode elseBody;

    public IfElseNode(RubyNode condition, RubyNode thenBody, RubyNode elseBody) {
        this.condition = condition;
        this.thenBody = thenBody;
        this.elseBody = elseBody;
    }

    @Specialization
    Object doIfElse(VirtualFrame frame, @Cached InlinedCountingConditionProfile conditionProfile, @Cached BooleanCastNode booleanCastNode) {
        boolean conditionAsBoolean = booleanCastNode.execute(this, this.condition.execute(frame));
        if (conditionProfile.profile((Node)this, conditionAsBoolean)) {
            return this.thenBody.execute(frame);
        }
        return this.elseBody.execute(frame);
    }

    @Override
    public boolean isContinuable() {
        return this.thenBody.isContinuable() || this.elseBody.isContinuable();
    }

    @Override
    public RubyNode simplifyAsTailExpression() {
        RubyNode newThen = this.thenBody.simplifyAsTailExpression();
        RubyNode newElse = this.elseBody.simplifyAsTailExpression();
        return IfElseNodeGen.create(this.condition, newThen, newElse).copySourceSection(this);
    }

    @Override
    public RubyNode cloneUninitialized() {
        IfElseNode copy = IfElseNodeGen.create(this.condition.cloneUninitialized(), this.thenBody.cloneUninitialized(), this.elseBody.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

