/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.WarnNode;

public final class WarnDeprecatedConstantNode
extends RubyBaseNode {
    @Node.Child
    private WarnNode warnNode;

    public void warnDeprecatedConstant(RubyModule module, String name) {
        if (this.warnNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.warnNode = (WarnNode)this.insert(new WarnNode());
        }
        if (this.warnNode.shouldWarnForDeprecation()) {
            this.warnNode.warningMessage(WarnDeprecatedConstantNode.getSection(this), WarnDeprecatedConstantNode.formatMessage(this, module, name));
        }
    }

    public static void warnDeprecatedConstant(Node node, WarnNode warnNode, RubyModule module, String name) {
        if (warnNode.shouldWarnForDeprecation()) {
            warnNode.warningMessage(WarnDeprecatedConstantNode.getSection(node), WarnDeprecatedConstantNode.formatMessage(node, module, name));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static SourceSection getSection(Node node) {
        return WarnDeprecatedConstantNode.getContext(node).getCallStack().getTopMostUserSourceSection(WarnDeprecatedConstantNode.getAdoptedNode(node).getEncapsulatingSourceSection());
    }

    @CompilerDirectives.TruffleBoundary
    private static String formatMessage(Node node, RubyModule module, String name) {
        String fullyQualifiedName = ModuleOperations.constantName(WarnDeprecatedConstantNode.getContext(node), module, name);
        return "constant " + fullyQualifiedName + " is deprecated";
    }
}

